/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.conflict;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.ODatabaseComplex;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.orientechnologies.orient.server.OServerMain;
import com.orientechnologies.orient.server.config.OServerUserConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.conflict.OReplicationConflictResolver;
import java.util.List;

public class ODefaultReplicationConflictResolver
implements OReplicationConflictResolver {
    private static final String DISTRIBUTED_CONFLICT_CLASS = "ODistributedConflict";
    private static final String FIELD_RECORD = "record";
    private static final String FIELD_NODE = "node";
    private static final String FIELD_DATE = "date";
    private static final String FIELD_OPERATION = "operation";
    private static final String FIELD_OTHER_RID = "otherRID";
    private static final String FIELD_CURRENT_VERSION = "currentVersion";
    private static final String FIELD_OTHER_VERSION = "otherVersion";
    private boolean ignoreIfSameContent;
    private boolean ignoreIfMergeOk;
    private boolean latestAlwaysWin;
    private ODatabaseComplex<?> database;
    private OIndex<?> index = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startup(ODistributedServerManager iDManager, String iDatabaseName) {
        ODefaultReplicationConflictResolver oDefaultReplicationConflictResolver = this;
        synchronized (oDefaultReplicationConflictResolver) {
            if (this.index != null) {
                return;
            }
            OServerUserConfiguration replicatorUser = OServerMain.server().getUser("replicator");
            this.database = OServerMain.server().openDatabase("document", iDatabaseName, replicatorUser.name, replicatorUser.password);
            OClass cls = this.database.getMetadata().getSchema().getClass(DISTRIBUTED_CONFLICT_CLASS);
            if (cls == null) {
                cls = this.database.getMetadata().getSchema().createClass(DISTRIBUTED_CONFLICT_CLASS);
                this.index = cls.createProperty(FIELD_RECORD, OType.LINK).createIndex(OClass.INDEX_TYPE.UNIQUE);
            } else {
                OProperty p = cls.getProperty(FIELD_RECORD);
                this.index = p == null ? cls.createProperty(FIELD_RECORD, OType.LINK).createIndex(OClass.INDEX_TYPE.UNIQUE) : p.getIndex();
            }
        }
    }

    @Override
    public void shutdown() {
        if (this.database != null) {
            this.database.close();
        }
        if (this.index != null) {
            this.index = null;
        }
    }

    @Override
    public void handleCreateConflict(String iRemoteNode, ORecordId iCurrentRID, ORecordId iOtherRID) {
        OLogManager.instance().warn((Object)this, "CONFLICT against node %s CREATE record %s (other RID=%s)...", new Object[]{iRemoteNode, iCurrentRID, iOtherRID});
        if (!this.existConflictsForRecord(iCurrentRID)) {
            ODocument doc = this.createConflictDocument((byte)3, iCurrentRID, iRemoteNode);
            doc.field(FIELD_OTHER_RID, (Object)iOtherRID);
            doc.save();
        }
    }

    @Override
    public void handleUpdateConflict(String iRemoteNode, ORecordId iCurrentRID, int iCurrentVersion, int iOtherVersion) {
        OLogManager.instance().warn((Object)this, "CONFLICT against node %s UDPATE record %s (current=v%d, other=v%d)...", new Object[]{iRemoteNode, iCurrentRID, iCurrentVersion, iOtherVersion});
        if (!this.existConflictsForRecord(iCurrentRID)) {
            ODocument doc = this.createConflictDocument((byte)1, iCurrentRID, iRemoteNode);
            doc.field(FIELD_CURRENT_VERSION, (Object)iCurrentVersion);
            doc.field(FIELD_OTHER_VERSION, (Object)iOtherVersion);
            doc.save();
        }
    }

    @Override
    public void handleDeleteConflict(String iRemoteNode, ORecordId iCurrentRID) {
        OLogManager.instance().warn((Object)this, "CONFLICT against node %s DELETE record %s (cannot be deleted on other node)", new Object[]{iRemoteNode, iCurrentRID});
        if (!this.existConflictsForRecord(iCurrentRID)) {
            ODocument doc = this.createConflictDocument((byte)2, iCurrentRID, iRemoteNode);
            doc.save();
        }
    }

    @Override
    public void handleCommandConflict(String iRemoteNode, OCommandRequest iCommand, Object iLocalResult, Object iRemoteResult) {
        OLogManager.instance().warn((Object)this, "CONFLICT against node %s COMMAND execution %s result local=%s, remote=%s", new Object[]{iRemoteNode, iCommand, iLocalResult, iRemoteResult});
    }

    @Override
    public ODocument getAllConflicts() {
        ODatabaseRecordThreadLocal.INSTANCE.set((Object)((ODatabaseRecord)this.database));
        List entries = this.database.query((OQuery)new OSQLSynchQuery("select from ODistributedConflict"), new Object[0]);
        ODocument result = new ODocument().field("entries", (Object)entries);
        for (int i = 0; i < entries.size(); ++i) {
            ODocument record = (ODocument)((OIdentifiable)entries.get(i)).getRecord();
            record.setClassName(null);
            record.addOwner((ORecordElement)result);
            record.getIdentity().reset();
            entries.set(i, record);
        }
        return result;
    }

    @Override
    public boolean existConflictsForRecord(ORecordId iRID) {
        ODatabaseRecordThreadLocal.INSTANCE.set((Object)((ODatabaseRecord)this.database));
        if (this.index.contains((Object)iRID)) {
            OLogManager.instance().warn((Object)this, "Conflict already present for record %s, skip it", new Object[]{iRID});
            return true;
        }
        return false;
    }

    protected ODocument createConflictDocument(byte iOperation, ORecordId iRid, String iServerNode) {
        ODatabaseRecordThreadLocal.INSTANCE.set((Object)((ODatabaseRecord)this.database));
        ODocument doc = new ODocument(DISTRIBUTED_CONFLICT_CLASS);
        doc.field(FIELD_OPERATION, (Object)iOperation);
        doc.field(FIELD_DATE, (Object)System.currentTimeMillis());
        doc.field(FIELD_RECORD, (Object)iRid);
        doc.field(FIELD_NODE, (Object)iServerNode);
        return doc;
    }
}

