/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.config.OServerCommandConfiguration;
import com.orientechnologies.orient.server.config.OServerParameterConfiguration;
import com.orientechnologies.orient.server.network.protocol.ONetworkProtocol;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommand;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;

public class OServerNetworkListener
extends Thread {
    private ServerSocket serverSocket;
    private InetSocketAddress inboundAddr;
    private Class<? extends ONetworkProtocol> protocolType;
    private volatile boolean active = true;
    private OServerCommand[] commands;
    private int socketBufferSize;
    private OContextConfiguration configuration;
    private OServer server;
    private ONetworkProtocol protocol;

    public OServerNetworkListener(OServer iServer, String iHostName, String iHostPortRange, String iProtocolName, Class<? extends ONetworkProtocol> iProtocol, OServerParameterConfiguration[] iParameters, OServerCommandConfiguration[] iCommands) {
        super(Orient.getThreadGroup(), "OrientDB " + iProtocol.getSimpleName() + " listen at " + iHostName + ":" + iHostPortRange);
        this.server = iServer;
        this.listen(iHostName, iHostPortRange, iProtocolName);
        this.protocolType = iProtocol;
        this.readParameters(iServer.getContextConfiguration(), iParameters);
        if (iCommands != null) {
            this.commands = new OServerCommand[iCommands.length];
            for (int i = 0; i < iCommands.length; ++i) {
                try {
                    Constructor<?> c = Class.forName(iCommands[i].implementation).getConstructor(OServerCommandConfiguration.class);
                    this.commands[i] = (OServerCommand)c.newInstance(iCommands[i]);
                    continue;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Cannot create custom command '" + iCommands[i] + "'", e);
                }
            }
        }
        this.start();
    }

    public void shutdown() {
        this.active = false;
        if (this.protocol != null) {
            this.protocol.sendShutdown();
            this.protocol = null;
        }
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void listen(String iHostName, String iHostPortRange, String iProtocolName) {
        int[] ports;
        for (int port : ports = OServerNetworkListener.getPorts(iHostPortRange)) {
            this.inboundAddr = new InetSocketAddress(iHostName, port);
            try {
                this.serverSocket = new ServerSocket(port, 0, InetAddress.getByName(iHostName));
                if (!this.serverSocket.isBound()) continue;
                OLogManager.instance().info((Object)this, "Listening " + iProtocolName + " connections on " + this.inboundAddr.getHostName() + ":" + this.inboundAddr.getPort(), new Object[0]);
                return;
            }
            catch (BindException be) {
                OLogManager.instance().info((Object)this, "Port %s:%d busy, trying the next available...", new Object[]{iHostName, port});
            }
            catch (SocketException se) {
                OLogManager.instance().error((Object)this, "Unable to create socket", (Throwable)se, new Object[0]);
                System.exit(1);
            }
            catch (IOException ioe) {
                OLogManager.instance().error((Object)this, "Unable to read data from an open socket", (Throwable)ioe, new Object[0]);
                System.err.println("Unable to read data from an open socket.");
                System.exit(1);
            }
        }
        OLogManager.instance().error((Object)this, "Unable to listen for connections using the configured ports '%s' on host '%s'", new Object[]{iHostPortRange, iHostName});
        System.exit(1);
    }

    public boolean isActive() {
        return this.active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block14: {
            block11: while (true) {
                if (!this.active) break block14;
                try {
                    Socket socket = this.serverSocket.accept();
                    socket.setPerformancePreferences(0, 2, 1);
                    socket.setSendBufferSize(this.socketBufferSize);
                    socket.setReceiveBufferSize(this.socketBufferSize);
                    this.protocol = this.protocolType.newInstance();
                    this.protocol.config(this.server, socket, this.configuration);
                    if (this.commands == null) continue;
                    OServerCommand[] arr$ = this.commands;
                    int len$ = arr$.length;
                    int i$ = 0;
                    while (true) {
                        if (i$ >= len$) continue block11;
                        OServerCommand c = arr$[i$];
                        this.protocol.registerCommand(c);
                        ++i$;
                    }
                }
                catch (Throwable e) {
                    if (!this.active) continue;
                    OLogManager.instance().error((Object)this, "Error on client connection", e, new Object[0]);
                }
            }
            finally {
                try {
                    if (this.serverSocket != null && !this.serverSocket.isClosed()) {
                        this.serverSocket.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    public Class<? extends ONetworkProtocol> getProtocolType() {
        return this.protocolType;
    }

    public InetSocketAddress getInboundAddr() {
        return this.inboundAddr;
    }

    private void readParameters(OContextConfiguration iServerConfig, OServerParameterConfiguration[] iParameters) {
        this.configuration = new OContextConfiguration(iServerConfig);
        if (iParameters != null && iParameters.length > 0) {
            for (OServerParameterConfiguration param : iParameters) {
                this.configuration.setValue(param.name, (Object)param.value);
            }
        }
        this.socketBufferSize = this.configuration.getValueAsInteger(OGlobalConfiguration.NETWORK_SOCKET_BUFFER_SIZE);
    }

    public static int[] getPorts(String iHostPortRange) {
        int[] ports;
        if (OStringSerializerHelper.contains((String)iHostPortRange, (char)',')) {
            String[] portValues = iHostPortRange.split(",");
            ports = new int[portValues.length];
            for (int i = 0; i < portValues.length; ++i) {
                ports[i] = Integer.parseInt(portValues[i]);
            }
        } else if (OStringSerializerHelper.contains((String)iHostPortRange, (char)'-')) {
            String[] limits = iHostPortRange.split("-");
            int lowerLimit = Integer.parseInt(limits[0]);
            int upperLimit = Integer.parseInt(limits[1]);
            ports = new int[upperLimit - lowerLimit + 1];
            for (int i = 0; i < upperLimit - lowerLimit + 1; ++i) {
                ports[i] = lowerLimit + i;
            }
        } else {
            ports = new int[]{Integer.parseInt(iHostPortRange)};
        }
        return ports;
    }

    public String getListeningAddress() {
        String address = this.serverSocket.getInetAddress().getHostAddress().toString();
        if (address.equals("0.0.0.0")) {
            try {
                address = InetAddress.getLocalHost().getHostAddress().toString();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return address + ":" + this.serverSocket.getLocalPort();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.protocolType.getSimpleName()).append(" ").append(this.serverSocket.getLocalSocketAddress()).append(":");
        return builder.toString();
    }

    public ONetworkProtocol getProtocol() {
        return this.protocol;
    }
}

