/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.binary;

import com.orientechnologies.common.concur.lock.OLockException;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.security.OUser;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.record.OSerializationThreadLocal;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.OStorageLocal;
import com.orientechnologies.orient.enterprise.channel.OChannel;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinaryServer;
import com.orientechnologies.orient.enterprise.channel.binary.ONetworkProtocolException;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.network.protocol.ONetworkProtocol;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.util.Set;
import java.util.logging.Level;

public abstract class OBinaryNetworkProtocolAbstract
extends ONetworkProtocol {
    protected OChannelBinaryServer channel;
    protected int requestType;
    protected int clientTxId;
    private final Level logClientExceptions = Level.parse(OGlobalConfiguration.SERVER_LOG_DUMP_CLIENT_EXCEPTION_LEVEL.getValueAsString());
    private final boolean logClientFullStackTrace = OGlobalConfiguration.SERVER_LOG_DUMP_CLIENT_EXCEPTION_FULLSTACKTRACE.getValueAsBoolean();

    public OBinaryNetworkProtocolAbstract(String iThreadName) {
        super(Orient.getThreadGroup(), iThreadName);
    }

    protected abstract boolean executeRequest() throws IOException;

    protected void onBeforeRequest() throws IOException {
    }

    protected void onAfterRequest() throws IOException {
    }

    @Override
    public void config(OServer iServer, Socket iSocket, OContextConfiguration iConfig) throws IOException {
        this.server = iServer;
        this.channel = new OChannelBinaryServer(iSocket, iConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute() throws Exception {
        this.requestType = -1;
        this.clientTxId = 0;
        try {
            this.requestType = this.channel.readByte();
            this.clientTxId = this.channel.readInt();
            this.onBeforeRequest();
            if (!this.executeRequest()) {
                OLogManager.instance().error((Object)this, "Request not supported. Code: " + this.requestType, new Object[0]);
                this.channel.clearInput();
                this.sendError(this.clientTxId, (Throwable)new ONetworkProtocolException("Request not supported. Code: " + this.requestType));
            }
            this.onAfterRequest();
        }
        catch (IOException e) {
            this.handleConnectionError(this.channel, e);
            this.sendShutdown();
        }
        catch (OException e) {
            this.sendError(this.clientTxId, e);
        }
        catch (RuntimeException e) {
            this.sendError(this.clientTxId, e);
        }
        catch (Throwable t) {
            this.sendError(this.clientTxId, t);
        }
        finally {
            ((Set)OSerializationThreadLocal.INSTANCE.get()).clear();
        }
    }

    public void shutdown() {
        this.channel.close();
    }

    @Override
    public OChannel getChannel() {
        return this.channel;
    }

    protected void sendOk(int iClientTxId) throws IOException {
        this.channel.writeByte((byte)0);
        this.channel.writeInt(iClientTxId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendError(int iClientTxId, Throwable t) throws IOException {
        this.channel.acquireExclusiveLock();
        try {
            this.channel.writeByte((byte)1);
            this.channel.writeInt(iClientTxId);
            for (Throwable current = t instanceof OLockException && t.getCause() instanceof ODatabaseException ? t.getCause() : t; current != null; current = current.getCause()) {
                this.channel.writeByte((byte)1);
                this.channel.writeString(current.getClass().getName());
                this.channel.writeString(current != null ? current.getMessage() : null);
            }
            this.channel.writeByte((byte)0);
            this.channel.flush();
            if (OLogManager.instance().isLevelEnabled(this.logClientExceptions)) {
                if (this.logClientFullStackTrace) {
                    OLogManager.instance().log((Object)this, this.logClientExceptions, "Sent run-time exception to the client %s: %s", t, new Object[]{this.channel.socket.getRemoteSocketAddress(), t.toString()});
                } else {
                    OLogManager.instance().log((Object)this, this.logClientExceptions, "Sent run-time exception to the client %s: %s", null, new Object[]{this.channel.socket.getRemoteSocketAddress(), t.toString()});
                }
            }
        }
        catch (Exception e) {
            if (e instanceof SocketException) {
                this.shutdown();
            }
        }
        finally {
            this.channel.releaseExclusiveLock();
        }
    }

    public void writeIdentifiable(OIdentifiable o) throws IOException {
        if (o == null) {
            this.channel.writeShort((short)-2);
        } else if (o instanceof ORecordId) {
            this.channel.writeShort((short)-3);
            this.channel.writeRID((ORID)o);
        } else {
            this.writeRecord((ORecordInternal)o.getRecord());
        }
    }

    private void writeRecord(ORecordInternal<?> iRecord) throws IOException {
        this.channel.writeShort((short)0);
        this.channel.writeByte(iRecord.getRecordType());
        this.channel.writeRID(iRecord.getIdentity());
        this.channel.writeInt(iRecord.getVersion());
        try {
            byte[] stream = iRecord.toStream();
            int realLength = stream.length;
            for (int i = stream.length - 1; i > -1 && stream[i] == 32; --i) {
                --realLength;
            }
            this.channel.writeBytes(stream, realLength);
        }
        catch (Exception e) {
            this.channel.writeBytes(null);
            OLogManager.instance().error((Object)this, "Error on unmarshalling record " + iRecord.getIdentity().toString(), OSerializationException.class);
        }
    }

    protected void checkStorageExistence(String iDatabaseName) {
        for (OStorage stg : Orient.instance().getStorages()) {
            if (!stg.getName().equalsIgnoreCase(iDatabaseName) || !stg.exists()) continue;
            throw new ODatabaseException("Database named '" + iDatabaseName + "' already exists: " + stg);
        }
    }

    protected ODatabaseDocumentTx createDatabase(ODatabaseDocumentTx iDatabase, String dbUser, String dbPasswd) {
        if (iDatabase.exists()) {
            throw new ODatabaseException("Database '" + iDatabase.getURL() + "' already exists");
        }
        iDatabase.create();
        if (dbUser != null) {
            OUser oUser = iDatabase.getMetadata().getSecurity().getUser(dbUser);
            if (oUser == null) {
                iDatabase.getMetadata().getSecurity().createUser(dbUser, dbPasswd, new String[]{"admin"});
            } else {
                oUser.setPassword(dbPasswd);
                oUser.save();
            }
        }
        OLogManager.instance().info((Object)this, "Created database '%s' of type '%s'", new Object[]{iDatabase.getName(), iDatabase.getStorage() instanceof OStorageLocal ? "local" : "memory"});
        return iDatabase;
    }

    protected ODatabaseDocumentTx getDatabaseInstance(String iDbName, String iDbType, String iStorageType) {
        String path;
        OStorage stg = Orient.instance().getStorage(iDbName);
        if (stg != null) {
            path = stg.getURL();
        } else if (iStorageType.equals("local")) {
            path = iStorageType + ":${" + "ORIENTDB_HOME" + "}/databases/" + iDbName;
        } else if (iStorageType.equals("memory")) {
            path = iStorageType + ":" + iDbName;
        } else {
            throw new IllegalArgumentException("Cannot create database: storage mode '" + iStorageType + "' is not supported.");
        }
        return Orient.instance().getDatabaseFactory().createDatabase(iDbType, path);
    }

    protected int deleteRecord(ODatabaseRecord iDatabase, ORID rid, int version) {
        ORecordInternal record = (ORecordInternal)iDatabase.load(rid);
        if (record != null) {
            record.setVersion(version);
            record.delete();
            return 1;
        }
        return 0;
    }

    protected ORecordInternal<?> createRecord(ODatabaseRecord iDatabase, ORecordId rid, byte[] buffer, byte recordType, int dataSegmentId) {
        ORecordInternal record = Orient.instance().getRecordFactoryManager().newInstance(recordType);
        record.fill(rid, 0, buffer, true);
        if (dataSegmentId > 0) {
            record.setDataSegmentName(iDatabase.getDataSegmentNameById(dataSegmentId));
        }
        iDatabase.save((Object)record);
        return record;
    }

    protected int updateRecord(ODatabaseRecord iDatabase, ORecordId rid, byte[] buffer, int version, byte recordType) {
        ORecordInternal currentRecord;
        ORecordInternal newRecord = Orient.instance().getRecordFactoryManager().newInstance(recordType);
        newRecord.fill(rid, version, buffer, true);
        if (newRecord instanceof ODocument) {
            currentRecord = (ORecordInternal)iDatabase.load((ORID)rid);
            if (currentRecord == null) {
                throw new ORecordNotFoundException(rid.toString());
            }
            ((ODocument)currentRecord).merge((ODocument)newRecord, false, false);
        } else {
            currentRecord = newRecord;
        }
        currentRecord.setVersion(version);
        iDatabase.save((Object)currentRecord);
        if (currentRecord.getIdentity().toString().equals(iDatabase.getStorage().getConfiguration().indexMgrRecordId) && !iDatabase.getStatus().equals((Object)ODatabase.STATUS.IMPORTING)) {
            iDatabase.getMetadata().getIndexManager().reload();
        }
        return currentRecord.getVersion();
    }

    protected void handleConnectionError(OChannelBinaryServer channel, Throwable e) {
        try {
            channel.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

