/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.get;

import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.server.db.OSharedDocumentDatabase;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandAuthenticatedDbAbstract;

public class OServerCommandGetDocumentByClass
extends OServerCommandAuthenticatedDbAbstract {
    private static final String[] NAMES = new String[]{"GET|documentbyclass/*"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(OHttpRequest iRequest) throws Exception {
        ORecordInternal rec;
        ODatabaseDocumentTx db = null;
        String[] urlParts = this.checkSyntax(iRequest.url, 4, "Syntax error: documentbyclass/<database>/<class-name>/<record-position>[/fetchPlan]");
        String fetchPlan = urlParts.length > 4 ? urlParts[4] : null;
        iRequest.data.commandInfo = "Load document";
        try {
            db = this.getProfiledDatabaseInstance(iRequest);
            if (db.getMetadata().getSchema().getClass(urlParts[2]) == null) {
                throw new IllegalArgumentException("Invalid class '" + urlParts[2] + "'");
            }
            String rid = db.getClusterIdByName(urlParts[2]) + ":" + urlParts[3];
            rec = db.load((ORID)new ORecordId(rid), fetchPlan);
        }
        finally {
            if (db != null) {
                OSharedDocumentDatabase.release(db);
            }
        }
        if (rec == null) {
            this.sendTextContent(iRequest, 404, "Not Found", null, "application/json", "Record with id '" + urlParts[2] + "' was not found.");
        } else {
            this.sendRecordContent(iRequest, (ORecord<?>)rec, fetchPlan);
        }
        return false;
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }
}

