/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.put;

import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.server.db.OSharedDocumentDatabase;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandDocumentAbstract;

public class OServerCommandPutDocument
extends OServerCommandDocumentAbstract {
    private static final String[] NAMES = new String[]{"PUT|document/*"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(OHttpRequest iRequest) throws Exception {
        String[] urlParts = this.checkSyntax(iRequest.url, 2, "Syntax error: document/<database>[/<record-id>]");
        iRequest.data.commandInfo = "Edit Document";
        ODatabaseDocumentTx db = null;
        ORecordId recordId = null;
        try {
            db = this.getProfiledDatabaseInstance(iRequest);
            if (urlParts.length > 2) {
                int parametersPos = urlParts[2].indexOf(63);
                String rid = parametersPos > -1 ? urlParts[2].substring(0, parametersPos) : urlParts[2];
                recordId = new ORecordId(rid);
                if (!recordId.isValid()) {
                    throw new IllegalArgumentException("Invalid Record ID in request: " + recordId);
                }
            } else {
                recordId = new ORecordId();
            }
            ODocument doc = new ODocument();
            doc.fromJSON(iRequest.content);
            if (!recordId.isValid()) {
                recordId = (ORecordId)doc.getIdentity();
            } else {
                doc.setIdentity(recordId);
            }
            if (!recordId.isValid()) {
                throw new IllegalArgumentException("Invalid Record ID in request: " + recordId);
            }
            ODocument currentDocument = (ODocument)db.load((ORID)recordId);
            if (currentDocument == null) {
                this.sendTextContent(iRequest, 404, "Not Found", null, "text/plain", "Record " + recordId + " was not found.");
                boolean bl = false;
                return bl;
            }
            currentDocument.merge(doc, false, false);
            currentDocument.setVersion(doc.getVersion());
            currentDocument.save();
        }
        finally {
            if (db != null) {
                OSharedDocumentDatabase.release(db);
            }
        }
        this.sendTextContent(iRequest, 200, "OK", null, "text/plain", "Record " + recordId + " updated successfully.");
        return false;
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }
}

