/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.task;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.OStorageSynchronizer;
import com.orientechnologies.orient.server.journal.ODatabaseJournal;
import com.orientechnologies.orient.server.task.OAbstractDistributedTask;
import com.orientechnologies.orient.server.task.OAlignResponseDistributedTask;
import com.orientechnologies.orient.server.task.OMultipleDistributedTasks;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;

public class OAlignRequestDistributedTask
extends OAbstractDistributedTask<Integer> {
    private static final long serialVersionUID = 1L;
    protected long lastRunId;
    protected long lastOperationId;
    protected static final int OP_BUFFER = 150;

    public OAlignRequestDistributedTask() {
    }

    public OAlignRequestDistributedTask(String nodeSource, String iDbName, ODistributedServerManager.EXECUTION_MODE iMode, long iLastRunId, long iLastOperationId) {
        super(nodeSource, iDbName, iMode);
        this.lastRunId = iLastRunId;
        this.lastOperationId = iLastOperationId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer call() throws Exception {
        int aligned;
        OLogManager.instance().warn((Object)this, "DISTRIBUTED <-[%s/%s] align request starting from %d.%d", new Object[]{this.nodeSource, this.databaseName, this.lastRunId, this.lastOperationId});
        ODistributedServerManager dManager = this.getDistributedServerManager();
        String localNode = dManager.getLocalNodeId();
        OStorageSynchronizer synchronizer = this.getDatabaseSynchronizer();
        if (synchronizer == null) {
            return 0;
        }
        ODatabaseJournal log = synchronizer.getLog();
        Lock alignmentLock = dManager.getLock("align." + this.databaseName);
        if (alignmentLock.tryLock()) {
            try {
                aligned = 0;
                OMultipleDistributedTasks tasks = new OMultipleDistributedTasks(localNode, this.databaseName, ODistributedServerManager.EXECUTION_MODE.SYNCHRONOUS);
                ArrayList<Long> positions = new ArrayList<Long>();
                Iterator<Long> it = log.browse(new long[]{this.lastRunId, this.lastOperationId});
                while (it.hasNext()) {
                    long pos = it.next();
                    OAbstractDistributedTask<?> operation = log.getOperation(pos);
                    if (operation == null) {
                        OLogManager.instance().warn((Object)this, "DISTRIBUTED ->[%s/%s] skipped operation #%d.%d", new Object[]{this.nodeSource, this.databaseName, this.lastRunId, this.lastOperationId});
                        continue;
                    }
                    OLogManager.instance().warn((Object)this, "DISTRIBUTED ->[%s/%s] operation %s", new Object[]{this.nodeSource, this.databaseName, operation});
                    operation.setNodeSource(localNode);
                    operation.setDatabaseName(this.databaseName);
                    operation.setMode(ODistributedServerManager.EXECUTION_MODE.SYNCHRONOUS);
                    tasks.addTask(operation);
                    positions.add(pos);
                    if (tasks.getTasks() < 150) continue;
                    aligned += this.flushBufferedTasks(dManager, synchronizer, tasks, positions);
                }
                if (tasks.getTasks() > 0) {
                    aligned += this.flushBufferedTasks(dManager, synchronizer, tasks, positions);
                }
                OLogManager.instance().warn((Object)this, "DISTRIBUTED ->[%s/%s] aligned %d operations", new Object[]{this.nodeSource, this.databaseName, aligned});
            }
            finally {
                alignmentLock.unlock();
            }
        } else {
            aligned = -1;
        }
        dManager.sendOperation2Node(this.nodeSource, new OAlignResponseDistributedTask(localNode, this.databaseName, ODistributedServerManager.EXECUTION_MODE.FIRE_AND_FORGET, aligned));
        return aligned;
    }

    protected int flushBufferedTasks(ODistributedServerManager dManager, OStorageSynchronizer synchronizer, OMultipleDistributedTasks tasks, List<Long> positions) throws IOException {
        Object[] result = (Object[])dManager.sendOperation2Node(this.nodeSource, tasks);
        for (int i = 0; i < positions.size(); ++i) {
            tasks.getTask(i).setAsCompleted(synchronizer, positions.get(i));
        }
        int aligned = tasks.getTasks();
        tasks.clearTasks();
        positions.clear();
        return aligned;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeLong(this.lastRunId);
        out.writeLong(this.lastOperationId);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.lastRunId = in.readLong();
        this.lastOperationId = in.readLong();
    }

    @Override
    public String getName() {
        return "align_request";
    }
}

