/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.task;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.OStorageSynchronizer;
import com.orientechnologies.orient.server.distributed.conflict.OReplicationConflictResolver;
import com.orientechnologies.orient.server.journal.ODatabaseJournal;
import com.orientechnologies.orient.server.task.OAbstractRecordDistributedTask;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class OCreateRecordDistributedTask
extends OAbstractRecordDistributedTask<OPhysicalPosition> {
    private static final long serialVersionUID = 1L;
    protected byte[] content;
    protected byte recordType;

    public OCreateRecordDistributedTask() {
    }

    public OCreateRecordDistributedTask(long iRunId, long iOperationId, ORecordId iRid, byte[] iContent, int iVersion, byte iRecordType) {
        super(iRunId, iOperationId, iRid, iVersion);
        this.content = iContent;
        this.recordType = iRecordType;
    }

    public OCreateRecordDistributedTask(String nodeSource, String iDbName, ODistributedServerManager.EXECUTION_MODE iMode, ORecordId iRid, byte[] iContent, int iVersion, byte iRecordType) {
        super(nodeSource, iDbName, iMode, iRid, iVersion);
        this.content = iContent;
        this.recordType = iRecordType;
    }

    public Object getDistributedKey() {
        return this.rid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected OPhysicalPosition executeOnLocalNode(OStorageSynchronizer dbSynchronizer) {
        OLogManager.instance().warn((Object)this, "DISTRIBUTED <-[%s/%s] CREATE RECORD %s v.%d", new Object[]{this.nodeSource, this.databaseName, this.rid, this.version});
        ORecordInternal record = Orient.instance().getRecordFactoryManager().newInstance(this.recordType);
        ODatabaseDocumentTx database = this.openDatabase();
        this.rid.clusterPosition = -1L;
        try {
            record.fill(this.rid, this.version, this.content, true);
            if (this.rid.getClusterId() != -1) {
                record.save(database.getClusterNameById(this.rid.getClusterId()));
            } else {
                record.save();
            }
            this.rid = (ORecordId)record.getIdentity();
            OPhysicalPosition oPhysicalPosition = new OPhysicalPosition(this.rid.getClusterPosition(), record.getVersion());
            return oPhysicalPosition;
        }
        finally {
            this.closeDatabase(database);
        }
    }

    @Override
    public void handleConflict(String iRemoteNodeId, Object localResult, Object remoteResult) {
        OReplicationConflictResolver resolver = this.getDatabaseSynchronizer().getConflictResolver();
        resolver.handleCreateConflict(iRemoteNodeId, this.rid, new ORecordId(this.rid.getClusterId(), ((OPhysicalPosition)remoteResult).clusterPosition));
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeUTF(this.rid.toString());
        out.writeInt(this.content.length);
        out.write(this.content);
        out.writeInt(this.version);
        out.write(this.recordType);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.rid = new ORecordId(in.readUTF());
        int contentSize = in.readInt();
        this.content = new byte[contentSize];
        in.readFully(this.content);
        this.version = in.readInt();
        this.recordType = in.readByte();
    }

    @Override
    public String getName() {
        return "record_create";
    }

    @Override
    protected void setAsCompleted(OStorageSynchronizer dbSynchronizer, long operationLogOffset) throws IOException {
        dbSynchronizer.getLog().changeOperationStatus(operationLogOffset, this.rid);
    }

    @Override
    protected ODatabaseJournal.OPERATION_TYPES getOperationType() {
        return ODatabaseJournal.OPERATION_TYPES.RECORD_CREATE;
    }
}

