/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.task;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.OStorageSynchronizer;
import com.orientechnologies.orient.server.distributed.conflict.OReplicationConflictResolver;
import com.orientechnologies.orient.server.journal.ODatabaseJournal;
import com.orientechnologies.orient.server.task.OAbstractRecordDistributedTask;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class OUpdateRecordDistributedTask
extends OAbstractRecordDistributedTask<Integer> {
    private static final long serialVersionUID = 1L;
    protected byte[] content;
    protected byte recordType;

    public OUpdateRecordDistributedTask() {
    }

    public OUpdateRecordDistributedTask(String iNodeSource, String iDbName, ODistributedServerManager.EXECUTION_MODE iMode, ORecordId iRid, byte[] iContent, int iVersion, byte iRecordType) {
        super(iNodeSource, iDbName, iMode, iRid, iVersion);
        this.content = iContent;
        this.recordType = iRecordType;
    }

    public OUpdateRecordDistributedTask(long iRunId, long iOperationId, ORecordId iRid, byte[] iContent, int iVersion, byte iRecordType) {
        super(iRunId, iOperationId, iRid, iVersion);
        this.content = iContent;
        this.recordType = iRecordType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer executeOnLocalNode(OStorageSynchronizer dbSynchronizer) {
        OLogManager.instance().warn((Object)this, "DISTRIBUTED <-[%s/%s] UPDATE RECORD %s v.%d", new Object[]{this.nodeSource, this.databaseName, this.rid, this.version});
        ORecordInternal record = Orient.instance().getRecordFactoryManager().newInstance(this.recordType);
        ODatabaseDocumentTx database = this.openDatabase();
        try {
            record.fill(this.rid, this.version, this.content, true);
            record.save();
            Integer n = record.getVersion();
            return n;
        }
        finally {
            this.closeDatabase(database);
        }
    }

    @Override
    public void handleConflict(String iRemoteNodeId, Object localResult, Object remoteResult) {
        OReplicationConflictResolver resolver = this.getDatabaseSynchronizer().getConflictResolver();
        resolver.handleUpdateConflict(iRemoteNodeId, this.rid, this.version, (Integer)remoteResult);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeUTF(this.rid.toString());
        out.writeInt(this.content.length);
        out.write(this.content);
        out.writeInt(this.version);
        out.write(this.recordType);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.rid = new ORecordId(in.readUTF());
        int contentSize = in.readInt();
        this.content = new byte[contentSize];
        in.readFully(this.content);
        this.version = in.readInt();
        this.recordType = in.readByte();
    }

    @Override
    public String getName() {
        return "record_update";
    }

    @Override
    protected ODatabaseJournal.OPERATION_TYPES getOperationType() {
        return ODatabaseJournal.OPERATION_TYPES.RECORD_UPDATE;
    }
}

