/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.parser.OSystemVariableResolver;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.server.OServerMain;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.conflict.OReplicationConflictResolver;
import com.orientechnologies.orient.server.journal.ODatabaseJournal;
import com.orientechnologies.orient.server.task.OAbstractDistributedTask;
import com.orientechnologies.orient.server.task.OReadRecordDistributedTask;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;

public class OStorageSynchronizer {
    private ODistributedServerManager cluster;
    private String storageName;
    private ODatabaseJournal log;
    private OReplicationConflictResolver resolver;

    public OStorageSynchronizer(ODistributedServerManager iCluster, String storageName) throws IOException {
        this.cluster = iCluster;
        OStorage storage = this.openStorage(storageName);
        try {
            this.resolver = iCluster.getConfictResolverClass().newInstance();
            this.resolver.startup(iCluster, storageName);
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "Cannot create the conflict resolver instance of class '%s'", new Object[]{iCluster.getConfictResolverClass(), e});
        }
        String logDirectory = OSystemVariableResolver.resolveSystemVariables((String)(OServerMain.server().getDatabaseDirectory() + "/" + storageName));
        this.log = new ODatabaseJournal(storage, logDirectory);
        for (ORecordId rid : this.log.getUncommittedOperations()) {
            try {
                if (this.getConflictResolver().existConflictsForRecord(rid)) continue;
                ORawBuffer record = (ORawBuffer)iCluster.routeOperation2Node(OStorageSynchronizer.getClusterNameByRID(storage, rid), rid, new OReadRecordDistributedTask(iCluster.getLocalNodeId(), storageName, rid));
                if (record == null) {
                    storage.deleteRecord(rid, -1, 0, null);
                    continue;
                }
                storage.updateRecord(rid, record.buffer, record.version, record.recordType, 0, null);
            }
            catch (ExecutionException e) {
                OLogManager.instance().warn((Object)this, "DISTRIBUTED Error on acquiring uncommitted record %s from other servers. The database could be unaligned with others!", (Throwable)e, new Object[]{rid});
            }
        }
    }

    public Map<String, Object> distributeOperation(byte operation, ORecordId rid, OAbstractDistributedTask<?> iTask) {
        Set<String> targetNodes = this.cluster.getRemoteNodeIdsBut(iTask.getNodeSource());
        if (!targetNodes.isEmpty()) {
            iTask.setNodeSource(this.cluster.getLocalNodeId());
            iTask.setStatus(OAbstractDistributedTask.STATUS.REMOTE_EXEC);
            return this.cluster.sendOperation2Nodes(targetNodes, iTask);
        }
        return null;
    }

    public OReplicationConflictResolver getConflictResolver() {
        return this.resolver;
    }

    public ODatabaseJournal getLog() {
        return this.log;
    }

    public String toString() {
        return this.storageName;
    }

    public static String getClusterNameByRID(OStorage iStorage, ORecordId iRid) {
        OCluster cluster = iStorage.getClusterById(iRid.clusterId);
        return cluster != null ? cluster.getName() : "*";
    }

    protected OStorage openStorage(String iName) {
        OStorage stg = Orient.instance().getStorage(iName);
        if (stg == null) {
            OLogManager.instance().warn((Object)this, "DISTRIBUTED Initializing storage '%s'", new Object[]{iName});
            String url = OServerMain.server().getStorageURL(iName);
            if (url == null) {
                throw new IllegalArgumentException("Database '" + iName + "' is not configured on local server");
            }
            stg = Orient.instance().loadStorage(url);
            stg.open(null, null, null);
        }
        return stg;
    }
}

