/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.journal;

import com.orientechnologies.common.concur.resource.OSharedResourceAdaptiveExternal;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.fs.OFile;
import com.orientechnologies.orient.core.storage.fs.OFileFactory;
import com.orientechnologies.orient.server.task.OAbstractDistributedTask;
import com.orientechnologies.orient.server.task.OAbstractRecordDistributedTask;
import com.orientechnologies.orient.server.task.OCreateRecordDistributedTask;
import com.orientechnologies.orient.server.task.ODeleteRecordDistributedTask;
import com.orientechnologies.orient.server.task.OSQLCommandDistributedTask;
import com.orientechnologies.orient.server.task.OUpdateRecordDistributedTask;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ODatabaseJournal {
    public static final String DIRECTORY = "log";
    public static final String FILENAME = "journal.olj";
    private static final int DEF_START_SIZE = 262144;
    private static final int OFFSET_STATUS = 0;
    private static final int OFFSET_OPERATION_TYPE = 1;
    private static final int OFFSET_VARDATA = 2;
    private static final int OFFSET_BACK_OPERATID = 8;
    private static final int OFFSET_BACK_RUNID = 16;
    private static final int OFFSET_BACK_SIZE = 20;
    private static final int FIXED_SIZE = 22;
    private OSharedResourceAdaptiveExternal lock = new OSharedResourceAdaptiveExternal(OGlobalConfiguration.ENVIRONMENT_CONCURRENT.getValueAsBoolean(), 0, true);
    private OStorage storage;
    private OFile file;
    private boolean synchEnabled = false;

    public ODatabaseJournal(OStorage iStorage, String iStartingDirectory) throws IOException {
        this.storage = iStorage;
        File osFile = new File(iStartingDirectory + "/" + DIRECTORY);
        if (!osFile.exists()) {
            osFile.mkdirs();
        }
        osFile = new File(iStartingDirectory + "/" + DIRECTORY + "/" + FILENAME);
        this.file = OFileFactory.instance().create("classic", osFile.getAbsolutePath(), "rw");
        if (this.file.exists()) {
            this.file.open();
        } else {
            this.file.create(262144);
        }
    }

    public long[] getLastOperationId() throws IOException {
        return this.getOperationId(this.file.getFilledUpTo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getOperationId(long iOffset) throws IOException {
        int filled = this.file.getFilledUpTo();
        if (filled == 0 || iOffset <= 0L || iOffset > (long)filled) {
            return new long[]{-1L, -1L};
        }
        this.lock.acquireExclusiveLock();
        try {
            long[] ids = new long[]{this.file.readLong(iOffset - 16L), this.file.readLong(iOffset - 8L)};
            long[] lArray = ids;
            return lArray;
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<Long> browse(long[] iRemoteLastOperationId) throws IOException {
        LinkedList<Long> result = new LinkedList<Long>();
        this.lock.acquireExclusiveLock();
        try {
            long fileOffset = this.file.getFilledUpTo();
            long[] localOperationId = this.getOperationId(fileOffset);
            while (localOperationId[0] > iRemoteLastOperationId[0] || localOperationId[0] == iRemoteLastOperationId[0] && localOperationId[1] > iRemoteLastOperationId[1]) {
                result.add(fileOffset);
                long prevOffset = this.getPreviousOperation(fileOffset);
                localOperationId = this.getOperationId(prevOffset);
                fileOffset = prevOffset;
            }
            Iterator<Long> iterator = result.descendingIterator();
            return iterator;
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    public List<ORecordId> getUncommittedOperations() throws IOException {
        ArrayList<ORecordId> uncommittedRecords = new ArrayList<ORecordId>();
        long fileOffset = this.file.getFilledUpTo();
        while (fileOffset > 0L && !this.getOperationStatus(fileOffset)) {
            OAbstractDistributedTask<?> op = this.getOperation(fileOffset);
            OLogManager.instance().warn((Object)this, "DISTRIBUTED Found uncommitted operation %s", new Object[]{op});
            if (op instanceof OAbstractRecordDistributedTask) {
                uncommittedRecords.add(((OAbstractRecordDistributedTask)op).getRid());
            }
            fileOffset = this.getPreviousOperation(fileOffset);
        }
        return uncommittedRecords;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeOperationStatus(long iOffsetEndOperation, ORecordId iRid) throws IOException {
        this.lock.acquireExclusiveLock();
        try {
            int varSize = this.file.readInt(iOffsetEndOperation - 20L);
            long offset = iOffsetEndOperation - 20L - (long)varSize - 2L;
            OLogManager.instance().warn((Object)this, "Updating status operation #%d.%d rid %s", new Object[]{this.file.readLong(iOffsetEndOperation - 16L), this.file.readLong(iOffsetEndOperation - 8L), iRid});
            this.file.write(offset + 0L, new byte[]{1});
            if (iRid != null) {
                this.file.writeLong(offset + 2L + 2L, iRid.clusterPosition);
            }
            this.file.synch();
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getOperationStatus(long iOffsetEndOperation) throws IOException {
        this.lock.acquireExclusiveLock();
        try {
            int varSize = this.file.readInt(iOffsetEndOperation - 20L);
            long offset = iOffsetEndOperation - 20L - (long)varSize - 2L;
            boolean bl = this.file.readByte(offset + 0L) == 1;
            return bl;
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long journalOperation(long iRunId, long iOperationId, OPERATION_TYPES iOperationType, Object iVarData) throws IOException {
        this.lock.acquireExclusiveLock();
        try {
            long offset = 0L;
            int varSize = 0;
            switch (iOperationType) {
                case RECORD_CREATE: 
                case RECORD_UPDATE: 
                case RECORD_DELETE: {
                    OAbstractRecordDistributedTask task = (OAbstractRecordDistributedTask)iVarData;
                    varSize = 10;
                    ORecordId rid = task.getRid();
                    if (OLogManager.instance().isDebugEnabled()) {
                        OLogManager.instance().warn((Object)this, "Journaled operation %s %s as #%d.%d", new Object[]{iOperationType.toString(), rid, iRunId, iOperationId});
                    }
                    offset = this.writeOperationLogHeader(iOperationType, varSize);
                    this.file.writeShort(offset + 2L, (short)rid.clusterId);
                    this.file.writeLong(offset + 2L + 2L, rid.clusterPosition);
                    break;
                }
                case SQL_COMMAND: {
                    OCommandSQL cmd = (OCommandSQL)iVarData;
                    String cmdText = cmd.getText();
                    byte[] cmdBinary = cmdText.getBytes();
                    varSize = cmdBinary.length;
                    if (OLogManager.instance().isDebugEnabled()) {
                        OLogManager.instance().warn((Object)this, "Journaled operation %s '%s' as #%d.%d", new Object[]{iOperationType.toString(), cmdText, iRunId, iOperationId});
                    }
                    offset = this.writeOperationLogHeader(iOperationType, varSize);
                    this.file.write(offset + 2L, cmdText.getBytes());
                    break;
                }
            }
            this.file.writeLong(offset + 2L + (long)varSize + 4L, iRunId);
            this.file.writeLong(offset + 2L + (long)varSize + 4L + 8L, iOperationId);
            if (this.synchEnabled) {
                this.file.synch();
            }
            long l = offset + 2L + (long)varSize + 4L + 8L + 8L;
            return l;
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    protected long writeOperationLogHeader(OPERATION_TYPES iOperationType, int varSize) throws IOException {
        long offset = this.file.allocateSpace(22 + varSize);
        this.file.writeByte(offset + 0L, (byte)0);
        this.file.writeByte(offset + 1L, (byte)iOperationType.ordinal());
        this.file.writeInt(offset + 2L + (long)varSize, varSize);
        return offset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OAbstractDistributedTask<?> getOperation(long iOffsetEndOperation) throws IOException {
        OAbstractDistributedTask task = null;
        this.lock.acquireExclusiveLock();
        try {
            long runId = this.file.readLong(iOffsetEndOperation - 16L);
            long operationId = this.file.readLong(iOffsetEndOperation - 8L);
            int varSize = this.file.readInt(iOffsetEndOperation - 20L);
            long offset = iOffsetEndOperation - 20L - (long)varSize - 2L;
            OPERATION_TYPES operationType = OPERATION_TYPES.values()[this.file.readByte(offset + 1L)];
            switch (operationType) {
                case RECORD_CREATE: {
                    ORawBuffer record;
                    ORecordId rid = new ORecordId((int)this.file.readShort(offset + 2L), this.file.readLong(offset + 2L + 2L));
                    if (rid.isNew()) {
                        rid.clusterPosition = this.storage.getClusterDataRange(rid.clusterId)[1];
                    }
                    if ((record = (ORawBuffer)this.storage.readRecord(rid, null, false, null).getResult()) == null) break;
                    task = new OCreateRecordDistributedTask(runId, operationId, rid, record.buffer, record.version, record.recordType);
                    break;
                }
                case RECORD_UPDATE: {
                    ORecordId rid = new ORecordId((int)this.file.readShort(offset + 2L), this.file.readLong(offset + 2L + 2L));
                    ORawBuffer record = (ORawBuffer)this.storage.readRecord(rid, null, false, null).getResult();
                    if (record == null) break;
                    task = new OUpdateRecordDistributedTask(runId, operationId, rid, record.buffer, record.version - 1, record.recordType);
                    break;
                }
                case RECORD_DELETE: {
                    ORecordId rid = new ORecordId((int)this.file.readShort(offset + 2L), this.file.readLong(offset + 2L + 2L));
                    ORawBuffer record = (ORawBuffer)this.storage.readRecord(rid, null, false, null).getResult();
                    task = new ODeleteRecordDistributedTask(runId, operationId, rid, record != null ? record.version : -1);
                    break;
                }
                case SQL_COMMAND: {
                    byte[] buffer = new byte[varSize];
                    this.file.read(offset + 2L, buffer, buffer.length);
                    task = new OSQLCommandDistributedTask(runId, operationId, new String(buffer));
                    break;
                }
            }
            if (task != null) {
                task.setStatus(OAbstractDistributedTask.STATUS.ALIGN);
            }
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getPreviousOperation(long iPosition) throws IOException {
        this.lock.acquireExclusiveLock();
        try {
            int size = this.file.readInt(iPosition - 20L);
            long l = iPosition - 20L - (long)size - 2L;
            return l;
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    public static enum OPERATION_TYPES {
        RECORD_CREATE,
        RECORD_UPDATE,
        RECORD_DELETE,
        SQL_COMMAND;

    }
}

