/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.binary;

import com.orientechnologies.common.io.OIOException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestInternal;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.command.OCommandResultListener;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseComplex;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.raw.ODatabaseRaw;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.ODatabaseRecordTx;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.OSecurityAccessException;
import com.orientechnologies.orient.core.exception.OSecurityException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.exception.OTransactionAbortedException;
import com.orientechnologies.orient.core.fetch.OFetchContext;
import com.orientechnologies.orient.core.fetch.OFetchHelper;
import com.orientechnologies.orient.core.fetch.OFetchListener;
import com.orientechnologies.orient.core.fetch.remote.ORemoteFetchContext;
import com.orientechnologies.orient.core.fetch.remote.ORemoteFetchListener;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.security.OUser;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerStringAbstract;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializerAnyStreamable;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OStorageProxy;
import com.orientechnologies.orient.core.storage.impl.memory.OStorageMemory;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinary;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinaryServer;
import com.orientechnologies.orient.server.OClientConnection;
import com.orientechnologies.orient.server.OClientConnectionManager;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.OServerMain;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.OStorageSynchronizer;
import com.orientechnologies.orient.server.handler.OServerHandlerHelper;
import com.orientechnologies.orient.server.network.protocol.binary.OBinaryNetworkProtocolAbstract;
import com.orientechnologies.orient.server.tx.OTransactionOptimisticProxy;
import java.io.IOException;
import java.net.Socket;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;

public class ONetworkProtocolBinary
extends OBinaryNetworkProtocolAbstract {
    protected OClientConnection connection;
    protected OUser account;
    private String dbType;

    public ONetworkProtocolBinary() {
        super("OrientDB <- BinaryClient/?");
    }

    public ONetworkProtocolBinary(String iThreadName) {
        super(iThreadName);
    }

    @Override
    public void config(OServer iServer, Socket iSocket, OContextConfiguration iConfig) throws IOException {
        this.connection = OClientConnectionManager.instance().connect(iSocket, this);
        super.config(iServer, iSocket, iConfig);
        this.channel.writeShort((short)12);
        this.channel.flush();
        this.start();
        this.setName("OrientDB <- BinaryClient (" + iSocket.getRemoteSocketAddress() + ")");
    }

    @Override
    protected void onBeforeRequest() throws IOException {
        this.connection = OClientConnectionManager.instance().getConnection(this.channel.socket, this.clientTxId);
        if (this.clientTxId < 0) {
            short protocolId = 0;
            if (this.connection != null) {
                protocolId = this.connection.data.protocolVersion;
            }
            this.connection = OClientConnectionManager.instance().connect(this.channel.socket, this);
            if (this.connection != null) {
                this.connection.data.protocolVersion = protocolId;
            }
        }
        if (this.connection != null) {
            ODatabaseRecordThreadLocal.INSTANCE.set((Object)this.connection.database);
            if (this.connection.database != null) {
                this.connection.data.lastDatabase = this.connection.database.getName();
                this.connection.data.lastUser = this.connection.database.getUser() != null ? this.connection.database.getUser().getName() : null;
            } else {
                this.connection.data.lastDatabase = null;
                this.connection.data.lastUser = null;
            }
            ++this.connection.data.totalRequests;
            this.setDataCommandInfo("Listening");
            this.connection.data.commandDetail = "-";
            this.connection.data.lastCommandReceived = System.currentTimeMillis();
        } else if (this.requestType != 5 && this.requestType != 1) {
            this.shutdown();
            throw new OIOException("Found unknown session " + this.clientTxId);
        }
        OServerHandlerHelper.invokeHandlerCallbackOnBeforeClientRequest(this.connection, (byte)this.requestType);
    }

    @Override
    protected void onAfterRequest() throws IOException {
        OServerHandlerHelper.invokeHandlerCallbackOnAfterClientRequest(this.connection, (byte)this.requestType);
        if (this.connection != null) {
            this.connection.data.lastCommandExecutionTime = System.currentTimeMillis() - this.connection.data.lastCommandReceived;
            this.connection.data.totalCommandExecutionTime += this.connection.data.lastCommandExecutionTime;
            this.connection.data.lastCommandInfo = this.connection.data.commandInfo;
            this.connection.data.lastCommandDetail = this.connection.data.commandDetail;
            this.setDataCommandInfo("Listening");
            this.connection.data.commandDetail = "-";
        }
    }

    @Override
    protected boolean executeRequest() throws IOException {
        switch (this.requestType) {
            case 1: {
                this.shutdownConnection();
                break;
            }
            case 2: {
                this.connect();
                break;
            }
            case 74: {
                this.listDatabases();
                break;
            }
            case 3: {
                this.openDatabase();
                break;
            }
            case 73: {
                this.reloadDatabase();
                break;
            }
            case 4: {
                this.createDatabase();
                break;
            }
            case 5: {
                this.closeDatabase();
                break;
            }
            case 6: {
                this.existsDatabase();
                break;
            }
            case 7: {
                this.dropDatabase();
                break;
            }
            case 8: {
                this.sizeDatabase();
                break;
            }
            case 9: {
                this.countDatabaseRecords();
                break;
            }
            case 90: {
                this.copyDatabase();
                break;
            }
            case 91: {
                this.replicationDatabase();
                break;
            }
            case 92: {
                this.distributedCluster();
                break;
            }
            case 20: {
                this.addDataSegment();
                break;
            }
            case 21: {
                this.dropDataSegment();
                break;
            }
            case 12: {
                this.countClusters();
                break;
            }
            case 13: {
                this.rangeCluster();
                break;
            }
            case 15: {
                this.clusterPositionsByEntry();
                break;
            }
            case 16: {
                this.isLHClustersAreUsed();
                break;
            }
            case 35: {
                this.changeRecordIdentity();
                break;
            }
            case 10: {
                this.addCluster();
                break;
            }
            case 11: {
                this.removeCluster();
                break;
            }
            case 30: {
                this.readRecord();
                break;
            }
            case 31: {
                this.createRecord();
                break;
            }
            case 32: {
                this.updateRecord();
                break;
            }
            case 33: {
                this.deleteRecord();
                break;
            }
            case 40: {
                this.countCluster();
                break;
            }
            case 41: {
                this.command();
                break;
            }
            case 60: {
                this.commit();
                break;
            }
            case 70: {
                this.configGet();
                break;
            }
            case 71: {
                this.configSet();
                break;
            }
            case 72: {
                this.configList();
                break;
            }
            case 94: {
                this.freezeDatabase();
                break;
            }
            case 95: {
                this.releaseDatabase();
                break;
            }
            default: {
                this.setDataCommandInfo("Command not supported");
                return false;
            }
        }
        return true;
    }

    protected void checkServerAccess(String iResource) {
        if (this.connection.serverUser == null) {
            throw new OSecurityAccessException("Server user not authenticated.");
        }
        if (!OServerMain.server().authenticate(this.connection.serverUser.name, null, iResource)) {
            throw new OSecurityAccessException("User '" + this.connection.serverUser.name + "' cannot access to the resource [" + iResource + "]. Use another server user or change permission in the file config/orientdb-server-config.xml");
        }
    }

    protected ODatabaseComplex<?> openDatabase(ODatabaseComplex<?> database, String iUser, String iPassword) {
        if (database.isClosed()) {
            if (database.getStorage() instanceof OStorageMemory && !database.exists()) {
                database.create();
            } else {
                try {
                    database.open(iUser, iPassword);
                }
                catch (OSecurityException e) {
                    try {
                        this.connection.serverUser = OServerMain.server().serverLogin(iUser, iPassword, "database.passthrough");
                    }
                    catch (OSecurityException ex) {
                        throw e;
                    }
                    database.setProperty(ODatabase.OPTIONS.SECURITY.toString(), (Object)Boolean.FALSE);
                    database.open(iUser, iPassword);
                }
            }
        }
        return database;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addDataSegment() throws IOException {
        this.setDataCommandInfo("Add data segment");
        this.checkDatabase();
        String name = this.channel.readString();
        String location = this.channel.readString();
        int num = this.connection.database.addDataSegment(name, location);
        this.beginResponse();
        try {
            this.sendOk(this.clientTxId);
            this.channel.writeInt(num);
        }
        finally {
            this.endResponse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dropDataSegment() throws IOException {
        this.setDataCommandInfo("Drop data segment");
        this.checkDatabase();
        String name = this.channel.readString();
        boolean result = this.connection.database.dropDataSegment(name);
        this.beginResponse();
        try {
            this.sendOk(this.clientTxId);
            this.channel.writeByte((byte)(result ? 1 : 0));
        }
        finally {
            this.endResponse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeCluster() throws IOException {
        this.setDataCommandInfo("Remove cluster");
        this.checkDatabase();
        short id = this.channel.readShort();
        String clusterName = this.connection.database.getClusterNameById((int)id);
        if (clusterName == null) {
            throw new IllegalArgumentException("Cluster " + id + " doesn't exist anymore. Refresh the db structure or just reconnect to the database");
        }
        boolean result = this.connection.database.dropCluster(clusterName);
        this.beginResponse();
        try {
            this.sendOk(this.clientTxId);
            this.channel.writeByte((byte)(result ? 1 : 0));
        }
        finally {
            this.endResponse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addCluster() throws IOException {
        String dataSegmentName;
        this.setDataCommandInfo("Add cluster");
        this.checkDatabase();
        String type = this.channel.readString();
        String name = this.channel.readString();
        String location = this.connection.data.protocolVersion >= 10 || type.equalsIgnoreCase("PHYSICAL") ? this.channel.readString() : null;
        if (this.connection.data.protocolVersion >= 10) {
            dataSegmentName = this.channel.readString();
        } else {
            this.channel.readInt();
            dataSegmentName = null;
        }
        Object[] params = null;
        int num = this.connection.database.addCluster(type, name, location, dataSegmentName, params);
        this.beginResponse();
        try {
            this.sendOk(this.clientTxId);
            this.channel.writeShort((short)num);
        }
        finally {
            this.endResponse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rangeCluster() throws IOException {
        this.setDataCommandInfo("Get the begin/end range of data in cluster");
        this.checkDatabase();
        long[] pos = this.connection.database.getStorage().getClusterDataRange((int)this.channel.readShort());
        this.beginResponse();
        try {
            this.sendOk(this.clientTxId);
            this.channel.writeLong(pos[0]);
            this.channel.writeLong(pos[1]);
        }
        finally {
            this.endResponse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clusterPositionsByEntry() throws IOException {
        this.setDataCommandInfo("Get list of cluster positions which are contained in given cluster entry");
        this.checkDatabase();
        short clusterId = this.channel.readShort();
        long entry = this.channel.readLong();
        long[] pos = this.connection.database.getStorage().getClusterPositionsForEntry((int)clusterId, entry);
        this.beginResponse();
        try {
            this.sendOk(this.clientTxId);
            this.channel.writeInt(pos.length);
            for (long position : pos) {
                this.channel.writeLong(position);
            }
        }
        finally {
            this.endResponse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void changeRecordIdentity() throws IOException {
        this.setDataCommandInfo("Move record from one cluster and cluster position to other");
        this.checkDatabase();
        short originalClusterId = this.channel.readShort();
        long originalClusterPosition = this.channel.readLong();
        short destinationClusterId = this.channel.readShort();
        long destinationClusterPosition = this.channel.readLong();
        this.connection.database.getStorage().changeRecordIdentity((ORID)new ORecordId((int)originalClusterId, originalClusterPosition), (ORID)new ORecordId((int)destinationClusterId, destinationClusterPosition));
        this.beginResponse();
        try {
            this.sendOk(this.clientTxId);
        }
        finally {
            this.endResponse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void isLHClustersAreUsed() throws IOException {
        this.setDataCommandInfo("Determinate whether clusters are presented as persistent list or hash map ");
        this.checkDatabase();
        boolean isLHClustersAreUsed = this.connection.database.getStorage().isLHClustersAreUsed();
        this.beginResponse();
        try {
            this.sendOk(this.clientTxId);
            this.channel.writeByte(isLHClustersAreUsed ? (byte)1 : 0);
        }
        finally {
            this.endResponse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void countClusters() throws IOException {
        this.setDataCommandInfo("Count cluster elements");
        this.checkDatabase();
        int[] clusterIds = new int[this.channel.readShort()];
        for (int i = 0; i < clusterIds.length; ++i) {
            clusterIds[i] = this.channel.readShort();
        }
        long count = this.connection.database.countClusterElements(clusterIds);
        this.beginResponse();
        try {
            this.sendOk(this.clientTxId);
            this.channel.writeLong(count);
        }
        finally {
            this.endResponse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reloadDatabase() throws IOException {
        this.setDataCommandInfo("Reload database information");
        this.checkDatabase();
        this.beginResponse();
        try {
            this.sendOk(this.clientTxId);
            this.sendDatabaseInformation();
        }
        finally {
            this.endResponse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openDatabase() throws IOException {
        this.setDataCommandInfo("Open database");
        this.readConnectionData();
        String dbURL = this.channel.readString();
        this.dbType = "document";
        if (this.connection.data.protocolVersion >= 8) {
            this.dbType = this.channel.readString();
        }
        String user = this.channel.readString();
        String passwd = this.channel.readString();
        this.connection.database = (ODatabaseDocumentTx)OServerMain.server().openDatabase(this.dbType, dbURL, user, passwd);
        this.connection.rawDatabase = (ODatabaseRaw)((ODatabaseComplex)this.connection.database.getUnderlying()).getUnderlying();
        if (this.connection.database.getStorage() instanceof OStorageProxy && !this.loadUserFromSchema(user, passwd)) {
            this.sendError(this.clientTxId, (Throwable)new OSecurityAccessException(this.connection.database.getName(), "User or password not valid for database: '" + this.connection.database.getName() + "'"));
        } else {
            this.beginResponse();
            try {
                this.sendOk(this.clientTxId);
                this.channel.writeInt(this.connection.id);
                this.sendDatabaseInformation();
                Object plugin = OServerMain.server().getPlugin("cluster");
                ODocument distributedCfg = null;
                if (plugin != null && plugin instanceof ODistributedServerManager) {
                    distributedCfg = ((ODistributedServerManager)plugin).getClusterConfiguration();
                }
                this.channel.writeBytes(distributedCfg != null ? distributedCfg.toStream() : null);
            }
            finally {
                this.endResponse();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connect() throws IOException {
        this.setDataCommandInfo("Connect");
        this.readConnectionData();
        this.connection.serverUser = OServerMain.server().serverLogin(this.channel.readString(), this.channel.readString(), "connect");
        this.beginResponse();
        try {
            this.sendOk(this.clientTxId);
            this.channel.writeInt(this.connection.id);
        }
        finally {
            this.endResponse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdownConnection() throws IOException {
        this.setDataCommandInfo("Shutdowning");
        OLogManager.instance().info((Object)this, "Received shutdown command from the remote client %s:%d", new Object[]{this.channel.socket.getInetAddress(), this.channel.socket.getPort()});
        String user = this.channel.readString();
        String passwd = this.channel.readString();
        if (OServerMain.server().authenticate(user, passwd, "shutdown")) {
            OLogManager.instance().info((Object)this, "Remote client %s:%d authenticated. Starting shutdown of server...", new Object[]{this.channel.socket.getInetAddress(), this.channel.socket.getPort()});
            this.beginResponse();
            try {
                this.sendOk(this.clientTxId);
            }
            finally {
                this.endResponse();
            }
            this.channel.close();
            OServerMain.server().shutdown();
            System.exit(0);
        }
        OLogManager.instance().error((Object)this, "Authentication error of remote client %s:%d: shutdown is aborted.", new Object[]{this.channel.socket.getInetAddress(), this.channel.socket.getPort()});
        this.sendError(this.clientTxId, (Throwable)new OSecurityAccessException("Invalid user/password to shutdown the server"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyDatabase() throws IOException {
        this.setDataCommandInfo("Copy the database to a remote server");
        String dbUrl = this.channel.readString();
        String dbUser = this.channel.readString();
        String dbPassword = this.channel.readString();
        String remoteServerName = this.channel.readString();
        String remoteServerEngine = this.channel.readString();
        this.checkServerAccess("database.copy");
        ODatabaseDocumentTx db = (ODatabaseDocumentTx)OServerMain.server().openDatabase("document", dbUrl, dbUser, dbPassword);
        this.beginResponse();
        try {
            this.sendOk(this.clientTxId);
        }
        finally {
            this.endResponse();
        }
    }

    protected void replicationDatabase() throws IOException {
        this.setDataCommandInfo("Replication command");
        ODocument request = new ODocument(this.channel.readBytes());
        ODistributedServerManager dManager = this.server.getDistributedManager();
        if (dManager == null) {
            throw new OConfigurationException("No distributed manager configured");
        }
        ODocument response = null;
        String operation = (String)request.field("operation");
        if (operation.equals("start")) {
            this.checkServerAccess("server.replication.start");
        } else if (operation.equals("stop")) {
            this.checkServerAccess("server.replication.stop");
        } else if (operation.equals("align")) {
            this.checkServerAccess("server.replication.align");
        } else if (operation.equals("getJournal")) {
            this.checkServerAccess("server.replication.getJournal");
        } else if (operation.equals("resetJournal")) {
            this.checkServerAccess("server.replication.resetJournal");
        } else if (operation.equals("getAllConflicts")) {
            OStorageSynchronizer dbSynch = dManager.getDatabaseSynchronizer((String)request.field("db"));
            response = dbSynch.getConflictResolver().getAllConflicts();
        }
        this.sendResponse(response);
    }

    protected void distributedCluster() throws IOException {
        this.setDataCommandInfo("Cluster status");
        ODocument req = new ODocument(this.channel.readBytes());
        ODocument response = null;
        String operation = (String)req.field("operation");
        if (operation == null) {
            throw new IllegalArgumentException("Cluster operation is null");
        }
        if (operation.equals("status")) {
            Object plugin = OServerMain.server().getPlugin("cluster");
            if (plugin != null && plugin instanceof ODistributedServerManager) {
                response = ((ODistributedServerManager)plugin).getClusterConfiguration();
            }
        } else {
            throw new IllegalArgumentException("Cluster operation '" + operation + "' is not supported");
        }
        this.sendResponse(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void countDatabaseRecords() throws IOException {
        this.setDataCommandInfo("Database count records");
        this.checkDatabase();
        this.beginResponse();
        try {
            this.sendOk(this.clientTxId);
            this.channel.writeLong(this.connection.database.getStorage().countRecords());
        }
        finally {
            this.endResponse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sizeDatabase() throws IOException {
        this.setDataCommandInfo("Database size");
        this.checkDatabase();
        this.beginResponse();
        try {
            this.sendOk(this.clientTxId);
            this.channel.writeLong(this.connection.database.getStorage().getSize());
        }
        finally {
            this.endResponse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dropDatabase() throws IOException {
        this.setDataCommandInfo("Drop database");
        String dbName = this.channel.readString();
        this.checkServerAccess("database.delete");
        this.connection.database = this.getDatabaseInstance(dbName, "document", "local");
        if (this.connection.database.exists()) {
            OLogManager.instance().info((Object)this, "Dropped database '%s'", new Object[]{this.connection.database.getName()});
            if (this.connection.database.isClosed()) {
                this.openDatabase((ODatabaseComplex<?>)this.connection.database, this.connection.serverUser.name, this.connection.serverUser.password);
            }
        } else {
            throw new OStorageException("Database with name '" + dbName + "' doesn't exits.");
        }
        this.connection.database.drop();
        this.connection.close();
        this.beginResponse();
        try {
            this.sendOk(this.clientTxId);
        }
        finally {
            this.endResponse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void existsDatabase() throws IOException {
        this.setDataCommandInfo("Exists database");
        String dbName = this.channel.readString();
        this.checkServerAccess("database.exists");
        this.connection.database = this.getDatabaseInstance(dbName, "document", "local");
        this.beginResponse();
        try {
            this.sendOk(this.clientTxId);
            this.channel.writeByte((byte)(this.connection.database.exists() ? 1 : 0));
        }
        finally {
            this.endResponse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createDatabase() throws IOException {
        this.setDataCommandInfo("Create database");
        String dbName = this.channel.readString();
        String dbType = "document";
        if (this.connection.data.protocolVersion >= 8) {
            dbType = this.channel.readString();
        }
        String storageType = this.channel.readString();
        this.checkServerAccess("database.create");
        this.checkStorageExistence(dbName);
        this.connection.database = this.getDatabaseInstance(dbName, dbType, storageType);
        this.createDatabase(this.connection.database, null, null);
        this.connection.rawDatabase = (ODatabaseRaw)((ODatabaseComplex)this.connection.database.getUnderlying()).getUnderlying();
        this.beginResponse();
        try {
            this.sendOk(this.clientTxId);
        }
        finally {
            this.endResponse();
        }
    }

    protected void closeDatabase() throws IOException {
        this.setDataCommandInfo("Close Database");
        if (this.connection != null) {
            if (this.connection.data.protocolVersion > 0 && this.connection.data.protocolVersion < 9) {
                this.sendOk(this.clientTxId);
            }
            if (OClientConnectionManager.instance().disconnect(this.connection.id)) {
                this.sendShutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void configList() throws IOException {
        this.setDataCommandInfo("List config");
        this.checkServerAccess("server.config.get");
        this.beginResponse();
        try {
            this.sendOk(this.clientTxId);
            this.channel.writeShort((short)OGlobalConfiguration.values().length);
            for (OGlobalConfiguration cfg : OGlobalConfiguration.values()) {
                this.channel.writeString(cfg.getKey());
                this.channel.writeString(cfg.getValueAsString() != null ? cfg.getValueAsString() : "");
            }
        }
        finally {
            this.endResponse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void configSet() throws IOException {
        this.setDataCommandInfo("Get config");
        this.checkServerAccess("server.config.set");
        String key = this.channel.readString();
        String value = this.channel.readString();
        OGlobalConfiguration cfg = OGlobalConfiguration.findByKey((String)key);
        if (cfg != null) {
            cfg.setValue((Object)value);
        }
        this.beginResponse();
        try {
            this.sendOk(this.clientTxId);
        }
        finally {
            this.endResponse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void configGet() throws IOException {
        this.setDataCommandInfo("Get config");
        this.checkServerAccess("server.config.get");
        String key = this.channel.readString();
        OGlobalConfiguration cfg = OGlobalConfiguration.findByKey((String)key);
        String cfgValue = cfg != null ? cfg.getValueAsString() : "";
        this.beginResponse();
        try {
            this.sendOk(this.clientTxId);
            this.channel.writeString(cfgValue);
        }
        finally {
            this.endResponse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void commit() throws IOException {
        this.setDataCommandInfo("Transaction commit");
        this.checkDatabase();
        OTransactionOptimisticProxy tx = new OTransactionOptimisticProxy((ODatabaseRecordTx)this.connection.database.getUnderlying(), (OChannelBinary)this.channel);
        try {
            this.connection.database.begin((OTransaction)tx);
            try {
                this.connection.database.commit();
                this.beginResponse();
                try {
                    this.sendOk(this.clientTxId);
                    this.channel.writeInt(tx.getCreatedRecords().size());
                    for (Map.Entry<ORecordId, ORecord<?>> entry : tx.getCreatedRecords().entrySet()) {
                        this.channel.writeRID((ORID)entry.getKey());
                        this.channel.writeRID(entry.getValue().getIdentity());
                        if (entry.getValue().getVersion() <= 0) continue;
                        tx.getUpdatedRecords().put((ORecordId)entry.getValue().getIdentity(), entry.getValue());
                    }
                    this.channel.writeInt(tx.getUpdatedRecords().size());
                    for (Map.Entry<ORecordId, ORecord<?>> entry : tx.getUpdatedRecords().entrySet()) {
                        this.channel.writeRID((ORID)entry.getKey());
                        this.channel.writeInt(entry.getValue().getVersion());
                    }
                }
                finally {
                    this.endResponse();
                }
            }
            catch (Exception e) {
                this.connection.database.rollback();
                this.sendError(this.clientTxId, e);
            }
        }
        catch (OTransactionAbortedException e) {
        }
        catch (Exception e) {
            tx.close();
            this.sendError(this.clientTxId, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void command() throws IOException {
        block15: {
            this.setDataCommandInfo("Execute remote command");
            boolean asynch = this.channel.readByte() == 97;
            OCommandRequestText command = (OCommandRequestText)OStreamSerializerAnyStreamable.INSTANCE.fromStream(this.channel.readBytes());
            OQuery query = (OQuery)(command instanceof OQuery ? command : null);
            this.connection.data.commandDetail = command.getText();
            this.beginResponse();
            try {
                if (asynch) {
                    final StringBuilder empty = new StringBuilder();
                    final HashSet recordsToSend = new HashSet();
                    final int txId = this.clientTxId;
                    final Map fetchPlan = query != null ? OFetchHelper.buildFetchPlan((String)query.getFetchPlan()) : null;
                    command.setResultListener(new OCommandResultListener(){

                        public boolean result(Object iRecord) {
                            if (empty.length() == 0) {
                                try {
                                    ONetworkProtocolBinary.this.sendOk(txId);
                                    empty.append("-");
                                }
                                catch (IOException e1) {
                                    // empty catch block
                                }
                            }
                            try {
                                ONetworkProtocolBinary.this.channel.writeByte((byte)1);
                                ONetworkProtocolBinary.this.writeIdentifiable((OIdentifiable)((ORecordInternal)((OIdentifiable)iRecord).getRecord()));
                                if (fetchPlan != null && iRecord instanceof ODocument) {
                                    ODocument doc = (ODocument)iRecord;
                                    ORemoteFetchListener listener = new ORemoteFetchListener(recordsToSend);
                                    ORemoteFetchContext context = new ORemoteFetchContext();
                                    OFetchHelper.fetch((ORecordInternal)doc, (Object)iRecord, (Map)fetchPlan, (OFetchListener)listener, (OFetchContext)context);
                                }
                            }
                            catch (IOException e) {
                                return false;
                            }
                            return true;
                        }
                    });
                    ((OCommandRequestInternal)this.connection.database.command((OCommandRequest)command)).execute(new Object[0]);
                    if (empty.length() == 0) {
                        try {
                            this.sendOk(this.clientTxId);
                        }
                        catch (IOException e1) {
                            // empty catch block
                        }
                    }
                    for (ODocument doc : recordsToSend) {
                        this.channel.writeByte((byte)2);
                        this.writeIdentifiable((OIdentifiable)doc);
                    }
                    this.channel.writeByte((byte)0);
                    break block15;
                }
                Object result = ((OCommandRequestInternal)this.connection.database.command((OCommandRequest)command)).execute(new Object[0]);
                this.sendOk(this.clientTxId);
                if (result == null) {
                    this.channel.writeByte((byte)110);
                } else if (result instanceof OIdentifiable) {
                    this.channel.writeByte((byte)114);
                    this.writeIdentifiable((OIdentifiable)result);
                } else if (result instanceof Collection) {
                    this.channel.writeByte((byte)108);
                    Collection list = (Collection)result;
                    this.channel.writeInt(list.size());
                    for (OIdentifiable o : list) {
                        this.writeIdentifiable(o);
                    }
                } else {
                    this.channel.writeByte((byte)97);
                    StringBuilder value = new StringBuilder();
                    ORecordSerializerStringAbstract.fieldTypeToString((StringBuilder)value, (OType)OType.getTypeByClass(result.getClass()), (Object)result);
                    this.channel.writeString(value.toString());
                }
            }
            finally {
                this.endResponse();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    protected void countCluster() throws IOException {
        this.setDataCommandInfo("Count cluster records");
        this.checkDatabase();
        String clusterName = this.channel.readString();
        long size = this.connection.database.countClusterElements(clusterName);
        this.beginResponse();
        try {
            this.sendOk(this.clientTxId);
            this.channel.writeLong(size);
        }
        finally {
            this.endResponse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteRecord() throws IOException {
        this.setDataCommandInfo("Delete record");
        this.checkDatabase();
        ORecordId rid = this.channel.readRID();
        int version = this.channel.readInt();
        byte mode = this.channel.readByte();
        int result = this.deleteRecord((ODatabaseRecord)this.connection.database, (ORID)rid, version);
        if (mode < 2) {
            this.beginResponse();
            try {
                this.sendOk(this.clientTxId);
                this.channel.writeByte((byte)result);
            }
            finally {
                this.endResponse();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateRecord() throws IOException {
        this.setDataCommandInfo("Update record");
        this.checkDatabase();
        ORecordId rid = this.channel.readRID();
        byte[] buffer = this.channel.readBytes();
        int version = this.channel.readInt();
        byte recordType = this.channel.readByte();
        byte mode = this.channel.readByte();
        int newVersion = this.updateRecord((ODatabaseRecord)this.connection.database, rid, buffer, version, recordType);
        if (mode < 2) {
            this.beginResponse();
            try {
                this.sendOk(this.clientTxId);
                this.channel.writeInt(newVersion);
            }
            finally {
                this.endResponse();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createRecord() throws IOException {
        this.setDataCommandInfo("Create record");
        this.checkDatabase();
        int dataSegmentId = this.connection.data.protocolVersion >= 10 ? this.channel.readInt() : 0;
        ORecordId rid = new ORecordId((int)this.channel.readShort(), -1L);
        byte[] buffer = this.channel.readBytes();
        byte recordType = this.channel.readByte();
        byte mode = this.channel.readByte();
        ORecordInternal<?> record = this.createRecord((ODatabaseRecord)this.connection.database, rid, buffer, recordType, dataSegmentId);
        if (mode < 2) {
            this.beginResponse();
            try {
                this.sendOk(this.clientTxId);
                this.channel.writeLong(record.getIdentity().getClusterPosition());
                if (this.connection.data.protocolVersion >= 11) {
                    this.channel.writeInt(record.getVersion());
                }
            }
            finally {
                this.endResponse();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readRecord() throws IOException {
        this.setDataCommandInfo("Load record");
        ORecordId rid = this.channel.readRID();
        String fetchPlanString = this.channel.readString();
        boolean ignoreCache = false;
        if (this.connection.data.protocolVersion >= 9) {
            boolean bl = ignoreCache = this.channel.readByte() == 1;
        }
        if (rid.clusterId == 0 && rid.clusterPosition == 0L) {
            OFetchHelper.checkFetchPlanValid((String)fetchPlanString);
            this.beginResponse();
            try {
                this.sendOk(this.clientTxId);
                this.channel.writeByte((byte)1);
                this.channel.writeBytes(this.connection.database.getStorage().getConfiguration().toStream());
                this.channel.writeInt(0);
                this.channel.writeByte((byte)98);
                this.channel.writeByte((byte)0);
            }
            finally {
                this.endResponse();
            }
        }
        ORecordInternal record = this.connection.database.load((ORID)rid, fetchPlanString, ignoreCache);
        this.beginResponse();
        try {
            this.sendOk(this.clientTxId);
            if (record != null) {
                this.channel.writeByte((byte)1);
                this.channel.writeBytes(record.toStream());
                this.channel.writeInt(record.getVersion());
                this.channel.writeByte(record.getRecordType());
                if (fetchPlanString.length() > 0 && record instanceof ODocument) {
                    Map fetchPlan = OFetchHelper.buildFetchPlan((String)fetchPlanString);
                    HashSet recordsToSend = new HashSet();
                    ODocument doc = (ODocument)record;
                    ORemoteFetchListener listener = new ORemoteFetchListener(recordsToSend);
                    ORemoteFetchContext context = new ORemoteFetchContext();
                    OFetchHelper.fetch((ORecordInternal)doc, (Object)doc, (Map)fetchPlan, (OFetchListener)listener, (OFetchContext)context);
                    for (ODocument d : recordsToSend) {
                        if (!d.getIdentity().isValid()) continue;
                        this.channel.writeByte((byte)2);
                        this.writeIdentifiable((OIdentifiable)d);
                    }
                }
            }
            this.channel.writeByte((byte)0);
        }
        finally {
            this.endResponse();
        }
    }

    protected void endResponse() throws IOException {
        this.channel.flush();
        this.channel.releaseExclusiveLock();
    }

    protected void beginResponse() {
        this.channel.acquireExclusiveLock();
    }

    protected void setDataCommandInfo(String iCommandInfo) {
        if (this.connection != null) {
            this.connection.data.commandInfo = iCommandInfo;
        }
    }

    protected void readConnectionData() throws IOException {
        this.connection.data.driverName = this.channel.readString();
        this.connection.data.driverVersion = this.channel.readString();
        this.connection.data.protocolVersion = this.channel.readShort();
        this.connection.data.clientId = this.channel.readString();
    }

    private void sendDatabaseInformation() throws IOException {
        Collection clusters = this.connection.database.getStorage().getClusterInstances();
        if (this.connection.data.protocolVersion >= 7) {
            this.channel.writeShort((short)clusters.size());
        } else {
            this.channel.writeInt(clusters.size());
        }
        for (OCluster c : clusters) {
            if (c == null) continue;
            this.channel.writeString(c.getName());
            this.channel.writeShort((short)c.getId());
            this.channel.writeString(c.getType());
            if (this.connection.data.protocolVersion < 12) continue;
            this.channel.writeShort((short)c.getDataSegmentId());
        }
    }

    public void startup() {
        super.startup();
        OServerHandlerHelper.invokeHandlerCallbackOnClientConnection(this.connection);
    }

    @Override
    public void shutdown() {
        super.shutdown();
        if (this.connection == null) {
            return;
        }
        OServerHandlerHelper.invokeHandlerCallbackOnClientDisconnection(this.connection);
        OClientConnectionManager.instance().disconnect(this.connection);
    }

    @Override
    protected void sendOk(int iClientTxId) throws IOException {
        this.channel.writeByte((byte)0);
        this.channel.writeInt(iClientTxId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listDatabases() throws IOException {
        this.checkServerAccess("server.dblist");
        ODocument result = new ODocument();
        result.field("databases", OServerMain.server().getAvailableStorageNames());
        this.setDataCommandInfo("List databases");
        this.beginResponse();
        try {
            this.sendOk(this.clientTxId);
            this.channel.writeBytes(result.toStream());
        }
        finally {
            this.endResponse();
        }
    }

    private boolean loadUserFromSchema(String iUserName, String iUserPassword) {
        this.account = this.connection.database.getMetadata().getSecurity().authenticate(iUserName, iUserPassword);
        return true;
    }

    protected void checkDatabase() {
        if (this.connection == null) {
            throw new OStorageException("Connection with remote server has been lost");
        }
        if (this.connection.database == null) {
            throw new OSecurityAccessException("You need to authenticate before to execute the requested operation");
        }
    }

    @Override
    protected void handleConnectionError(OChannelBinaryServer iChannel, Throwable e) {
        super.handleConnectionError(this.channel, e);
        OServerHandlerHelper.invokeHandlerCallbackOnClientError(this.connection, e);
    }

    @Override
    public String getType() {
        return "binary";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendResponse(ODocument iResponse) throws IOException {
        this.beginResponse();
        try {
            this.sendOk(this.clientTxId);
            this.channel.writeBytes(iResponse != null ? iResponse.toStream() : null);
        }
        finally {
            this.endResponse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void freezeDatabase() throws IOException {
        this.setDataCommandInfo("Freeze database");
        String dbName = this.channel.readString();
        this.checkServerAccess("database.freeze");
        this.connection.database = this.getDatabaseInstance(dbName, "document", "local");
        if (this.connection.database.exists()) {
            OLogManager.instance().info((Object)this, "Freezing database '%s'", new Object[]{this.connection.database.getURL()});
            if (this.connection.database.isClosed()) {
                this.openDatabase((ODatabaseComplex<?>)this.connection.database, this.connection.serverUser.name, this.connection.serverUser.password);
            }
        } else {
            throw new OStorageException("Database with name '" + dbName + "' doesn't exits.");
        }
        this.connection.database.freeze(true);
        this.beginResponse();
        try {
            this.sendOk(this.clientTxId);
        }
        finally {
            this.endResponse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseDatabase() throws IOException {
        this.setDataCommandInfo("Release database");
        String dbName = this.channel.readString();
        this.checkServerAccess("database.release");
        this.connection.database = this.getDatabaseInstance(dbName, "document", "local");
        if (this.connection.database.exists()) {
            OLogManager.instance().info((Object)this, "Realising database '%s'", new Object[]{this.connection.database.getURL()});
            if (this.connection.database.isClosed()) {
                this.openDatabase((ODatabaseComplex<?>)this.connection.database, this.connection.serverUser.name, this.connection.serverUser.password);
            }
        } else {
            throw new OStorageException("Database with name '" + dbName + "' doesn't exits.");
        }
        this.connection.database.release();
        this.beginResponse();
        try {
            this.sendOk(this.clientTxId);
        }
        finally {
            this.endResponse();
        }
    }
}

