/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.serialization.OBinaryProtocol;
import com.orientechnologies.orient.core.serialization.serializer.OJSONWriter;
import com.orientechnologies.orient.server.network.protocol.http.OHttpUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.List;

public class OHttpResponse {
    public static final String JSON_FORMAT = "type,indent:2,rid,version,attribSameRow,class";
    public static final char[] URL_SEPARATOR = new char[]{'/'};
    private final OutputStream out;
    public final String httpVersion;
    public String headers;
    public String[] additionalHeaders;
    public String characterSet;
    public String serverInfo;
    public String sessionId;
    public String callbackFunction;

    public OHttpResponse(OutputStream iOutStream, String iHttpVersion, String[] iAdditionalHeaders, String iResponseCharSet, String iServerInfo, String iSessionId, String iCallbackFunction) {
        this.out = iOutStream;
        this.httpVersion = iHttpVersion;
        this.additionalHeaders = iAdditionalHeaders;
        this.characterSet = iResponseCharSet;
        this.serverInfo = iServerInfo;
        this.sessionId = iSessionId;
        this.callbackFunction = iCallbackFunction;
    }

    public void send(int iCode, String iReason, String iContentType, Object iContent, String iHeaders) throws IOException {
        this.send(iCode, iReason, iContentType, iContent, iHeaders, true);
    }

    public void send(int iCode, String iReason, String iContentType, Object iContent, String iHeaders, boolean iKeepAlive) throws IOException {
        String contentType;
        String content;
        if (this.callbackFunction != null) {
            content = this.callbackFunction + "(" + iContent + ")";
            contentType = "text/javascript";
        } else {
            content = iContent != null ? iContent.toString() : null;
            contentType = iContentType;
        }
        boolean empty = content == null || content.length() == 0;
        this.writeStatus(empty && iCode == 200 ? 204 : iCode, iReason);
        this.writeHeaders(contentType, iKeepAlive);
        if (this.additionalHeaders != null) {
            for (String h : this.additionalHeaders) {
                this.writeLine(h);
            }
        }
        if (iHeaders != null) {
            this.writeLine(iHeaders);
        }
        String sessId = this.sessionId != null ? this.sessionId : "-";
        this.writeLine("Set-Cookie: OSESSIONID=" + sessId + "; Path=/; HttpOnly");
        byte[] binaryContent = empty ? null : OBinaryProtocol.string2bytes((String)content);
        this.writeLine("Content-Length: " + (empty ? 0 : binaryContent.length));
        this.writeLine(null);
        if (binaryContent != null) {
            this.out.write(binaryContent);
        }
        this.out.flush();
    }

    public void writeStatus(int iStatus, String iReason) throws IOException {
        this.writeLine(this.httpVersion + " " + iStatus + " " + iReason);
    }

    public void writeHeaders(String iContentType) throws IOException {
        this.writeHeaders(iContentType, true);
    }

    public void writeHeaders(String iContentType, boolean iKeepAlive) throws IOException {
        if (this.headers != null) {
            this.writeLine(this.headers);
        }
        this.writeLine("Date: " + new Date());
        this.writeLine("Content-Type: " + iContentType + "; charset=" + this.characterSet);
        this.writeLine("Server: " + this.serverInfo);
        this.writeLine("Connection: " + (iKeepAlive ? "Keep-Alive" : "close"));
        if (this.additionalHeaders != null) {
            for (String h : this.additionalHeaders) {
                this.writeLine(h);
            }
        }
    }

    public void writeLine(String iContent) throws IOException {
        this.writeContent(iContent);
        this.out.write(OHttpUtils.EOL);
    }

    public void writeContent(String iContent) throws IOException {
        if (iContent != null) {
            this.out.write(OBinaryProtocol.string2bytes((String)iContent));
        }
    }

    public void writeRecords(List<OIdentifiable> iRecords) throws IOException {
        this.writeRecords(iRecords, null);
    }

    public void writeRecords(List<OIdentifiable> iRecords, String iFetchPlan) throws IOException {
        StringWriter buffer = new StringWriter();
        OJSONWriter json = new OJSONWriter((Writer)buffer, JSON_FORMAT);
        json.beginObject();
        String format = iFetchPlan != null ? "type,indent:2,rid,version,attribSameRow,class,fetchPlan:" + iFetchPlan : JSON_FORMAT;
        json.beginCollection(1, true, "result");
        this.formatCollection(iRecords, buffer, format);
        json.endCollection(1, true);
        json.endObject();
        this.send(200, "OK", "application/json", buffer.toString(), null);
    }

    public void formatCollection(List<OIdentifiable> iRecords, StringWriter buffer, String format) {
        if (iRecords != null) {
            int counter = 0;
            for (OIdentifiable rec : iRecords) {
                if (rec == null) continue;
                try {
                    String objectJson = rec.getRecord().toJSON(format);
                    if (counter++ > 0) {
                        buffer.append(", ");
                    }
                    buffer.append(objectJson);
                }
                catch (Exception e) {
                    OLogManager.instance().error((Object)this, "Error transforming record " + rec.getIdentity() + " to JSON", (Throwable)e, new Object[0]);
                }
            }
        }
    }

    public void writeRecord(ORecord<?> iRecord) throws IOException {
        this.writeRecord(iRecord, null);
    }

    public void writeRecord(ORecord<?> iRecord, String iFetchPlan) throws IOException {
        String format;
        String string = format = iFetchPlan != null ? "type,indent:2,rid,version,attribSameRow,class,fetchPlan:" + iFetchPlan : JSON_FORMAT;
        if (iRecord != null) {
            this.send(200, "OK", "application/json", iRecord.toJSON(format), null);
        }
    }

    public void sendStream(int iCode, String iReason, String iContentType, InputStream iContent, long iSize) throws IOException {
        this.writeStatus(iCode, iReason);
        this.writeHeaders(iContentType);
        this.writeLine("Content-Length: " + iSize);
        this.writeLine(null);
        if (iContent != null) {
            int b;
            while ((b = iContent.read()) > -1) {
                this.out.write(b);
            }
        }
        this.out.flush();
    }

    public void setHeader(String iHeader) {
        this.headers = iHeader;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public void flush() throws IOException {
        this.out.flush();
    }
}

