/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequestException;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommand;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.List;

public abstract class OServerCommandAbstract
implements OServerCommand {
    @Override
    public boolean beforeExecute(OHttpRequest iRequest, OHttpResponse iResponse) throws IOException {
        iResponse.setHeader("Cache-Control: no-cache, no-store, max-age=0, must-revalidate\r\nPragma: no-cache");
        return true;
    }

    protected String[] checkSyntax(String iURL, int iArgumentCount, String iSyntax) {
        List parts = OStringSerializerHelper.smartSplit((String)iURL, (char[])OHttpResponse.URL_SEPARATOR, (int)1, (int)-1, (boolean)true, (char[])new char[0]);
        if (parts.size() < iArgumentCount) {
            throw new OHttpRequestException(iSyntax);
        }
        String[] array = new String[parts.size()];
        return this.decodeParts(parts.toArray(array));
    }

    private String[] decodeParts(String[] parts) {
        try {
            if (parts == null) {
                return null;
            }
            for (int i = 0; i < parts.length; ++i) {
                String part = parts[i];
                if (part == null) continue;
                parts[i] = part = URLDecoder.decode(part, "UTF-8");
            }
            return parts;
        }
        catch (Exception ex) {
            throw new OException((Throwable)ex);
        }
    }
}

