/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command;

import com.orientechnologies.orient.server.OServerMain;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandAbstract;
import java.io.IOException;

public abstract class OServerCommandAuthenticatedServerAbstract
extends OServerCommandAbstract {
    private static final String SESSIONID_UNAUTHORIZED = "-";
    private static final String SESSIONID_LOGOUT = "!";
    private final String resource;
    protected String serverUser;
    protected String serverPassword;

    protected OServerCommandAuthenticatedServerAbstract(String iRequiredResource) {
        this.resource = iRequiredResource;
    }

    @Override
    public boolean beforeExecute(OHttpRequest iRequest, OHttpResponse iResponse) throws IOException {
        return this.authenticate(iRequest, iResponse, true);
    }

    protected boolean authenticate(OHttpRequest iRequest, OHttpResponse iResponse, boolean iAskForAuthentication) throws IOException {
        if (this.checkGuestAccess()) {
            return true;
        }
        if (iAskForAuthentication && (iRequest.authorization == null || SESSIONID_LOGOUT.equals(iRequest.sessionId))) {
            this.sendAuthorizationRequest(iRequest, iResponse);
            return false;
        }
        if (iRequest.authorization != null) {
            String[] authParts = iRequest.authorization.split(":");
            this.serverUser = authParts[0];
            this.serverPassword = authParts[1];
            if (authParts.length == 2 && OServerMain.server().authenticate(this.serverUser, this.serverPassword, this.resource)) {
                return true;
            }
        }
        this.sendNotAuthorizedResponse(iRequest, iResponse);
        return false;
    }

    protected boolean checkGuestAccess() {
        return OServerMain.server().authenticate("guest", null, this.resource);
    }

    protected void sendNotAuthorizedResponse(OHttpRequest iRequest, OHttpResponse iResponse) throws IOException {
        iRequest.sessionId = SESSIONID_UNAUTHORIZED;
        iResponse.send(403, "Forbidden", "text/plain", "403 Forbidden.", "WWW-Authenticate: Basic realm=\"OrientDB Server\"", false);
    }

    protected void sendAuthorizationRequest(OHttpRequest iRequest, OHttpResponse iResponse) throws IOException {
        iRequest.sessionId = SESSIONID_UNAUTHORIZED;
        iResponse.send(401, "Unauthorized", "text/plain", "401 Unauthorized.", "WWW-Authenticate: Basic realm=\"OrientDB Server\"", false);
    }
}

