/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.all;

import com.orientechnologies.orient.core.command.script.OCommandScriptException;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.function.OFunction;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.server.db.OSharedDocumentDatabase;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequestWrapper;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponseWrapper;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandAuthenticatedDbAbstract;
import java.util.HashMap;

public class OServerCommandFunction
extends OServerCommandAuthenticatedDbAbstract {
    private static final String[] NAMES = new String[]{"GET|function/*", "POST|function/*"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(OHttpRequest iRequest, OHttpResponse iResponse) throws Exception {
        String[] parts = this.checkSyntax(iRequest.url, 3, "Syntax error: function/<database>/<name>[/param]*");
        iRequest.data.commandInfo = "Execute a function";
        ODatabaseDocumentTx db = null;
        Object result = null;
        try {
            db = this.getProfiledDatabaseInstance(iRequest);
            db.getMetadata().getFunctionLibrary().load();
            OFunction f = db.getMetadata().getFunctionLibrary().getFunction(parts[2]);
            if (f == null) {
                throw new IllegalArgumentException("Function '" + parts[2] + "' is not configured");
            }
            if (iRequest.httpMethod.equalsIgnoreCase("GET") && !f.isIdempotent()) {
                iResponse.send(400, "Bad request", "text/plain", "GET method is not allowed to execute function '" + parts[2] + "' because has been declared as non idempotent. Use POST instead.", null, true);
                boolean bl = false;
                return bl;
            }
            Object[] args = new Object[parts.length - 3];
            for (int i = 3; i < parts.length; ++i) {
                args[i - 3] = parts[i];
            }
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("request", new OHttpRequestWrapper(iRequest));
            context.put("response", new OHttpResponseWrapper(iResponse));
            result = f.executeInContext(context, args);
            if (result != null) {
                if (result instanceof ODocument && ((ODocument)result).isEmbedded()) {
                    iResponse.send(200, "OK", "application/json", ((ODocument)result).toJSON(), null, true);
                } else {
                    iResponse.send(200, "OK", "text/plain", result, null, true);
                }
            } else {
                iResponse.send(204, "", "text/plain", null, null, true);
            }
        }
        catch (OCommandScriptException e) {
            StringBuilder msg = new StringBuilder();
            for (Throwable currentException = e; currentException != null; currentException = (Exception)currentException.getCause()) {
                if (msg.length() > 0) {
                    msg.append("\n");
                }
                msg.append(currentException.getMessage());
            }
            iResponse.send(400, "Bad request", "text/plain", msg.toString(), null, true);
        }
        finally {
            if (db != null) {
                OSharedDocumentDatabase.release(db);
            }
        }
        return false;
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }
}

