/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.get;

import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.serialization.serializer.OJSONWriter;
import com.orientechnologies.orient.server.db.OSharedDocumentDatabase;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandAuthenticatedDbAbstract;
import com.orientechnologies.orient.server.network.protocol.http.command.get.OServerCommandGetConnect;
import java.io.StringWriter;
import java.io.Writer;

public class OServerCommandGetClass
extends OServerCommandAuthenticatedDbAbstract {
    private static final String[] NAMES = new String[]{"GET|class/*"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(OHttpRequest iRequest, OHttpResponse iResponse) throws Exception {
        String[] urlParts = this.checkSyntax(iRequest.url, 3, "Syntax error: class/<database>/<class-name>");
        iRequest.data.commandInfo = "Returns the information of a class in the schema";
        iRequest.data.commandDetail = urlParts[2];
        ODatabaseDocumentTx db = null;
        try {
            db = this.getProfiledDatabaseInstance(iRequest);
            if (db.getMetadata().getSchema().getClass(urlParts[2]) == null) {
                throw new IllegalArgumentException("Invalid class '" + urlParts[2] + "'");
            }
            StringWriter buffer = new StringWriter();
            OJSONWriter json = new OJSONWriter((Writer)buffer, "type,indent:2,rid,version,attribSameRow,class");
            OServerCommandGetConnect.exportClass(db, json, db.getMetadata().getSchema().getClass(urlParts[2]));
            iResponse.send(200, "OK", "application/json", buffer.toString(), null);
        }
        finally {
            if (db != null) {
                OSharedDocumentDatabase.release(db);
            }
        }
        return false;
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }
}

