/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.get;

import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.OJSONWriter;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.orientechnologies.orient.server.db.OSharedDocumentDatabase;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandAuthenticatedDbAbstract;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;

public class OServerCommandGetGephi
extends OServerCommandAuthenticatedDbAbstract {
    private static final String[] NAMES = new String[]{"GET|gephi/*"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(OHttpRequest iRequest, OHttpResponse iResponse) throws Exception {
        List response;
        String[] urlParts = this.checkSyntax(iRequest.url, 4, "Syntax error: gephi/<database>/sql/<query-text>[/<limit>][/<fetchPlan>].<br/>Limit is optional and is setted to 20 by default. Set expressely to 0 to have no limits.");
        int limit = urlParts.length > 4 ? Integer.parseInt(urlParts[4]) : 20;
        String fetchPlan = urlParts.length > 5 ? urlParts[5] : null;
        String text = urlParts[3];
        iRequest.data.commandInfo = "Gephi";
        iRequest.data.commandDetail = text;
        ODatabaseDocumentTx db = null;
        try {
            db = this.getProfiledDatabaseInstance(iRequest);
            response = (List)db.command((OCommandRequest)new OSQLSynchQuery(text, limit).setFetchPlan(fetchPlan)).execute(new Object[0]);
        }
        finally {
            if (db != null) {
                OSharedDocumentDatabase.release(db);
            }
        }
        this.sendRecordsContent(iRequest, iResponse, response, fetchPlan);
        return false;
    }

    protected void sendRecordsContent(OHttpRequest iRequest, OHttpResponse iResponse, List<OIdentifiable> iRecords, String iFetchPlan) throws IOException {
        StringWriter buffer = new StringWriter();
        OJSONWriter json = new OJSONWriter((Writer)buffer, "type,indent:2,rid,version,attribSameRow,class");
        if (iRecords.size() > 0) {
            ORecord firstRecord = iRecords.get(0).getRecord();
            OClass vertexBaseClass = firstRecord.getDatabase().getMetadata().getSchema().getClass("OGraphVertex");
            if (firstRecord instanceof ODocument && ((ODocument)firstRecord).getSchemaClass().isSubClassOf(vertexBaseClass)) {
                this.generateGraphDbOutput(iRecords, json);
            } else {
                this.generateDefaultOutput(iRecords, json);
            }
        }
        iResponse.send(200, "OK", "application/json", buffer.toString(), null);
    }

    protected void generateDefaultOutput(List<OIdentifiable> iRecords, OJSONWriter json) throws IOException {
        ArrayList<String[]> links = new ArrayList<String[]>();
        for (OIdentifiable oIdentifiable : iRecords) {
            if (!(oIdentifiable.getRecord() instanceof ODocument)) continue;
            ODocument doc = (ODocument)oIdentifiable.getRecord();
            json.resetAttributes();
            json.beginObject();
            json.beginObject(1, false, (Object)"an");
            json.beginObject(2, false, (Object)oIdentifiable.getIdentity());
            for (String field : doc.fieldNames()) {
                Object v = doc.field(field);
                if (v == null) continue;
                if (v instanceof OIdentifiable) {
                    links.add(new String[]{oIdentifiable.getIdentity().toString(), field, ((OIdentifiable)v).getIdentity().toString()});
                    continue;
                }
                if (v instanceof Collection) {
                    for (Object o : (Collection)v) {
                        if (!(o instanceof OIdentifiable)) continue;
                        links.add(new String[]{oIdentifiable.getIdentity().toString(), field, ((OIdentifiable)o).getIdentity().toString()});
                    }
                    continue;
                }
                json.writeAttribute(3, false, field, v);
            }
            json.endObject(2, false);
            json.endObject(1, false);
            json.endObject(0, false);
            json.newline();
        }
        for (String[] stringArray : links) {
            json.resetAttributes();
            json.beginObject();
            json.beginObject(1, false, (Object)"ae");
            json.beginObject(2, false, (Object)(stringArray[0] + "." + stringArray[1] + "." + stringArray[2]));
            json.writeAttribute(3, false, "source", (Object)stringArray[0]);
            json.writeAttribute(3, false, "label", (Object)stringArray[1]);
            json.writeAttribute(3, false, "target", (Object)stringArray[2]);
            json.writeAttribute(3, false, "directed", (Object)true);
            json.endObject(2, false);
            json.endObject(1, false);
            json.endObject(0, false);
            json.newline();
        }
    }

    protected void generateGraphDbOutput(List<OIdentifiable> iRecords, OJSONWriter json) throws IOException {
        Object v;
        ODocument doc;
        LinkedHashSet edges = new LinkedHashSet();
        for (OIdentifiable rec : iRecords) {
            if (!(rec.getRecord() instanceof ODocument)) continue;
            doc = (ODocument)rec.getRecord();
            json.resetAttributes();
            json.beginObject(0, false, null);
            json.beginObject(1, false, (Object)"an");
            json.beginObject(2, false, (Object)doc.getIdentity());
            for (String field : doc.fieldNames()) {
                v = doc.field(field);
                if (v == null) continue;
                if ("out".equals(field) || "in".equals(field)) {
                    edges.addAll((Collection)v);
                    continue;
                }
                json.writeAttribute(3, false, field, v);
            }
            json.endObject(2, false);
            json.endObject(1, false);
            json.endObject(0, false);
            json.newline();
        }
        for (OIdentifiable rec : edges) {
            doc = (ODocument)rec.getRecord();
            json.resetAttributes();
            json.beginObject();
            json.beginObject(1, false, (Object)"ae");
            json.beginObject(2, false, (Object)doc.getIdentity());
            json.writeAttribute(3, false, "directed", (Object)false);
            for (String field : doc.fieldNames()) {
                v = doc.field(field);
                if (v == null) continue;
                if ("in".equals(field)) {
                    json.writeAttribute(3, false, "source", v);
                    continue;
                }
                if ("out".equals(field)) {
                    json.writeAttribute(3, false, "target", v);
                    continue;
                }
                json.writeAttribute(3, false, field, v);
            }
            json.endObject(2, false);
            json.endObject(1, false);
            json.endObject(0, false);
            json.newline();
        }
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }
}

