/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.get;

import com.orientechnologies.common.concur.resource.OResourcePool;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.serialization.serializer.OJSONWriter;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.OStorageLocal;
import com.orientechnologies.orient.server.OClientConnection;
import com.orientechnologies.orient.server.OClientConnectionManager;
import com.orientechnologies.orient.server.OServerMain;
import com.orientechnologies.orient.server.config.OServerEntryConfiguration;
import com.orientechnologies.orient.server.db.OSharedDocumentDatabase;
import com.orientechnologies.orient.server.network.protocol.ONetworkProtocolData;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandAuthenticatedServerAbstract;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class OServerCommandGetServer
extends OServerCommandAuthenticatedServerAbstract {
    private static final String[] NAMES = new String[]{"GET|server"};
    private static final DateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");

    public OServerCommandGetServer() {
        super("server.info");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(OHttpRequest iRequest, OHttpResponse iResponse) throws Exception {
        this.checkSyntax(iRequest.url, 1, "Syntax error: server");
        iRequest.data.commandInfo = "Server status";
        StringWriter jsonBuffer = new StringWriter();
        OJSONWriter json = new OJSONWriter((Writer)jsonBuffer);
        json.beginObject();
        json.beginCollection(1, true, "connections");
        List<OClientConnection> conns = OClientConnectionManager.instance().getConnections();
        for (OClientConnection c : conns) {
            String connectedOn;
            String lastCommandOn;
            ONetworkProtocolData data = c.data;
            DateFormat dateFormat = dateTimeFormat;
            synchronized (dateFormat) {
                lastCommandOn = dateTimeFormat.format(new Date(data.lastCommandReceived));
                connectedOn = dateTimeFormat.format(new Date(c.since));
            }
            json.beginObject(2);
            this.writeField(json, 2, "connectionId", c.id);
            this.writeField(json, 2, "remoteAddress", c.protocol.getChannel() != null ? c.protocol.getChannel().toString() : "Disconnected");
            this.writeField(json, 2, "db", data.lastDatabase != null ? data.lastDatabase : "-");
            this.writeField(json, 2, "user", data.lastUser != null ? data.lastUser : "-");
            this.writeField(json, 2, "totalRequests", data.totalRequests);
            this.writeField(json, 2, "commandInfo", data.commandInfo);
            this.writeField(json, 2, "commandDetail", data.commandDetail);
            this.writeField(json, 2, "lastCommandOn", lastCommandOn);
            this.writeField(json, 2, "lastCommandInfo", data.lastCommandInfo);
            this.writeField(json, 2, "lastCommandDetail", data.lastCommandDetail);
            this.writeField(json, 2, "lastExecutionTime", data.lastCommandExecutionTime);
            this.writeField(json, 2, "totalWorkingTime", data.totalCommandExecutionTime);
            this.writeField(json, 2, "connectedOn", connectedOn);
            this.writeField(json, 2, "protocol", c.protocol.getType());
            this.writeField(json, 2, "clientId", data.clientId);
            StringBuilder driver = new StringBuilder();
            if (data.driverName != null) {
                driver.append(data.driverName);
                driver.append(" v");
                driver.append(data.driverVersion);
                driver.append(" Protocol v");
                driver.append(data.protocolVersion);
            }
            this.writeField(json, 2, "driver", driver.toString());
            json.endObject(2);
        }
        json.endCollection(1, false);
        json.beginCollection(1, true, "dbs");
        Map<String, OResourcePool<String, ODatabaseDocumentTx>> dbPool = OSharedDocumentDatabase.getDatabasePools();
        for (Map.Entry<String, OResourcePool<String, ODatabaseDocumentTx>> entry : dbPool.entrySet()) {
            for (ODatabaseDocumentTx db : entry.getValue().getResources()) {
                json.beginObject(2);
                this.writeField(json, 2, "db", db.getName());
                this.writeField(json, 2, "user", db.getUser() != null ? db.getUser().getName() : "-");
                this.writeField(json, 2, "status", db.isClosed() ? "closed" : "open");
                this.writeField(json, 2, "type", db.getType());
                this.writeField(json, 2, "storageType", db.getStorage().getType());
                json.endObject(2);
            }
        }
        json.endCollection(1, false);
        json.beginCollection(1, true, "storages");
        Collection storages = Orient.instance().getStorages();
        for (OStorage s : storages) {
            json.beginObject(2);
            this.writeField(json, 2, "name", s.getName());
            this.writeField(json, 2, "type", s.getClass().getSimpleName());
            this.writeField(json, 2, "path", s instanceof OStorageLocal ? ((OStorageLocal)s).getStoragePath().replace('\\', '/') : "");
            this.writeField(json, 2, "activeUsers", s.getUsers());
            json.endObject(2);
        }
        json.endCollection(1, false);
        json.beginCollection(2, true, "properties");
        for (OServerEntryConfiguration entry : OServerMain.server().getConfiguration().properties) {
            json.beginObject(3, true, null);
            json.writeAttribute(4, false, "name", (Object)entry.name);
            json.writeAttribute(4, false, "value", (Object)entry.value);
            json.endObject(3, true);
        }
        json.endCollection(2, true);
        json.endObject();
        iResponse.send(200, "OK", "application/json", jsonBuffer.toString(), null);
        return false;
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }

    private void writeField(OJSONWriter json, int iLevel, String iAttributeName, Object iAttributeValue) throws IOException {
        json.writeAttribute(iLevel, true, iAttributeName, (Object)(iAttributeValue != null ? iAttributeValue.toString() : "-"));
    }
}

