/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.get;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.server.config.OServerCommandConfiguration;
import com.orientechnologies.orient.server.config.OServerEntryConfiguration;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.command.get.OServerCommandConfigurableAbstract;
import com.orientechnologies.orient.server.network.protocol.http.command.get.OStaticContentCachedEntry;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class OServerCommandGetStaticContent
extends OServerCommandConfigurableAbstract {
    private static final String[] DEF_PATTERN = new String[]{"GET|www", "GET|studio/", "GET|", "GET|*.htm", "GET|*.html", "GET|*.xml", "GET|*.jpeg", "GET|*.jpg", "GET|*.png", "GET|*.gif", "GET|*.js", "GET|*.otf", "GET|*.css", "GET|*.swf", "GET|favicon.ico", "GET|robots.txt"};
    private static final String CONFIG_HTTP_CACHE = "http.cache:";
    private static final String CONFIG_ROOT_PATH = "root.path";
    private static final String CONFIG_FILE_PATH = "file.path";
    private Map<String, OStaticContentCachedEntry> cacheContents;
    private Map<String, String> cacheHttp = new HashMap<String, String>();
    private String cacheHttpDefault = "Cache-Control: max-age=3000";
    private String rootPath;
    private String filePath;

    public OServerCommandGetStaticContent() {
        super(DEF_PATTERN);
    }

    public OServerCommandGetStaticContent(OServerCommandConfiguration iConfiguration) {
        super(iConfiguration.pattern);
        for (OServerEntryConfiguration par : iConfiguration.parameters) {
            if (par.name.startsWith(CONFIG_HTTP_CACHE)) {
                String[] filters;
                String filter = par.name.substring(CONFIG_HTTP_CACHE.length());
                if (filter.equalsIgnoreCase("default")) {
                    this.cacheHttpDefault = par.value;
                    continue;
                }
                if (filter.length() <= 0) continue;
                for (String f : filters = filter.split(" ")) {
                    this.cacheHttp.put(f, par.value);
                }
                continue;
            }
            if (par.name.startsWith(CONFIG_ROOT_PATH)) {
                this.rootPath = par.value;
                continue;
            }
            if (!par.name.startsWith(CONFIG_FILE_PATH)) continue;
            this.filePath = par.value;
        }
    }

    @Override
    public boolean beforeExecute(OHttpRequest iRequest, OHttpResponse iResponse) throws IOException {
        String header = this.cacheHttpDefault;
        if (this.cacheHttp.size() > 0) {
            String resource = this.getResource(iRequest);
            for (Map.Entry<String, String> entry : this.cacheHttp.entrySet()) {
                int wildcardPos = entry.getKey().indexOf(42);
                String partLeft = entry.getKey().substring(0, wildcardPos);
                String partRight = entry.getKey().substring(wildcardPos + 1);
                if (!resource.startsWith(partLeft) || !resource.endsWith(partRight)) continue;
                header = entry.getValue();
                break;
            }
        }
        iResponse.setHeader(header);
        return super.beforeExecute(iRequest, iResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(OHttpRequest iRequest, OHttpResponse iResponse) throws Exception {
        iRequest.data.commandInfo = "Get static content";
        iRequest.data.commandDetail = iRequest.url;
        if (this.filePath == null && this.rootPath == null) {
            this.rootPath = iRequest.configuration.getValueAsString("orientdb.www.path", "src/site");
            if (this.rootPath == null) {
                OLogManager.instance().warn((Object)this, "No path configured. Specify the 'root.path', 'file.path' or the global 'orientdb.www.path' variable", new Object[]{this.rootPath});
                return false;
            }
        }
        if (this.filePath == null) {
            File wwwPathDirectory = new File(this.rootPath);
            if (!wwwPathDirectory.exists()) {
                OLogManager.instance().warn((Object)this, "path variable points to '%s' but it doesn't exists", new Object[]{this.rootPath});
            }
            if (!wwwPathDirectory.isDirectory()) {
                OLogManager.instance().warn((Object)this, "path variable points to '%s' but it isn't a directory", new Object[]{this.rootPath});
            }
        }
        if (this.cacheContents == null && OGlobalConfiguration.SERVER_CACHE_FILE_STATIC.getValueAsBoolean()) {
            this.cacheContents = new HashMap<String, OStaticContentCachedEntry>();
        }
        InputStream is = null;
        long contentSize = 0L;
        String type = null;
        try {
            Object url;
            String path = this.filePath != null ? this.filePath : (((String)(url = this.getResource(iRequest))).startsWith("/www") ? this.rootPath + ((String)url).substring("/www".length(), ((String)url).length()) : this.rootPath + (String)url);
            if (this.cacheContents != null) {
                url = this.cacheContents;
                synchronized (url) {
                    OStaticContentCachedEntry cachedEntry = this.cacheContents.get(path);
                    if (cachedEntry != null) {
                        is = new ByteArrayInputStream(cachedEntry.content);
                        contentSize = cachedEntry.size;
                        type = cachedEntry.type;
                    }
                }
            }
            if (is == null) {
                File inputFile = new File(path);
                if (!inputFile.exists()) {
                    OLogManager.instance().debug((Object)this, "Static resource not found: %s", new Object[]{path});
                    iResponse.sendStream(404, "File not found", null, null, 0L);
                    boolean cachedEntry = false;
                    return cachedEntry;
                }
                if (this.filePath == null && inputFile.isDirectory()) {
                    inputFile = new File(path + "/index.htm");
                    if (inputFile.exists()) {
                        path = path + "/index.htm";
                    } else {
                        inputFile = new File(path + "/index.html");
                        if (inputFile.exists()) {
                            path = path + "/index.html";
                        }
                    }
                }
                type = path.endsWith(".htm") || path.endsWith(".html") ? "text/html" : (path.endsWith(".png") ? "image/png" : (path.endsWith(".jpeg") ? "image/jpeg" : (path.endsWith(".js") ? "application/x-javascript" : (path.endsWith(".css") ? "text/css" : (path.endsWith(".ico") ? "image/x-icon" : (path.endsWith(".otf") ? "font/opentype" : "text/plain"))))));
                is = new BufferedInputStream(new FileInputStream(inputFile));
                contentSize = inputFile.length();
                if (this.cacheContents != null) {
                    byte[] buffer = new byte[(int)contentSize];
                    int i = 0;
                    while ((long)i < contentSize) {
                        buffer[i] = (byte)is.read();
                        ++i;
                    }
                    OStaticContentCachedEntry cachedEntry = new OStaticContentCachedEntry();
                    cachedEntry.content = buffer;
                    cachedEntry.size = contentSize;
                    cachedEntry.type = type;
                    this.cacheContents.put(path, cachedEntry);
                    is = new ByteArrayInputStream(cachedEntry.content);
                }
            }
            iResponse.sendStream(200, "OK", type, is, contentSize);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return false;
    }

    protected String getResource(OHttpRequest iRequest) {
        int pos;
        String url = "/".equals(iRequest.url) ? "/www/index.htm" : ((pos = iRequest.url.indexOf(63)) > -1 ? iRequest.url.substring(0, pos) : iRequest.url);
        return url;
    }
}

