/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.post;

import com.orientechnologies.orient.core.command.OCommandManager;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.server.db.OSharedDocumentDatabase;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandAuthenticatedDbAbstract;
import java.util.List;

public class OServerCommandPostCommand
extends OServerCommandAuthenticatedDbAbstract {
    private static final String[] NAMES = new String[]{"POST|command/*"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(OHttpRequest iRequest, OHttpResponse iResponse) throws Exception {
        Object response;
        String[] urlParts = this.checkSyntax(iRequest.url, 3, "Syntax error: command/<database>/<language>/<command-text>[/limit]");
        String language = urlParts.length > 2 ? urlParts[2].trim() : "sql";
        String text = urlParts.length > 3 ? urlParts[3].trim() : iRequest.content;
        int limit = urlParts.length > 4 ? Integer.parseInt(urlParts[4].trim()) : -1;
        iRequest.data.commandInfo = "Command";
        iRequest.data.commandDetail = text;
        ODatabaseDocumentTx db = null;
        try {
            db = this.getProfiledDatabaseInstance(iRequest);
            OCommandRequestText cmd = (OCommandRequestText)OCommandManager.instance().getRequester(language);
            cmd.setText(text);
            cmd.setLimit(limit);
            response = db.command((OCommandRequest)cmd).execute(new Object[0]);
        }
        finally {
            if (db != null) {
                OSharedDocumentDatabase.release(db);
            }
        }
        if (response instanceof List) {
            iResponse.writeRecords((List)response);
        } else if (response == null || response instanceof Integer) {
            iResponse.send(200, "OK", "text/plain", response, null);
        } else if (response instanceof ODocument) {
            iResponse.send(200, "OK", "text/plain", ((ODocument)response).toJSON(), null);
        } else {
            iResponse.send(200, "OK", "text/plain", response.toString(), null);
        }
        return false;
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }
}

