/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.post;

import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.server.db.OSharedDocumentDatabase;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandDocumentAbstract;

public class OServerCommandPostDocument
extends OServerCommandDocumentAbstract {
    private static final String[] NAMES = new String[]{"POST|document/*"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(OHttpRequest iRequest, OHttpResponse iResponse) throws Exception {
        this.checkSyntax(iRequest.url, 2, "Syntax error: document/<database>");
        iRequest.data.commandInfo = "Create document";
        ODatabaseDocumentTx db = null;
        ODocument doc = null;
        try {
            db = this.getProfiledDatabaseInstance(iRequest);
            doc = (ODocument)new ODocument().fromJSON(iRequest.content);
            ((ORecordId)doc.getIdentity()).clusterPosition = -1L;
            doc.save();
        }
        finally {
            if (db != null) {
                OSharedDocumentDatabase.release(db);
            }
        }
        iResponse.send(201, "Created", "text/plain", doc.getIdentity(), null, true);
        return false;
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }
}

