/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.post;

import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.server.db.OSharedDocumentDatabase;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequestException;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandAuthenticatedDbAbstract;
import java.io.IOException;
import java.util.Map;

public class OServerCommandPostProperty
extends OServerCommandAuthenticatedDbAbstract {
    private static final String PROPERTY_TYPE_JSON_FIELD = "propertyType";
    private static final String LINKED_CLASS_JSON_FIELD = "linkedClass";
    private static final String LINKED_TYPE_JSON_FIELD = "linkedType";
    private static final String[] NAMES = new String[]{"POST|property/*"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(OHttpRequest iRequest, OHttpResponse iResponse) throws Exception {
        ODatabaseDocumentTx db = null;
        try {
            db = this.getProfiledDatabaseInstance(iRequest);
            if (iRequest.content == null || iRequest.content.length() <= 0) {
                boolean bl = this.addSingleProperty(iRequest, iResponse, db);
                return bl;
            }
            boolean bl = this.addMultipreProperties(iRequest, iResponse, db);
            return bl;
        }
        finally {
            if (db != null) {
                OSharedDocumentDatabase.release(db);
            }
        }
    }

    protected boolean addSingleProperty(OHttpRequest iRequest, OHttpResponse iResponse, ODatabaseDocumentTx db) throws InterruptedException, IOException {
        String[] urlParts = this.checkSyntax(iRequest.url, 4, "Syntax error: property/<database>/<class-name>/<property-name>/[<property-type>]/[<link-type>]");
        iRequest.data.commandInfo = "Create property";
        iRequest.data.commandDetail = urlParts[2] + "." + urlParts[3];
        if (db.getMetadata().getSchema().getClass(urlParts[2]) == null) {
            throw new IllegalArgumentException("Invalid class '" + urlParts[2] + "'");
        }
        OClass cls = db.getMetadata().getSchema().getClass(urlParts[2]);
        String propertyName = urlParts[3];
        OType propertyType = urlParts.length > 4 ? OType.valueOf((String)urlParts[4]) : OType.STRING;
        switch (propertyType) {
            case LINKLIST: 
            case LINKMAP: 
            case LINKSET: {
                if (urlParts.length < 6) {
                    throw new OHttpRequestException("Syntax error: property named " + propertyName + " is declared as " + propertyType + " but linked type is not declared: property/<database>/<class-name>/<property-name>/<property-type>/<link-type>");
                }
                OType linkType = OType.valueOf((String)urlParts[5]);
                OClass linkClass = db.getMetadata().getSchema().getClass(urlParts[5]);
                if (linkType != null && linkClass != null) {
                    throw new IllegalArgumentException("linked type declared as " + urlParts[5] + " can be either a Type or a Class, use the JSON document usage instead. See 'http://code.google.com/p/orient/w/edit/OrientDB_REST'");
                }
                if (linkType != null) {
                    OProperty prop = cls.createProperty(propertyName, propertyType, linkType);
                    break;
                }
                if (linkClass != null) {
                    OProperty prop = cls.createProperty(propertyName, propertyType, linkClass);
                    break;
                }
                throw new IllegalArgumentException("property named " + propertyName + " is declared as " + propertyType + " but linked type is not declared");
            }
            case LINK: {
                if (urlParts.length < 6) {
                    throw new OHttpRequestException("Syntax error: property named " + propertyName + " is declared as " + propertyType + " but linked type is not declared: property/<database>/<class-name>/<property-name>/<property-type>/<link-type>");
                }
                String linkClass = urlParts[5];
                if (linkClass != null) {
                    OProperty prop = cls.createProperty(propertyName, propertyType, db.getMetadata().getSchema().getClass(linkClass));
                    break;
                }
                throw new IllegalArgumentException("property named " + propertyName + " is declared as " + propertyType + " but linked Class is not declared");
            }
            default: {
                OProperty prop = cls.createProperty(propertyName, propertyType);
            }
        }
        iResponse.send(201, "Created", "text/plain", cls.properties().size(), null);
        return false;
    }

    protected boolean addMultipreProperties(OHttpRequest iRequest, OHttpResponse iResponse, ODatabaseDocumentTx db) throws InterruptedException, IOException {
        String[] urlParts = this.checkSyntax(iRequest.url, 3, "Syntax error: property/<database>/<class-name>");
        iRequest.data.commandInfo = "Create property";
        iRequest.data.commandDetail = urlParts[2];
        if (db.getMetadata().getSchema().getClass(urlParts[2]) == null) {
            throw new IllegalArgumentException("Invalid class '" + urlParts[2] + "'");
        }
        OClass cls = db.getMetadata().getSchema().getClass(urlParts[2]);
        ODocument propertiesDoc = (ODocument)new ODocument().fromJSON(iRequest.content);
        block4: for (String propertyName : propertiesDoc.fieldNames()) {
            Map doc = (Map)propertiesDoc.field(propertyName);
            OType propertyType = OType.valueOf((String)((String)doc.get(PROPERTY_TYPE_JSON_FIELD)));
            switch (propertyType) {
                case LINKLIST: 
                case LINKMAP: 
                case LINKSET: {
                    OProperty prop;
                    String linkType = (String)doc.get(LINKED_TYPE_JSON_FIELD);
                    String linkClass = (String)doc.get(LINKED_CLASS_JSON_FIELD);
                    if (linkType != null) {
                        prop = cls.createProperty(propertyName, propertyType, OType.valueOf((String)linkType));
                        continue block4;
                    }
                    if (linkClass != null) {
                        prop = cls.createProperty(propertyName, propertyType, db.getMetadata().getSchema().getClass(linkClass));
                        continue block4;
                    }
                    throw new IllegalArgumentException("property named " + propertyName + " is declared as " + propertyType + " but linked type is not declared");
                }
                case LINK: {
                    String linkClass = (String)doc.get(LINKED_CLASS_JSON_FIELD);
                    if (linkClass != null) {
                        OProperty prop = cls.createProperty(propertyName, propertyType, db.getMetadata().getSchema().getClass(linkClass));
                        continue block4;
                    }
                    throw new IllegalArgumentException("property named " + propertyName + " is declared as " + propertyType + " but linked Class is not declared");
                }
                default: {
                    OProperty prop = cls.createProperty(propertyName, propertyType);
                }
            }
        }
        iResponse.send(201, "Created", "text/plain", cls.properties().size(), null);
        return false;
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }
}

