/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.plugin.mail;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.script.OScriptInjection;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.config.OServerParameterConfiguration;
import com.orientechnologies.orient.server.handler.OServerHandlerAbstract;
import com.orientechnologies.orient.server.plugin.mail.OMailProfile;
import com.orientechnologies.orient.server.plugin.mail.OSMTPAuthenticator;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.script.Bindings;

public class OMailPlugin
extends OServerHandlerAbstract
implements OScriptInjection {
    private static final String CONFIG_PROFILE_PREFIX = "profile.";
    private static final String CONFIG_MAIL_PREFIX = "mail.";
    private Map<String, OMailProfile> profiles = new HashMap<String, OMailProfile>();

    public OMailPlugin() {
        Orient.instance().getScriptManager().registerInjection((OScriptInjection)this);
    }

    @Override
    public void config(OServer oServer, OServerParameterConfiguration[] iParams) {
        for (OServerParameterConfiguration param : iParams) {
            String parts;
            int pos;
            if (param.name.equalsIgnoreCase("enabled")) {
                if (Boolean.parseBoolean(param.value)) continue;
                return;
            }
            if (!param.name.startsWith(CONFIG_PROFILE_PREFIX) || (pos = (parts = param.name.substring(CONFIG_PROFILE_PREFIX.length())).indexOf(46)) == -1) continue;
            String profileName = parts.substring(0, pos);
            String profileParam = parts.substring(pos + 1);
            OMailProfile profile = this.profiles.get(profileName);
            if (profile == null) {
                profile = new OMailProfile();
                this.profiles.put(profileName, profile);
            }
            if (!profileParam.startsWith(CONFIG_MAIL_PREFIX)) continue;
            profile.properties.setProperty(CONFIG_MAIL_PREFIX + profileParam.substring(CONFIG_MAIL_PREFIX.length()), param.value);
        }
        OLogManager.instance().info((Object)this, "Mail plugin installed and active. Loaded %d profile(s): %s", new Object[]{this.profiles.size(), this.profiles.keySet()});
    }

    @Override
    public void shutdown() {
    }

    public void send(Map<String, Object> iMessage) throws AddressException, MessagingException, ParseException {
        Date sendDate;
        String profileName = (String)iMessage.get("profile");
        OMailProfile profile = this.profiles.get(profileName);
        if (profile == null) {
            throw new IllegalArgumentException("Mail profile '" + profileName + "' is not configured on server");
        }
        Properties prop = profile.properties;
        OSMTPAuthenticator auth = new OSMTPAuthenticator((String)prop.get("mail.smtp.user"), (String)prop.get("mail.smtp.password"));
        Session session = Session.getInstance((Properties)prop, (Authenticator)auth);
        MimeMessage msg = new MimeMessage(session);
        msg.setFrom((Address)new InternetAddress((String)prop.get("mail.smtp.user")));
        InternetAddress[] toAddresses = new InternetAddress[]{new InternetAddress((String)iMessage.get("to"))};
        msg.setRecipients(Message.RecipientType.TO, (Address[])toAddresses);
        InternetAddress[] ccAddresses = new InternetAddress[]{new InternetAddress((String)iMessage.get("cc"))};
        msg.setRecipients(Message.RecipientType.CC, (Address[])ccAddresses);
        InternetAddress[] bccAddresses = new InternetAddress[]{new InternetAddress((String)iMessage.get("bcc"))};
        msg.setRecipients(Message.RecipientType.BCC, (Address[])bccAddresses);
        msg.setSubject((String)iMessage.get("subject"));
        Object date = iMessage.get("date");
        if (date == null) {
            sendDate = new Date();
        } else if (date instanceof Date) {
            sendDate = (Date)date;
        } else {
            String dateFormat = (String)prop.get("mail.date.format");
            if (dateFormat == null) {
                dateFormat = "yyyy-MM-dd HH:mm:ss";
            }
            sendDate = new SimpleDateFormat(dateFormat).parse(date.toString());
        }
        msg.setSentDate(sendDate);
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        messageBodyPart.setContent(iMessage.get("message"), "text/html");
        MimeMultipart multipart = new MimeMultipart();
        multipart.addBodyPart((BodyPart)messageBodyPart);
        String[] attachments = (String[])iMessage.get("attachments");
        if (attachments != null && attachments.length > 0) {
            for (String filePath : attachments) {
                this.addAttachment((Multipart)multipart, filePath);
            }
        }
        msg.setContent((Multipart)multipart);
        Transport.send((Message)msg);
    }

    private void addAttachment(Multipart multipart, String filePath) throws MessagingException {
        MimeBodyPart attachPart = new MimeBodyPart();
        FileDataSource source = new FileDataSource(filePath);
        attachPart.setDataHandler(new DataHandler((DataSource)source));
        attachPart.setFileName(new File(filePath).getName());
        multipart.addBodyPart((BodyPart)attachPart);
    }

    public void bind(Bindings binding) {
        binding.put("mail", (Object)this);
    }

    public void unbind(Bindings binding) {
        binding.remove("mail");
    }

    public String getName() {
        return "mail";
    }
}

