/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.task;

import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.server.OServerMain;
import com.orientechnologies.orient.server.config.OServerUserConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.OStorageSynchronizer;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.Callable;

public abstract class OAbstractDistributedTask<T>
implements Callable<T>,
Externalizable {
    private static final long serialVersionUID = 1L;
    protected String nodeSource;
    protected String databaseName;
    protected long runId;
    protected long operationSerial;
    protected ODistributedServerManager.EXECUTION_MODE mode;
    protected STATUS status;
    protected boolean inheritedDatabase;
    protected static OServerUserConfiguration replicatorUser = OServerMain.server().getUser("replicator");

    public OAbstractDistributedTask() {
        this.status = STATUS.REMOTE_EXEC;
    }

    public OAbstractDistributedTask(long iRunId, long iOperationId) {
        this.runId = iRunId;
        this.operationSerial = iOperationId;
        this.status = STATUS.ALIGN;
    }

    public OAbstractDistributedTask(String nodeSource, String databaseName, ODistributedServerManager.EXECUTION_MODE iMode) {
        this.nodeSource = nodeSource;
        this.databaseName = databaseName;
        this.mode = iMode;
        this.status = STATUS.DISTRIBUTE;
        this.runId = this.getDistributedServerManager().getRunId();
        this.operationSerial = this.getDistributedServerManager().incrementDistributedSerial(databaseName);
    }

    public void handleConflict(String iRemoteNode, Object localResult, Object remoteResult) {
    }

    public abstract String getName();

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.nodeSource);
        out.writeUTF(this.databaseName);
        out.writeLong(this.runId);
        out.writeLong(this.operationSerial);
        out.writeByte(this.mode.ordinal());
        out.writeByte(this.status.ordinal());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.nodeSource = in.readUTF();
        this.databaseName = in.readUTF();
        this.runId = in.readLong();
        this.operationSerial = in.readLong();
        this.mode = ODistributedServerManager.EXECUTION_MODE.values()[in.readByte()];
        this.status = STATUS.values()[in.readByte()];
    }

    public String getNodeSource() {
        return this.nodeSource;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public long getOperationSerial() {
        return this.operationSerial;
    }

    public long getRunId() {
        return this.runId;
    }

    public ODistributedServerManager.EXECUTION_MODE getMode() {
        return this.mode;
    }

    public void setMode(ODistributedServerManager.EXECUTION_MODE iMode) {
        this.mode = iMode;
    }

    public STATUS getStatus() {
        return this.status;
    }

    public OAbstractDistributedTask<T> setStatus(STATUS status) {
        this.status = status;
        return this;
    }

    public void setNodeSource(String nodeSource) {
        this.nodeSource = nodeSource;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String toString() {
        return this.getName();
    }

    protected OStorageSynchronizer getDatabaseSynchronizer() {
        return this.getDistributedServerManager().getDatabaseSynchronizer(this.databaseName);
    }

    protected ODistributedServerManager getDistributedServerManager() {
        return (ODistributedServerManager)OServerMain.server().getVariable("ODistributedAbstractPlugin");
    }

    protected void setAsCompleted(OStorageSynchronizer dbSynchronizer, long operationLogOffset) throws IOException {
        dbSynchronizer.getLog().changeOperationStatus(operationLogOffset, null);
    }

    protected ODatabaseDocumentTx openDatabase() {
        this.inheritedDatabase = true;
        ODatabaseRecord db = ODatabaseRecordThreadLocal.INSTANCE.getIfDefined();
        if (db != null && db.getName().equals(this.databaseName) && !db.isClosed()) {
            if (db instanceof ODatabaseDocumentTx) {
                return (ODatabaseDocumentTx)db;
            }
            if (db.getDatabaseOwner() instanceof ODatabaseDocumentTx) {
                return (ODatabaseDocumentTx)db.getDatabaseOwner();
            }
        }
        this.inheritedDatabase = false;
        return (ODatabaseDocumentTx)OServerMain.server().openDatabase("document", this.databaseName, OAbstractDistributedTask.replicatorUser.name, OAbstractDistributedTask.replicatorUser.password);
    }

    protected void closeDatabase(ODatabaseDocumentTx iDatabase) {
        if (!this.inheritedDatabase) {
            iDatabase.close();
        }
    }

    public static enum STATUS {
        DISTRIBUTE,
        REMOTE_EXEC,
        ALIGN,
        LOCAL_EXEC;

    }
}

