/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.task;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.server.distributed.ODistributedException;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ODistributedThreadLocal;
import com.orientechnologies.orient.server.distributed.OServerOfflineException;
import com.orientechnologies.orient.server.distributed.OStorageSynchronizer;
import com.orientechnologies.orient.server.journal.ODatabaseJournal;
import com.orientechnologies.orient.server.task.OAbstractDistributedTask;
import java.io.IOException;
import java.util.Map;

public abstract class OAbstractRecordDistributedTask<T>
extends OAbstractDistributedTask<T> {
    protected ORecordId rid;
    protected int version;

    public OAbstractRecordDistributedTask() {
    }

    public OAbstractRecordDistributedTask(String nodeSource, String iDbName, ODistributedServerManager.EXECUTION_MODE iMode, ORecordId iRid, int iVersion) {
        super(nodeSource, iDbName, iMode);
        this.rid = iRid;
        this.version = iVersion;
    }

    public OAbstractRecordDistributedTask(long iRunId, long iOperationId, ORecordId iRid, int iVersion) {
        super(iRunId, iOperationId);
        this.rid = iRid;
        this.version = iVersion;
    }

    protected abstract ODatabaseJournal.OPERATION_TYPES getOperationType();

    protected abstract T executeOnLocalNode(OStorageSynchronizer var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T call() {
        long operationLogOffset;
        if (OLogManager.instance().isDebugEnabled()) {
            OLogManager.instance().debug((Object)this, "DISTRIBUTED <-[%s] %s %s v.%d", new Object[]{this.nodeSource, this.getName(), this.rid, this.version});
        }
        ODistributedServerManager dManager = this.getDistributedServerManager();
        if (this.status != OAbstractDistributedTask.STATUS.ALIGN && !dManager.checkStatus("online") && !this.nodeSource.equals(dManager.getLocalNodeId())) {
            throw new OServerOfflineException(dManager.getLocalNodeId(), "Cannot execute the operation because the server is offline: current status: " + dManager.getStatus());
        }
        OStorageSynchronizer dbSynchronizer = this.getDatabaseSynchronizer();
        ODatabaseJournal.OPERATION_TYPES opType = this.getOperationType();
        if (opType != null) {
            try {
                operationLogOffset = dbSynchronizer.getLog().journalOperation(this.runId, this.operationSerial, opType, this);
            }
            catch (IOException e) {
                OLogManager.instance().error((Object)this, "DISTRIBUTED <-[%s] error on logging operation %s %s v.%d", (Throwable)e, new Object[]{this.nodeSource, this.getName(), this.rid, this.version});
                throw new ODistributedException("Error on logging operation", e);
            }
        } else {
            operationLogOffset = -1L;
        }
        ODistributedThreadLocal.INSTANCE.distributedExecution = true;
        try {
            T t;
            Map<String, Object> distributedResult;
            T localResult = this.executeOnLocalNode(dbSynchronizer);
            if (opType != null) {
                try {
                    this.setAsCompleted(dbSynchronizer, operationLogOffset);
                }
                catch (IOException e) {
                    OLogManager.instance().error((Object)this, "DISTRIBUTED <-[%s] error on changing the log status for operation %s %s v.%d", (Throwable)e, new Object[]{this.nodeSource, this.getName(), this.rid, this.version});
                    throw new ODistributedException("Error on changing the log status", e);
                }
            }
            if (this.status == OAbstractDistributedTask.STATUS.DISTRIBUTE && (distributedResult = dbSynchronizer.distributeOperation((byte)3, this.rid, this)) != null) {
                for (Map.Entry<String, Object> entry : distributedResult.entrySet()) {
                    String remoteNode = entry.getKey();
                    Object remoteResult = entry.getValue();
                    if (localResult == remoteResult || (localResult != null || remoteResult == null) && (localResult == null || remoteResult != null)) continue;
                    this.handleConflict(remoteNode, localResult, remoteResult);
                }
            }
            if (this.mode != ODistributedServerManager.EXECUTION_MODE.FIRE_AND_FORGET) {
                t = localResult;
                return t;
            }
            t = null;
            return t;
        }
        finally {
            ODistributedThreadLocal.INSTANCE.distributedExecution = false;
        }
    }

    @Override
    public String toString() {
        return this.getName() + "(" + this.rid + " v." + this.version + ")";
    }

    public ORecordId getRid() {
        return this.rid;
    }

    public void setRid(ORecordId rid) {
        this.rid = rid;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }
}

