/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.task;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.task.OAbstractDistributedTask;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class OAlignResponseDistributedTask
extends OAbstractDistributedTask<Integer> {
    private static final long serialVersionUID = 1L;
    protected int aligned;

    public OAlignResponseDistributedTask() {
    }

    public OAlignResponseDistributedTask(String nodeSource, String iDbName, ODistributedServerManager.EXECUTION_MODE iMode, int iAligned) {
        super(nodeSource, iDbName, iMode);
        this.aligned = iAligned;
    }

    @Override
    public Integer call() throws Exception {
        ODistributedServerManager dManager = this.getDistributedServerManager();
        if (this.aligned == -1) {
            OLogManager.instance().warn((Object)this, "DISTRIBUTED <-[%s/%s] alignment postponed", new Object[]{this.nodeSource, this.databaseName});
            dManager.postponeAlignment(this.nodeSource, this.databaseName);
        } else {
            OLogManager.instance().warn((Object)this, "DISTRIBUTED <-[%s/%s] alignment ended: %d operation(s)", new Object[]{this.nodeSource, this.databaseName, this.aligned});
            dManager.endAlignment(this.nodeSource, this.databaseName);
        }
        return null;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.aligned);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.aligned = in.readInt();
    }

    @Override
    public String getName() {
        return "align_response";
    }
}

