/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.task;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.OStorageSynchronizer;
import com.orientechnologies.orient.server.distributed.conflict.OReplicationConflictResolver;
import com.orientechnologies.orient.server.journal.ODatabaseJournal;
import com.orientechnologies.orient.server.task.OAbstractRecordDistributedTask;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class ODeleteRecordDistributedTask
extends OAbstractRecordDistributedTask<Boolean> {
    private static final long serialVersionUID = 1L;

    public ODeleteRecordDistributedTask() {
    }

    public ODeleteRecordDistributedTask(String nodeSource, String iDbName, ODistributedServerManager.EXECUTION_MODE iMode, ORecordId iRid, int iVersion) {
        super(nodeSource, iDbName, iMode, iRid, iVersion);
    }

    public ODeleteRecordDistributedTask(long iRunId, long iOperationId, ORecordId iRid, int iVersion) {
        super(iRunId, iOperationId, iRid, iVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Boolean executeOnLocalNode(OStorageSynchronizer dbSynchronizer) {
        OLogManager.instance().warn((Object)this, "DISTRIBUTED <-[%s/%s] DELETE RECORD %s v.%d", new Object[]{this.nodeSource, this.databaseName, this.rid, this.version});
        ODatabaseDocumentTx database = this.openDatabase();
        try {
            ORecordInternal record = database.load((ORID)this.rid);
            if (record != null) {
                record.setVersion(this.version);
                record.delete();
                Boolean bl = Boolean.TRUE;
                return bl;
            }
            Boolean bl = Boolean.FALSE;
            return bl;
        }
        finally {
            this.closeDatabase(database);
        }
    }

    @Override
    public void handleConflict(String iRemoteNodeId, Object localResult, Object remoteResult) {
        OReplicationConflictResolver resolver = this.getDatabaseSynchronizer().getConflictResolver();
        resolver.handleDeleteConflict(iRemoteNodeId, this.rid);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeUTF(this.rid.toString());
        out.writeInt(this.version);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.rid = new ORecordId(in.readUTF());
        this.version = in.readInt();
    }

    @Override
    public String getName() {
        return "record_delete";
    }

    @Override
    protected ODatabaseJournal.OPERATION_TYPES getOperationType() {
        return ODatabaseJournal.OPERATION_TYPES.RECORD_DELETE;
    }
}

