/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.task;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.task.OAbstractDistributedTask;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;

public class OMultipleDistributedTasks
extends OAbstractDistributedTask<Object[]> {
    private static final long serialVersionUID = 1L;
    private List<OAbstractDistributedTask<?>> tasks = new ArrayList();

    public OMultipleDistributedTasks() {
    }

    public OMultipleDistributedTasks(String nodeSource, String iDbName, ODistributedServerManager.EXECUTION_MODE iMode) {
        super(nodeSource, iDbName, iMode);
    }

    @Override
    public Object[] call() throws Exception {
        OLogManager.instance().warn((Object)this, "DISTRIBUTED <-[%s/%s] executing group of %d command(s)", new Object[]{this.nodeSource, this.databaseName, this.tasks.size()});
        Object[] result = new Object[this.tasks.size()];
        for (int i = 0; i < this.tasks.size(); ++i) {
            OAbstractDistributedTask<?> task = this.tasks.get(i);
            result[i] = task.call();
        }
        return result;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.tasks.size());
        for (int i = 0; i < this.tasks.size(); ++i) {
            out.writeObject(this.tasks.get(i));
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        int taskSize = in.readInt();
        for (int i = 0; i < taskSize; ++i) {
            this.tasks.add((OAbstractDistributedTask)in.readObject());
        }
    }

    @Override
    public String getName() {
        return "multiple_requests";
    }

    public int getTasks() {
        return this.tasks.size();
    }

    public void addTask(OAbstractDistributedTask<?> operation) {
        this.tasks.add(operation);
    }

    public void clearTasks() {
        this.tasks.clear();
    }

    public OAbstractDistributedTask<?> getTask(int i) {
        return this.tasks.get(i);
    }
}

