/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.task;

import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.OStorageSynchronizer;
import com.orientechnologies.orient.server.journal.ODatabaseJournal;
import com.orientechnologies.orient.server.task.OAbstractRecordDistributedTask;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class OReadRecordDistributedTask
extends OAbstractRecordDistributedTask<ORawBuffer> {
    private static final long serialVersionUID = 1L;

    public OReadRecordDistributedTask() {
    }

    public OReadRecordDistributedTask(String nodeSource, String iDbName, ORecordId iRid) {
        super(nodeSource, iDbName, ODistributedServerManager.EXECUTION_MODE.SYNCHRONOUS, iRid, -1);
    }

    public OReadRecordDistributedTask(long iRunId, long iOperationId, ORecordId iRid) {
        super(iRunId, iOperationId, iRid, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ORawBuffer executeOnLocalNode(OStorageSynchronizer dbSynchronizer) {
        ODatabaseDocumentTx database = this.openDatabase();
        try {
            ORecordInternal record = database.load((ORID)this.rid);
            if (record == null) {
                ORawBuffer oRawBuffer = null;
                return oRawBuffer;
            }
            ORawBuffer oRawBuffer = new ORawBuffer(record);
            return oRawBuffer;
        }
        finally {
            this.closeDatabase(database);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeUTF(this.rid.toString());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.rid = new ORecordId(in.readUTF());
    }

    @Override
    public String getName() {
        return "record_read";
    }

    @Override
    protected ODatabaseJournal.OPERATION_TYPES getOperationType() {
        return null;
    }
}

