/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.task;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ODistributedThreadLocal;
import com.orientechnologies.orient.server.distributed.OServerOfflineException;
import com.orientechnologies.orient.server.task.OAbstractDistributedTask;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class OSQLCommandDistributedTask
extends OAbstractDistributedTask<Object> {
    private static final long serialVersionUID = 1L;
    protected String text;

    public OSQLCommandDistributedTask() {
    }

    public OSQLCommandDistributedTask(String nodeSource, String databaseName, ODistributedServerManager.EXECUTION_MODE iMode, String iCommand) {
        super(nodeSource, databaseName, iMode);
        this.text = iCommand;
    }

    public OSQLCommandDistributedTask(long iRunId, long iOperationId, String iCommand) {
        this.text = iCommand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object call() throws Exception {
        if (OLogManager.instance().isDebugEnabled()) {
            OLogManager.instance().debug((Object)this, "DISTRIBUTED <- command: %s", new Object[]{this.text.toString()});
        }
        if (this.status != OAbstractDistributedTask.STATUS.ALIGN && !this.getDistributedServerManager().checkStatus("online")) {
            throw new OServerOfflineException();
        }
        ODatabaseDocumentTx db = this.openDatabase();
        ODistributedThreadLocal.INSTANCE.distributedExecution = true;
        try {
            OCommandRequest result = this.openDatabase().command((OCommandRequest)new OCommandSQL(this.text));
            if (this.mode != ODistributedServerManager.EXECUTION_MODE.FIRE_AND_FORGET) {
                OCommandRequest oCommandRequest = result;
                return oCommandRequest;
            }
            Object var3_4 = null;
            return var3_4;
        }
        finally {
            ODistributedThreadLocal.INSTANCE.distributedExecution = false;
            this.closeDatabase(db);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeUTF(this.text);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.text = in.readUTF();
    }

    @Override
    public String getName() {
        return "command_sql";
    }

    @Override
    public String toString() {
        return this.getName() + "(" + this.text + ")";
    }
}

