/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.tx;

import com.orientechnologies.common.collection.OCompositeKey;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.record.ODatabaseRecordTx;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordLazyList;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.exception.OTransactionAbortedException;
import com.orientechnologies.orient.core.exception.OTransactionException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializerAnyStreamable;
import com.orientechnologies.orient.core.tx.OTransactionIndexChanges;
import com.orientechnologies.orient.core.tx.OTransactionOptimistic;
import com.orientechnologies.orient.core.tx.OTransactionRealAbstract;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinary;
import com.orientechnologies.orient.server.tx.OTransactionEntryProxy;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OTransactionOptimisticProxy
extends OTransactionOptimistic {
    private final Map<ORecordId, ORecord<?>> createdRecords = new HashMap();
    private final Map<ORecordId, ORecord<?>> updatedRecords = new HashMap();
    private final int clientTxId;
    private final OChannelBinary channel;

    public OTransactionOptimisticProxy(ODatabaseRecordTx iDatabase, OChannelBinary iChannel) throws IOException {
        super(iDatabase);
        this.channel = iChannel;
        this.clientTxId = iChannel.readInt();
    }

    public void begin() {
        super.begin();
        try {
            this.setUsingLog(this.channel.readByte() == 1);
            byte lastTxStatus = this.channel.readByte();
            while (lastTxStatus == 1) {
                OTransactionEntryProxy entry;
                byte recordStatus = this.channel.readByte();
                ORecordId rid = this.channel.readRID();
                byte by = this.channel.readByte();
                switch (recordStatus) {
                    case 3: {
                        entry = new OTransactionEntryProxy(by);
                        entry.type = recordStatus;
                        entry.getRecord().fill(rid, 0, this.channel.readBytes(), true);
                        this.createdRecords.put(rid.copy(), (ORecord<?>)entry.getRecord());
                        break;
                    }
                    case 1: {
                        ORecordInternal currentRecord;
                        ORecordInternal newRecord = Orient.instance().getRecordFactoryManager().newInstance(by);
                        newRecord.fill(rid, this.channel.readInt(), this.channel.readBytes(), true);
                        if (newRecord.getRecordType() == 100) {
                            currentRecord = this.getDatabase().load((ORID)rid);
                            if (currentRecord == null) {
                                throw new ORecordNotFoundException(rid.toString());
                            }
                            if (currentRecord.getRecordType() == 100) {
                                ((ODocument)currentRecord).merge((ODocument)newRecord, false, false);
                            }
                        } else {
                            currentRecord = newRecord;
                        }
                        currentRecord.setVersion(newRecord.getVersion());
                        entry = new ORecordOperation((OIdentifiable)currentRecord, recordStatus);
                        this.updatedRecords.put(rid, (ORecord<?>)currentRecord);
                        break;
                    }
                    case 2: {
                        entry = new OTransactionEntryProxy(by);
                        entry.type = recordStatus;
                        entry.getRecord().fill(rid, this.channel.readInt(), null, false);
                        break;
                    }
                    default: {
                        throw new OTransactionException("Unrecognized tx command: " + recordStatus);
                    }
                }
                this.recordEntries.put(entry.getRecord().getIdentity(), entry);
                lastTxStatus = this.channel.readByte();
            }
            if (lastTxStatus == -1) {
                throw new OTransactionAbortedException("Transaction aborted by the client");
            }
            ODocument remoteIndexEntries = new ODocument(this.channel.readBytes());
            this.fillIndexOperations(remoteIndexEntries);
            for (Map.Entry entry : this.recordEntries.entrySet()) {
                this.addRecord(((ORecordOperation)entry.getValue()).getRecord(), ((ORecordOperation)entry.getValue()).type, null);
            }
            for (ORecord oRecord : this.createdRecords.values()) {
                this.unmarshallRecord(oRecord);
            }
            for (ORecord oRecord : this.updatedRecords.values()) {
                this.unmarshallRecord(oRecord);
            }
        }
        catch (IOException e) {
            this.rollback();
            throw new OSerializationException("Cannot read transaction record from the network. Transaction aborted", (Throwable)e);
        }
    }

    public ORecordInternal<?> getRecord(ORID rid) {
        ORecordInternal record = super.getRecord(rid);
        if (record == OTransactionRealAbstract.DELETED_RECORD) {
            return null;
        }
        if (record == null && rid.isNew()) {
            record = (ORecordInternal)this.createdRecords.get(rid);
        }
        return record;
    }

    private void fillIndexOperations(ODocument remoteIndexEntries) {
        for (Map.Entry indexEntry : remoteIndexEntries) {
            Collection entries;
            Boolean clearAll;
            String indexName = (String)indexEntry.getKey();
            ODocument indexDoc = (ODocument)indexEntry.getValue();
            if (indexDoc == null) continue;
            OTransactionIndexChanges transactionIndexChanges = (OTransactionIndexChanges)this.indexEntries.get(indexEntry.getKey());
            if (transactionIndexChanges == null) {
                transactionIndexChanges = new OTransactionIndexChanges();
                this.indexEntries.put(indexEntry.getKey(), transactionIndexChanges);
            }
            if ((clearAll = (Boolean)indexDoc.field("clear")) != null && clearAll.booleanValue()) {
                transactionIndexChanges.setCleared();
            }
            if ((entries = (Collection)indexDoc.field("entries")) == null) continue;
            for (ODocument entry : entries) {
                Object key;
                List operations = (List)entry.field("ops");
                if (operations == null) continue;
                String serializedKey = OStringSerializerHelper.decode((String)((String)entry.field("k")));
                try {
                    if (serializedKey.equals("*")) {
                        key = null;
                    } else {
                        ODocument keyContainer = new ODocument();
                        keyContainer.setLazyLoad(false);
                        keyContainer.fromString(serializedKey);
                        Object storedKey = keyContainer.field("key");
                        key = storedKey instanceof List ? new OCompositeKey((List)storedKey) : (Boolean.TRUE.equals(keyContainer.field("binary")) ? OStreamSerializerAnyStreamable.INSTANCE.fromStream((byte[])storedKey) : storedKey);
                    }
                }
                catch (IOException ioe) {
                    throw new OTransactionException("Error during index changes deserialization. ", (Throwable)ioe);
                }
                for (ODocument op : operations) {
                    int operation = (Integer)op.rawField("o");
                    OTransactionIndexChanges.OPERATION indexOperation = OTransactionIndexChanges.OPERATION.values()[operation];
                    OIdentifiable value = (OIdentifiable)op.field("v", OType.LINK);
                    if (key != null) {
                        transactionIndexChanges.getChangesPerKey(key).add(value, indexOperation);
                    } else {
                        transactionIndexChanges.getChangesCrossKey().add(value, indexOperation);
                    }
                    if (value == null) continue;
                    ORID rid = value.getIdentity();
                    ArrayList<OTransactionRealAbstract.OTransactionRecordIndexOperation> txIndexOperations = (ArrayList<OTransactionRealAbstract.OTransactionRecordIndexOperation>)this.recordIndexOperations.get(rid);
                    if (txIndexOperations == null) {
                        txIndexOperations = new ArrayList<OTransactionRealAbstract.OTransactionRecordIndexOperation>();
                        this.recordIndexOperations.put(rid, txIndexOperations);
                    }
                    txIndexOperations.add(new OTransactionRealAbstract.OTransactionRecordIndexOperation(indexName, key, indexOperation));
                }
            }
        }
    }

    public Map<ORecordId, ORecord<?>> getCreatedRecords() {
        return this.createdRecords;
    }

    public Map<ORecordId, ORecord<?>> getUpdatedRecords() {
        return this.updatedRecords;
    }

    private void unmarshallRecord(ORecord<?> iRecord) {
        if (iRecord instanceof ODocument) {
            ((ODocument)iRecord).deserializeFields(new String[0]);
            for (Map.Entry field : (ODocument)iRecord) {
                if (!(field.getValue() instanceof ORecordLazyList)) continue;
                ((ORecordLazyList)field.getValue()).lazyLoad(true);
            }
        }
    }
}

