/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed;

import com.orientechnologies.common.concur.resource.OSharedResourceAdaptiveExternal;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.cache.OLevel2RecordCache;
import com.orientechnologies.orient.core.command.OCommandDistributedConditionalReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandExecutor;
import com.orientechnologies.orient.core.command.OCommandManager;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestInternal;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.config.OStorageConfiguration;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.id.OClusterPosition;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLDelegate;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.ODataSegment;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.storage.ORecordMetadata;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.OStorageEmbedded;
import com.orientechnologies.orient.core.storage.OStorageOperationResult;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.version.ORecordVersion;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedException;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ODistributedThreadLocal;
import com.orientechnologies.orient.server.distributed.OReplicationConfig;
import com.orientechnologies.orient.server.distributed.OStorageSynchronizer;
import com.orientechnologies.orient.server.distributed.task.OCreateRecordTask;
import com.orientechnologies.orient.server.distributed.task.ODeleteRecordTask;
import com.orientechnologies.orient.server.distributed.task.OReadRecordTask;
import com.orientechnologies.orient.server.distributed.task.OSQLCommandTask;
import com.orientechnologies.orient.server.distributed.task.OUpdateRecordTask;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;

public class ODistributedStorage
implements OStorage {
    protected final OServer serverInstance;
    protected final ODistributedServerManager dManager;
    protected final OStorageEmbedded wrapped;
    protected final OStorageSynchronizer dbSynchronizer;
    protected boolean eventuallyConsistent = true;
    protected ODistributedServerManager.EXECUTION_MODE createRecordMode = ODistributedServerManager.EXECUTION_MODE.SYNCHRONOUS;
    protected ODistributedServerManager.EXECUTION_MODE updateRecordMode = ODistributedServerManager.EXECUTION_MODE.SYNCHRONOUS;
    protected ODistributedServerManager.EXECUTION_MODE deleteRecordMode = ODistributedServerManager.EXECUTION_MODE.SYNCHRONOUS;

    public ODistributedStorage(OServer iServer, OStorageSynchronizer dbSynchronizer, OStorageEmbedded wrapped) {
        this.serverInstance = iServer;
        this.dManager = iServer.getDistributedManager();
        this.wrapped = wrapped;
        this.dbSynchronizer = dbSynchronizer;
    }

    public Object command(OCommandRequestText iCommand) {
        OCommandExecutor exec;
        if (ODistributedThreadLocal.INSTANCE.get() != null) {
            return this.wrapped.command(iCommand);
        }
        OReplicationConfig replicationData = this.dManager.getReplicationData(this.getName(), null, null, this.dManager.getLocalNodeId(), null);
        if (replicationData == null) {
            return this.wrapped.command(iCommand);
        }
        OCommandExecutor executor = OCommandManager.instance().getExecutor((OCommandRequestInternal)iCommand);
        executor.setProgressListener(iCommand.getProgressListener());
        executor.parse((OCommandRequest)iCommand);
        boolean distribute = false;
        Object object = exec = executor instanceof OCommandExecutorSQLDelegate ? ((OCommandExecutorSQLDelegate)executor).getDelegate() : executor;
        if (ODistributedThreadLocal.INSTANCE.get() == null) {
            if (exec instanceof OCommandDistributedConditionalReplicateRequest) {
                distribute = ((OCommandDistributedConditionalReplicateRequest)exec).isReplicated();
            } else if (exec instanceof OCommandDistributedReplicateRequest) {
                distribute = true;
            }
        }
        if (!distribute) {
            return this.wrapped.executeCommand(iCommand, executor);
        }
        try {
            return this.dManager.execute(null, null, new OSQLCommandTask(this.serverInstance, this.serverInstance.getDistributedManager(), this.wrapped.getName(), this.createRecordMode, iCommand.getText()), replicationData);
        }
        catch (ExecutionException e) {
            this.handleDistributedException("Cannot route COMMAND operation to the distributed node", e, new Object[0]);
            return null;
        }
    }

    public OStorageOperationResult<OPhysicalPosition> createRecord(int iDataSegmentId, ORecordId iRecordId, byte[] iContent, ORecordVersion iRecordVersion, byte iRecordType, int iMode, ORecordCallback<OClusterPosition> iCallback) {
        if (ODistributedThreadLocal.INSTANCE.get() != null) {
            return this.wrapped.createRecord(iDataSegmentId, iRecordId, iContent, iRecordVersion, iRecordType, iMode, iCallback);
        }
        Object result = null;
        try {
            String clusterName = this.getClusterNameFromRID(iRecordId);
            OReplicationConfig replicationData = this.dManager.getReplicationData(this.getName(), clusterName, iRecordId, this.dManager.getLocalNodeId(), null);
            if (replicationData == null) {
                return this.wrapped.createRecord(iDataSegmentId, iRecordId, iContent, iRecordVersion, iRecordType, iMode, iCallback);
            }
            result = this.dManager.execute(clusterName, iRecordId, new OCreateRecordTask(this.serverInstance, this.serverInstance.getDistributedManager(), this.wrapped.getName(), this.createRecordMode, iRecordId, iContent, iRecordVersion, iRecordType), replicationData);
            iRecordId.clusterPosition = ((OPhysicalPosition)result).clusterPosition;
        }
        catch (ExecutionException e) {
            this.handleDistributedException("Cannot route CREATE_RECORD operation against %s to the distributed node", e, iRecordId);
        }
        return new OStorageOperationResult((Object)((OPhysicalPosition)result));
    }

    public OStorageOperationResult<ORawBuffer> readRecord(ORecordId iRecordId, String iFetchPlan, boolean iIgnoreCache, ORecordCallback<ORawBuffer> iCallback, boolean loadTombstones) {
        if (ODistributedThreadLocal.INSTANCE.get() != null) {
            return this.wrapped.readRecord(iRecordId, iFetchPlan, iIgnoreCache, iCallback, loadTombstones);
        }
        if (this.eventuallyConsistent || this.dManager.isLocalNodeMaster(iRecordId)) {
            return this.wrapped.readRecord(iRecordId, iFetchPlan, iIgnoreCache, iCallback, loadTombstones);
        }
        try {
            String clusterName = this.getClusterNameFromRID(iRecordId);
            OReplicationConfig replicationData = this.dManager.getReplicationData(this.getName(), clusterName, iRecordId, this.dManager.getLocalNodeId(), null);
            if (replicationData == null) {
                return this.wrapped.readRecord(iRecordId, iFetchPlan, iIgnoreCache, iCallback, loadTombstones);
            }
            return new OStorageOperationResult((Object)((ORawBuffer)this.dManager.execute(clusterName, iRecordId, new OReadRecordTask(this.serverInstance, this.serverInstance.getDistributedManager(), this.wrapped.getName(), iRecordId), replicationData)));
        }
        catch (ExecutionException e) {
            this.handleDistributedException("Cannot route READ_RECORD operation against %s to the distributed node", e, iRecordId);
            return new OStorageOperationResult(null);
        }
    }

    public OStorageOperationResult<ORecordVersion> updateRecord(ORecordId iRecordId, byte[] iContent, ORecordVersion iVersion, byte iRecordType, int iMode, ORecordCallback<ORecordVersion> iCallback) {
        if (ODistributedThreadLocal.INSTANCE.get() != null) {
            return this.wrapped.updateRecord(iRecordId, iContent, iVersion, iRecordType, iMode, iCallback);
        }
        Object result = null;
        try {
            String clusterName = this.getClusterNameFromRID(iRecordId);
            OReplicationConfig replicationData = this.dManager.getReplicationData(this.getName(), clusterName, iRecordId, this.dManager.getLocalNodeId(), null);
            if (replicationData == null) {
                return this.wrapped.updateRecord(iRecordId, iContent, iVersion, iRecordType, iMode, iCallback);
            }
            result = this.dManager.execute(clusterName, iRecordId, new OUpdateRecordTask(this.serverInstance, this.serverInstance.getDistributedManager(), this.wrapped.getName(), this.updateRecordMode, iRecordId, iContent, iVersion, iRecordType), replicationData);
        }
        catch (ExecutionException e) {
            this.handleDistributedException("Cannot route UPDATE_RECORD operation against %s to the distributed node", e, iRecordId);
        }
        return new OStorageOperationResult((Object)((ORecordVersion)result));
    }

    public OStorageOperationResult<Boolean> deleteRecord(ORecordId iRecordId, ORecordVersion iVersion, int iMode, ORecordCallback<Boolean> iCallback) {
        if (ODistributedThreadLocal.INSTANCE.get() != null) {
            return this.wrapped.deleteRecord(iRecordId, iVersion, iMode, iCallback);
        }
        Object result = null;
        try {
            String clusterName = this.getClusterNameFromRID(iRecordId);
            OReplicationConfig replicationData = this.dManager.getReplicationData(this.getName(), clusterName, iRecordId, this.dManager.getLocalNodeId(), null);
            if (replicationData == null) {
                return this.wrapped.deleteRecord(iRecordId, iVersion, iMode, iCallback);
            }
            result = this.dManager.execute(clusterName, iRecordId, new ODeleteRecordTask(this.serverInstance, this.serverInstance.getDistributedManager(), this.wrapped.getName(), this.updateRecordMode, iRecordId, iVersion), replicationData);
        }
        catch (ExecutionException e) {
            this.handleDistributedException("Cannot route DELETE_RECORD operation against %s to the distributed node", e, iRecordId);
        }
        return new OStorageOperationResult((Object)((Boolean)result));
    }

    public boolean updateReplica(int dataSegmentId, ORecordId rid, byte[] content, ORecordVersion recordVersion, byte recordType) throws IOException {
        return this.wrapped.updateReplica(dataSegmentId, rid, content, recordVersion, recordType);
    }

    public ORecordMetadata getRecordMetadata(ORID rid) {
        return this.wrapped.getRecordMetadata(rid);
    }

    public boolean cleanOutRecord(ORecordId recordId, ORecordVersion recordVersion, int iMode, ORecordCallback<Boolean> callback) {
        return this.wrapped.cleanOutRecord(recordId, recordVersion, iMode, callback);
    }

    public boolean existsResource(String iName) {
        return this.wrapped.existsResource(iName);
    }

    public <T> T removeResource(String iName) {
        return (T)this.wrapped.removeResource(iName);
    }

    public <T> T getResource(String iName, Callable<T> iCallback) {
        return (T)this.wrapped.getResource(iName, iCallback);
    }

    public void open(String iUserName, String iUserPassword, Map<String, Object> iProperties) {
        this.wrapped.open(iUserName, iUserPassword, iProperties);
    }

    public void create(Map<String, Object> iProperties) {
        this.wrapped.create(iProperties);
    }

    public boolean exists() {
        return this.wrapped.exists();
    }

    public void reload() {
        this.wrapped.reload();
    }

    public void delete() {
        this.wrapped.delete();
    }

    public void close() {
        this.wrapped.close();
    }

    public void close(boolean iForce) {
        this.wrapped.close(iForce);
    }

    public boolean isClosed() {
        return this.wrapped.isClosed();
    }

    public OLevel2RecordCache getLevel2Cache() {
        return this.wrapped.getLevel2Cache();
    }

    public void commit(OTransaction iTx) {
        throw new ODistributedException("Transactions are not supported in distributed environment");
    }

    public void rollback(OTransaction iTx) {
        throw new ODistributedException("Transactions are not supported in distributed environment");
    }

    public OStorageConfiguration getConfiguration() {
        return this.wrapped.getConfiguration();
    }

    public int getClusters() {
        return this.wrapped.getClusters();
    }

    public Set<String> getClusterNames() {
        return this.wrapped.getClusterNames();
    }

    public OCluster getClusterById(int iId) {
        return this.wrapped.getClusterById(iId);
    }

    public Collection<? extends OCluster> getClusterInstances() {
        return this.wrapped.getClusterInstances();
    }

    public int addCluster(String iClusterType, String iClusterName, String iLocation, String iDataSegmentName, boolean forceListBased, Object ... iParameters) {
        return this.wrapped.addCluster(iClusterType, iClusterName, iLocation, iDataSegmentName, false, iParameters);
    }

    public int addCluster(String iClusterType, String iClusterName, int iRequestedId, String iLocation, String iDataSegmentName, boolean forceListBased, Object ... iParameters) {
        return this.wrapped.addCluster(iClusterType, iClusterName, iRequestedId, iLocation, iDataSegmentName, forceListBased, iParameters);
    }

    public boolean dropCluster(String iClusterName, boolean iTruncate) {
        return this.wrapped.dropCluster(iClusterName, iTruncate);
    }

    public boolean dropCluster(int iId, boolean iTruncate) {
        return this.wrapped.dropCluster(iId, iTruncate);
    }

    public int addDataSegment(String iDataSegmentName) {
        return this.wrapped.addDataSegment(iDataSegmentName);
    }

    public int addDataSegment(String iSegmentName, String iDirectory) {
        return this.wrapped.addDataSegment(iSegmentName, iDirectory);
    }

    public long count(int iClusterId) {
        return this.wrapped.count(iClusterId);
    }

    public long count(int iClusterId, boolean countTombstones) {
        return this.wrapped.count(iClusterId, countTombstones);
    }

    public long count(int[] iClusterIds) {
        return this.wrapped.count(iClusterIds);
    }

    public long count(int[] iClusterIds, boolean countTombstones) {
        return this.wrapped.count(iClusterIds, countTombstones);
    }

    public long getSize() {
        return this.wrapped.getSize();
    }

    public long countRecords() {
        return this.wrapped.countRecords();
    }

    public int getDefaultClusterId() {
        return this.wrapped.getDefaultClusterId();
    }

    public void setDefaultClusterId(int defaultClusterId) {
        this.wrapped.setDefaultClusterId(defaultClusterId);
    }

    public int getClusterIdByName(String iClusterName) {
        return this.wrapped.getClusterIdByName(iClusterName);
    }

    public String getClusterTypeByName(String iClusterName) {
        return this.wrapped.getClusterTypeByName(iClusterName);
    }

    public String getPhysicalClusterNameById(int iClusterId) {
        return this.wrapped.getPhysicalClusterNameById(iClusterId);
    }

    public boolean checkForRecordValidity(OPhysicalPosition ppos) {
        return this.wrapped.checkForRecordValidity(ppos);
    }

    public String getName() {
        return this.wrapped.getName();
    }

    public String getURL() {
        return this.wrapped.getURL();
    }

    public long getVersion() {
        return this.wrapped.getVersion();
    }

    public void synch() {
        this.wrapped.synch();
    }

    public int getUsers() {
        return this.wrapped.getUsers();
    }

    public int addUser() {
        return this.wrapped.addUser();
    }

    public int removeUser() {
        return this.wrapped.removeUser();
    }

    public OClusterPosition[] getClusterDataRange(int currentClusterId) {
        return this.wrapped.getClusterDataRange(currentClusterId);
    }

    public <V> V callInLock(Callable<V> iCallable, boolean iExclusiveLock) {
        return (V)this.wrapped.callInLock(iCallable, iExclusiveLock);
    }

    public <V> V callInRecordLock(Callable<V> iCallable, ORID rid, boolean iExclusiveLock) {
        return (V)this.wrapped.callInRecordLock(iCallable, rid, iExclusiveLock);
    }

    public ODataSegment getDataSegmentById(int iDataSegmentId) {
        return this.wrapped.getDataSegmentById(iDataSegmentId);
    }

    public int getDataSegmentIdByName(String iDataSegmentName) {
        return this.wrapped.getDataSegmentIdByName(iDataSegmentName);
    }

    public boolean dropDataSegment(String iName) {
        return this.wrapped.dropDataSegment(iName);
    }

    public OStorage.STATUS getStatus() {
        return this.wrapped.getStatus();
    }

    public void checkForClusterPermissions(String iClusterName) {
        this.wrapped.checkForClusterPermissions(iClusterName);
    }

    public boolean isHashClustersAreUsed() {
        return this.wrapped.isHashClustersAreUsed();
    }

    public OPhysicalPosition[] higherPhysicalPositions(int currentClusterId, OPhysicalPosition entry) {
        return this.wrapped.higherPhysicalPositions(currentClusterId, entry);
    }

    public OPhysicalPosition[] ceilingPhysicalPositions(int clusterId, OPhysicalPosition physicalPosition) {
        return this.wrapped.ceilingPhysicalPositions(clusterId, physicalPosition);
    }

    public OPhysicalPosition[] floorPhysicalPositions(int clusterId, OPhysicalPosition physicalPosition) {
        return this.wrapped.floorPhysicalPositions(clusterId, physicalPosition);
    }

    public OPhysicalPosition[] lowerPhysicalPositions(int currentClusterId, OPhysicalPosition entry) {
        return this.wrapped.lowerPhysicalPositions(currentClusterId, entry);
    }

    public OSharedResourceAdaptiveExternal getLock() {
        return this.wrapped.getLock();
    }

    public String getType() {
        return "distributed";
    }

    protected String getClusterNameFromRID(ORecordId iRecordId) {
        return OStorageSynchronizer.getClusterNameByRID((OStorage)this.wrapped, iRecordId);
    }

    protected void handleDistributedException(String iMessage, ExecutionException e, Object ... iParams) {
        OLogManager.instance().error((Object)this, iMessage, (Throwable)e, iParams);
        Throwable t = e.getCause();
        if (t instanceof OException) {
            throw (OException)t;
        }
        throw new OStorageException(String.format(iMessage, iParams), (Throwable)e);
    }
}

