/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.task;

import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.version.ORecordVersion;
import com.orientechnologies.orient.core.version.OVersionFactory;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.conflict.OReplicationConflictResolver;
import com.orientechnologies.orient.server.distributed.task.OAbstractRecordReplicatedTask;
import com.orientechnologies.orient.server.journal.ODatabaseJournal;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class ODeleteRecordTask
extends OAbstractRecordReplicatedTask<Boolean> {
    private static final long serialVersionUID = 1L;

    public ODeleteRecordTask() {
    }

    public ODeleteRecordTask(OServer iServer, ODistributedServerManager iDistributedSrvMgr, String iDbName, ODistributedServerManager.EXECUTION_MODE iMode, ORecordId iRid, ORecordVersion iVersion) {
        super(iServer, iDistributedSrvMgr, iDbName, iMode, iRid, iVersion);
    }

    public ODeleteRecordTask(long iRunId, long iOperationId, ORecordId iRid, ORecordVersion iVersion) {
        super(iRunId, iOperationId, iRid, iVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean executeOnLocalNode() {
        ODistributedServerLog.debug((Object)this, this.getDistributedServerManager().getLocalNodeId(), this.getNodeSource(), ODistributedServerLog.DIRECTION.IN, "delete record %s/%s v.%s oper=%d.%d", this.databaseName, this.rid.toString(), this.version.toString(), this.runId, this.operationSerial);
        ODatabaseDocumentTx database = this.openDatabase();
        try {
            ORecordInternal record = database.load((ORID)this.rid);
            if (record != null) {
                record.getRecordVersion().copyFrom(this.version);
                record.delete();
                Boolean bl = Boolean.TRUE;
                return bl;
            }
            Boolean bl = Boolean.FALSE;
            return bl;
        }
        finally {
            this.closeDatabase(database);
        }
    }

    @Override
    public void handleConflict(String iRemoteNodeId, Object localResult, Object remoteResult) {
        OReplicationConflictResolver resolver = this.getDatabaseSynchronizer().getConflictResolver();
        resolver.handleDeleteConflict(iRemoteNodeId, this.rid);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeUTF(this.rid.toString());
        if (this.version == null) {
            this.version = OVersionFactory.instance().createUntrackedVersion();
        }
        this.version.getSerializer().writeTo((DataOutput)out, this.version);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.rid = new ORecordId(in.readUTF());
        if (this.version == null) {
            this.version = OVersionFactory.instance().createUntrackedVersion();
        }
        this.version.getSerializer().readFrom((DataInput)in, this.version);
    }

    @Override
    public String getName() {
        return "record_delete";
    }

    @Override
    public ODatabaseJournal.OPERATION_TYPES getOperationType() {
        return ODatabaseJournal.OPERATION_TYPES.RECORD_DELETE;
    }
}

