/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.task;

import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.conflict.OReplicationConflictResolver;
import com.orientechnologies.orient.server.distributed.task.OAbstractReplicatedTask;
import com.orientechnologies.orient.server.journal.ODatabaseJournal;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class OSQLCommandTask
extends OAbstractReplicatedTask<Object> {
    private static final long serialVersionUID = 1L;
    protected String text;

    public OSQLCommandTask() {
    }

    public OSQLCommandTask(OServer iServer, ODistributedServerManager iDistributedSrvMgr, String databaseName, ODistributedServerManager.EXECUTION_MODE iMode, String iCommand) {
        super(iServer, iDistributedSrvMgr, databaseName, iMode);
        this.text = iCommand;
    }

    public OSQLCommandTask(long iRunId, long iOperationId, String iCommand) {
        this.text = iCommand;
    }

    @Override
    public void handleConflict(String iRemoteNodeId, Object localResult, Object remoteResult) {
        OReplicationConflictResolver resolver = this.getDatabaseSynchronizer().getConflictResolver();
        resolver.handleCommandConflict(iRemoteNodeId, this.text, localResult, remoteResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object executeOnLocalNode() {
        ODistributedServerLog.debug((Object)this, this.getDistributedServerManager().getLocalNodeId(), this.getNodeSource(), ODistributedServerLog.DIRECTION.IN, "execute command=%s db=%s", this.text.toString(), this.databaseName);
        ODatabaseDocumentTx db = this.openDatabase();
        try {
            Object result = this.openDatabase().command((OCommandRequest)new OCommandSQL(this.text)).execute(new Object[0]);
            if (this.mode != ODistributedServerManager.EXECUTION_MODE.FIRE_AND_FORGET) {
                Object object = result;
                return object;
            }
            Object var3_4 = null;
            return var3_4;
        }
        finally {
            this.closeDatabase(db);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeUTF(this.text);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.text = in.readUTF();
    }

    @Override
    public String getName() {
        return "command_sql";
    }

    @Override
    public String toString() {
        return this.getName() + "(" + this.text + ")";
    }

    @Override
    public ODatabaseJournal.OPERATION_TYPES getOperationType() {
        return ODatabaseJournal.OPERATION_TYPES.SQL_COMMAND;
    }

    @Override
    public String getPayload() {
        return this.text;
    }
}

