/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.OBinaryProtocol;
import com.orientechnologies.orient.core.serialization.serializer.OJSONWriter;
import com.orientechnologies.orient.server.network.protocol.http.OHttpUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;

public class OHttpResponse {
    public static final String JSON_FORMAT = "type,indent:-1,rid,version,attribSameRow,class";
    public static final char[] URL_SEPARATOR = new char[]{'/'};
    private final OutputStream out;
    public final String httpVersion;
    public String headers;
    public String[] additionalHeaders;
    public String characterSet;
    public String contentType;
    public String serverInfo;
    public String sessionId;
    public String callbackFunction;
    public String contentEncoding;
    public boolean sendStarted = false;

    public OHttpResponse(OutputStream iOutStream, String iHttpVersion, String[] iAdditionalHeaders, String iResponseCharSet, String iServerInfo, String iSessionId, String iCallbackFunction) {
        this.out = iOutStream;
        this.httpVersion = iHttpVersion;
        this.additionalHeaders = iAdditionalHeaders;
        this.characterSet = iResponseCharSet;
        this.serverInfo = iServerInfo;
        this.sessionId = iSessionId;
        this.callbackFunction = iCallbackFunction;
    }

    public void send(int iCode, String iReason, String iContentType, Object iContent, String iHeaders) throws IOException {
        this.send(iCode, iReason, iContentType, iContent, iHeaders, true);
    }

    public void send(int iCode, String iReason, String iContentType, Object iContent, String iHeaders, boolean iKeepAlive) throws IOException {
        String contentType;
        String content;
        if (this.sendStarted) {
            return;
        }
        this.sendStarted = true;
        if (this.callbackFunction != null) {
            content = this.callbackFunction + "(" + iContent + ")";
            contentType = "text/javascript";
        } else {
            content = iContent != null ? iContent.toString() : null;
            contentType = iContentType;
        }
        boolean empty = content == null || content.length() == 0;
        this.writeStatus(empty && iCode == 200 ? 204 : iCode, iReason);
        this.writeHeaders(contentType, iKeepAlive);
        if (iHeaders != null) {
            this.writeLine(iHeaders);
        }
        String sessId = this.sessionId != null ? this.sessionId : "-";
        this.writeLine("Set-Cookie: OSESSIONID=" + sessId + "; Path=/; HttpOnly");
        byte[] binaryContent = null;
        if (!empty) {
            binaryContent = this.contentEncoding != null && this.contentEncoding.equals("gzip") ? this.compress(content) : OBinaryProtocol.string2bytes((String)content);
        }
        this.writeLine("Content-Length: " + (empty ? 0 : binaryContent.length));
        this.writeLine(null);
        if (binaryContent != null) {
            this.out.write(binaryContent);
        }
        this.out.flush();
    }

    public void writeStatus(int iStatus, String iReason) throws IOException {
        this.writeLine(this.httpVersion + " " + iStatus + " " + iReason);
    }

    public void writeHeaders(String iContentType) throws IOException {
        this.writeHeaders(iContentType, true);
    }

    public void writeHeaders(String iContentType, boolean iKeepAlive) throws IOException {
        if (this.headers != null) {
            this.writeLine(this.headers);
        }
        this.writeLine("Date: " + new Date());
        this.writeLine("Content-Type: " + iContentType + "; charset=" + this.characterSet);
        this.writeLine("Server: " + this.serverInfo);
        this.writeLine("Connection: " + (iKeepAlive ? "Keep-Alive" : "close"));
        if (this.contentEncoding != null && this.contentEncoding.length() > 0) {
            this.writeLine("Content-Encoding: " + this.contentEncoding);
        }
        if (this.additionalHeaders != null) {
            for (String h : this.additionalHeaders) {
                this.writeLine(h);
            }
        }
    }

    public void writeLine(String iContent) throws IOException {
        this.writeContent(iContent);
        this.out.write(OHttpUtils.EOL);
    }

    public void writeContent(String iContent) throws IOException {
        if (iContent != null) {
            this.out.write(OBinaryProtocol.string2bytes((String)iContent));
        }
    }

    public void writeResult(Object iResult) throws InterruptedException, IOException {
        this.writeResult(iResult, null);
    }

    public void writeResult(Object iResult, String iFormat) throws InterruptedException, IOException {
        if (iResult == null) {
            this.send(204, "", "text/plain", null, null, true);
        } else {
            if (iResult instanceof Map) {
                iResult = ((Map)((Object)iResult)).entrySet().iterator();
            } else if (OMultiValue.isMultiValue((Object)iResult) && OMultiValue.getSize(iResult) > 0 && !(OMultiValue.getFirstValue(iResult) instanceof OIdentifiable)) {
                ArrayList<ODocument> resultSet = new ArrayList<ODocument>();
                resultSet.add(new ODocument().field("value", iResult));
                iResult = resultSet.iterator();
            } else if (iResult instanceof OIdentifiable) {
                ArrayList<OIdentifiable> resultSet = new ArrayList<OIdentifiable>();
                resultSet.add((OIdentifiable)iResult);
                iResult = resultSet.iterator();
            } else if (iResult instanceof Iterable) {
                iResult = ((Iterable)((Object)iResult)).iterator();
            } else if (OMultiValue.isMultiValue(iResult)) {
                iResult = OMultiValue.getMultiValueIterator(iResult);
            } else {
                ArrayList<ODocument> resultSet = new ArrayList<ODocument>();
                resultSet.add(new ODocument().field("value", iResult));
                iResult = resultSet.iterator();
            }
            if (iResult == null) {
                this.send(204, "", "text/plain", null, null, true);
            } else if (iResult instanceof Iterator) {
                this.writeRecords(iResult, null, iFormat);
            }
        }
    }

    public void writeRecords(Iterable<OIdentifiable> iRecords) throws IOException {
        if (iRecords == null) {
            return;
        }
        this.writeRecords(iRecords.iterator(), null, null);
    }

    public void writeRecords(Iterable<OIdentifiable> iRecords, String iFetchPlan) throws IOException {
        if (iRecords == null) {
            return;
        }
        this.writeRecords(iRecords.iterator(), iFetchPlan, null);
    }

    public void writeRecords(Iterator<OIdentifiable> iRecords) throws IOException {
        this.writeRecords(iRecords, null, null);
    }

    public void writeRecords(Iterator<OIdentifiable> iRecords, String iFetchPlan, String iFormat) throws IOException {
        if (iRecords == null) {
            return;
        }
        if (iFormat == null) {
            iFormat = JSON_FORMAT;
        }
        StringWriter buffer = new StringWriter();
        OJSONWriter json = new OJSONWriter((Writer)buffer, iFormat);
        json.beginObject();
        String format = iFetchPlan != null ? iFormat + ",fetchPlan:" + iFetchPlan : iFormat;
        json.beginCollection(-1, true, "result");
        this.formatMultiValue(iRecords, buffer, format);
        json.endCollection(-1, true);
        json.endObject();
        this.send(200, "OK", "application/json", buffer.toString(), null);
    }

    public void formatMultiValue(Iterator<?> iIterator, StringWriter buffer, String format) throws IOException {
        if (iIterator != null) {
            int counter = 0;
            while (iIterator.hasNext()) {
                Object entry = iIterator.next();
                if (entry == null) continue;
                if (counter++ > 0) {
                    buffer.append(", ");
                }
                if (entry instanceof OIdentifiable) {
                    ORecord rec = ((OIdentifiable)entry).getRecord();
                    try {
                        String objectJson = rec.getRecord().toJSON(format);
                        buffer.append(objectJson);
                    }
                    catch (Exception e) {
                        OLogManager.instance().error((Object)this, "Error transforming record " + rec.getIdentity() + " to JSON", (Throwable)e, new Object[0]);
                    }
                    continue;
                }
                if (OMultiValue.isMultiValue(entry)) {
                    this.formatMultiValue(OMultiValue.getMultiValueIterator(entry), buffer, format);
                    continue;
                }
                buffer.append(OJSONWriter.writeValue(entry, (String)format));
            }
        }
    }

    public void writeRecord(ORecord<?> iRecord) throws IOException {
        this.writeRecord(iRecord, null, null);
    }

    public void writeRecord(ORecord<?> iRecord, String iFetchPlan, String iFormat) throws IOException {
        String format;
        if (iFormat == null) {
            iFormat = JSON_FORMAT;
        }
        String string = format = iFetchPlan != null ? iFormat + ",fetchPlan:" + iFetchPlan : iFormat;
        if (iRecord != null) {
            this.send(200, "OK", "application/json", iRecord.toJSON(format), null);
        }
    }

    public void sendStream(int iCode, String iReason, String iContentType, InputStream iContent, long iSize) throws IOException {
        this.writeStatus(iCode, iReason);
        this.writeHeaders(iContentType);
        this.writeLine("Content-Length: " + iSize);
        this.writeLine(null);
        if (iContent != null) {
            int b;
            while ((b = iContent.read()) > -1) {
                this.out.write(b);
            }
        }
        this.out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] compress(String jsonStr) {
        if (jsonStr == null || jsonStr.length() == 0) {
            return null;
        }
        DeflaterOutputStream gout = null;
        ByteArrayOutputStream baos = null;
        try {
            byte[] incoming = jsonStr.getBytes("UTF-8");
            baos = new ByteArrayOutputStream();
            gout = new GZIPOutputStream(baos);
            gout.write(incoming);
            ((GZIPOutputStream)gout).finish();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (gout != null) {
                    gout.close();
                }
                if (baos != null) {
                    baos.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    public void setHeader(String iHeader) {
        this.headers = iHeader;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public void setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
    }
}

