/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.post;

import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandDocumentAbstract;
import java.util.Collection;
import java.util.Map;

public class OServerCommandPostBatch
extends OServerCommandDocumentAbstract {
    private static final String[] NAMES = new String[]{"POST|batch/*"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(OHttpRequest iRequest, OHttpResponse iResponse) throws Exception {
        this.checkSyntax(iRequest.url, 2, "Syntax error: batch/<database>");
        iRequest.data.commandInfo = "Execute multiple requests in one shot";
        ODatabaseDocumentTx db = null;
        ODocument batch = null;
        int executed = 0;
        try {
            Collection operations;
            db = this.getProfiledDatabaseInstance(iRequest);
            batch = (ODocument)new ODocument().fromJSON(iRequest.content);
            Boolean tx = (Boolean)batch.field("transaction");
            if (tx == null) {
                tx = false;
            }
            if ((operations = (Collection)batch.field("operations")) == null || operations.isEmpty()) {
                throw new IllegalArgumentException("Input JSON has no operations to execute");
            }
            if (tx.booleanValue()) {
                db.begin();
            }
            for (Map operation : operations) {
                String type = (String)operation.get("type");
                Object record = operation.get("record");
                ODocument doc = record instanceof Map ? new ODocument((Map)record) : (ODocument)record;
                if (type.equals("c")) {
                    doc.save();
                    ++executed;
                    continue;
                }
                if (type.equals("u")) {
                    doc.save();
                    ++executed;
                    continue;
                }
                if (!type.equals("d")) continue;
                db.delete(doc.getIdentity());
                ++executed;
            }
            if (tx.booleanValue()) {
                db.commit();
            }
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
        iResponse.send(200, "OK", "text/plain", executed, null, true);
        return false;
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }
}

