/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed;

import com.orientechnologies.common.parser.OSystemVariableResolver;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.version.OVersionFactory;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.OReplicationConfig;
import com.orientechnologies.orient.server.distributed.conflict.OReplicationConflictResolver;
import com.orientechnologies.orient.server.distributed.task.OReadRecordTask;
import com.orientechnologies.orient.server.journal.ODatabaseJournal;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutionException;

public class OStorageSynchronizer {
    private OServer server;
    private ODistributedServerManager cluster;
    private ODatabaseJournal log;
    private OReplicationConflictResolver resolver;

    public OStorageSynchronizer(OServer iServer, ODistributedServerManager iCluster, String iStorageName) throws IOException {
        this.server = iServer;
        this.cluster = iCluster;
        OStorage storage = this.openStorage(iStorageName);
        try {
            this.resolver = this.cluster.getConfictResolverClass().newInstance();
            this.resolver.startup(this.server, iCluster, iStorageName);
        }
        catch (Exception e) {
            ODistributedServerLog.error((Object)this, this.cluster.getLocalNodeId(), null, ODistributedServerLog.DIRECTION.NONE, "cannot create the conflict resolver instance of class '%s'", this.cluster.getConfictResolverClass(), e);
        }
        String logDirectory = OSystemVariableResolver.resolveSystemVariables((String)(this.server.getDatabaseDirectory() + "/" + iStorageName));
        this.log = new ODatabaseJournal(iServer, this.cluster, storage, logDirectory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int recoverUncommited(ODistributedServerManager iCluster, String storageName) throws IOException {
        OStorage storage = this.openStorage(storageName);
        ODistributedServerLog.info((Object)this, iCluster.getLocalNodeId(), "*", ODistributedServerLog.DIRECTION.OUT, "recovering uncommitted operations...", new Object[0]);
        int updated = 0;
        int deleted = 0;
        try {
            for (Map.Entry<ORecordId, Long> entry : this.log.getUncommittedOperations().entrySet()) {
                ORecordId rid = entry.getKey();
                long offset = entry.getValue();
                try {
                    if (this.getConflictResolver().existConflictsForRecord(rid)) continue;
                    OCluster recordCluster = storage.getClusterById(rid.getClusterId());
                    if (recordCluster == null) {
                        ODistributedServerLog.warn((Object)this, iCluster.getLocalNodeId(), null, ODistributedServerLog.DIRECTION.NONE, "Cannot find cluster for RID %s, skip it", rid);
                        continue;
                    }
                    OReplicationConfig replicationData = iCluster.getReplicationData(storageName, recordCluster.getName(), rid, this.cluster.getLocalNodeId(), null);
                    ORawBuffer record = (ORawBuffer)iCluster.execute(OStorageSynchronizer.getClusterNameByRID(storage, rid), rid, new OReadRecordTask(this.server, this.cluster, storageName, rid), replicationData);
                    if (record == null) {
                        storage.deleteRecord(rid, OVersionFactory.instance().createUntrackedVersion(), 0, null);
                        ODistributedServerLog.info((Object)this, iCluster.getLocalNodeId(), "?", ODistributedServerLog.DIRECTION.IN, "restored record %s (delete)", rid);
                        ++deleted;
                    } else {
                        storage.updateRecord(rid, record.buffer, record.version, record.recordType, 0, null);
                        ODistributedServerLog.info((Object)this, iCluster.getLocalNodeId(), "?", ODistributedServerLog.DIRECTION.IN, "restored record %s (update)", rid);
                        ++updated;
                    }
                    this.log.setOperationStatus(offset, null, ODatabaseJournal.OPERATION_STATUS.CANCELED);
                }
                catch (ExecutionException e) {
                    ODistributedServerLog.error((Object)this, iCluster.getLocalNodeId(), null, ODistributedServerLog.DIRECTION.NONE, "error on acquiring uncommitted record %s from other servers. The database could not be unaligned with others nodes!", e, rid);
                }
            }
        }
        catch (Throwable throwable) {
            ODistributedServerLog.info((Object)this, iCluster.getLocalNodeId(), "*", ODistributedServerLog.DIRECTION.OUT, "recovered %d operations: updated=%d deleted=%d", updated + deleted, updated, deleted);
            throw throwable;
        }
        ODistributedServerLog.info((Object)this, iCluster.getLocalNodeId(), "*", ODistributedServerLog.DIRECTION.OUT, "recovered %d operations: updated=%d deleted=%d", updated + deleted, updated, deleted);
        return updated + deleted;
    }

    public OReplicationConflictResolver getConflictResolver() {
        return this.resolver;
    }

    public ODatabaseJournal getLog() {
        return this.log;
    }

    public String toString() {
        return this.log != null ? this.log.getStorage().getName() : "<no-log>";
    }

    public static String getClusterNameByRID(OStorage iStorage, ORecordId iRid) {
        OCluster cluster = iStorage.getClusterById(iRid.clusterId);
        return cluster != null ? cluster.getName() : "*";
    }

    protected OStorage openStorage(String iName) {
        OStorage stg = Orient.instance().getStorage(iName);
        if (stg == null) {
            ODistributedServerLog.warn((Object)this, this.cluster.getLocalNodeId(), null, ODistributedServerLog.DIRECTION.NONE, "Initializing storage '%s'...", iName);
            String url = this.server.getStorageURL(iName);
            if (url == null) {
                throw new IllegalArgumentException("Database '" + iName + "' is not configured on local server");
            }
            stg = Orient.instance().loadStorage(url);
            stg.open(null, null, null);
        }
        return stg;
    }
}

