/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.conflict;

import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.ODatabaseComplex;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.orientechnologies.orient.core.version.ORecordVersion;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.config.OServerUserConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.conflict.OReplicationConflictResolver;
import java.util.Date;
import java.util.List;

public class ODefaultReplicationConflictResolver
implements OReplicationConflictResolver {
    private static final String DISTRIBUTED_CONFLICT_CLASS = "ODistributedConflict";
    private static final String FIELD_RECORD = "record";
    private static final String FIELD_NODE = "node";
    private static final String FIELD_DATE = "date";
    private static final String FIELD_OPERATION = "operation";
    private static final String FIELD_OTHER_RID = "otherRID";
    private static final String FIELD_CURRENT_VERSION = "currentVersion";
    private static final String FIELD_OTHER_VERSION = "otherVersion";
    private boolean ignoreIfSameContent;
    private boolean ignoreIfMergeOk;
    private boolean latestAlwaysWin;
    private ODatabaseComplex<?> database;
    private OIndex<?> index = null;
    private OServer serverInstance;
    private ODistributedServerManager cluster;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startup(OServer iServer, ODistributedServerManager iCluster, String iDatabaseName) {
        this.serverInstance = iServer;
        this.cluster = iCluster;
        ODefaultReplicationConflictResolver oDefaultReplicationConflictResolver = this;
        synchronized (oDefaultReplicationConflictResolver) {
            if (this.index != null) {
                return;
            }
            OServerUserConfiguration replicatorUser = this.serverInstance.getUser("replicator");
            ODatabaseRecord threadDb = ODatabaseRecordThreadLocal.INSTANCE.getIfDefined();
            this.database = threadDb != null && !threadDb.isClosed() && threadDb.getStorage().getName().equals(iDatabaseName) ? threadDb : this.serverInstance.openDatabase("document", iDatabaseName, replicatorUser.name, replicatorUser.password);
            OClass cls = this.database.getMetadata().getSchema().getClass(DISTRIBUTED_CONFLICT_CLASS);
            if (cls == null) {
                cls = this.database.getMetadata().getSchema().createClass(DISTRIBUTED_CONFLICT_CLASS);
                this.index = cls.createProperty(FIELD_RECORD, OType.LINK).createIndex(OClass.INDEX_TYPE.UNIQUE);
            } else {
                OProperty p = cls.getProperty(FIELD_RECORD);
                this.index = p == null ? cls.createProperty(FIELD_RECORD, OType.LINK).createIndex(OClass.INDEX_TYPE.UNIQUE) : p.getIndex();
            }
        }
    }

    @Override
    public void shutdown() {
        if (this.database != null) {
            this.database.close();
        }
        if (this.index != null) {
            this.index = null;
        }
    }

    @Override
    public void handleCreateConflict(String iRemoteNode, ORecordId iCurrentRID, int iCurrentVersion, ORecordId iOtherRID, int iOtherVersion) {
        if (iCurrentRID.equals((Object)iOtherRID)) {
            ODistributedServerLog.debug((Object)this, this.cluster.getLocalNodeId(), iRemoteNode, ODistributedServerLog.DIRECTION.IN, "Found conflict between versions on CREATE record %s/%s v.%d (other RID=%s v.%d). Current record version will be overwritten and no exception will be thrown", this.database.getName(), iCurrentRID, iCurrentVersion, iOtherRID, iOtherVersion);
            ORecordInternal record = (ORecordInternal)iCurrentRID.getRecord();
            record.setVersion(iOtherVersion - 1);
            record.setDirty();
            record.save();
            return;
        }
        ODistributedServerLog.warn((Object)this, this.cluster.getLocalNodeId(), iRemoteNode, ODistributedServerLog.DIRECTION.IN, "Conflict on CREATE record %s/%s v.%d (other RID=%s v.%d)...", this.database.getName(), iCurrentRID, iCurrentVersion, iOtherRID, iOtherVersion);
        if (!this.existConflictsForRecord(iCurrentRID)) {
            ODocument doc = this.createConflictDocument((byte)3, iCurrentRID, iRemoteNode);
            try {
                doc.field(FIELD_OTHER_RID, (Object)iOtherRID);
                doc.save();
            }
            catch (Exception e) {
                this.errorOnWriteConflict(iRemoteNode, doc);
            }
        }
    }

    @Override
    public void handleUpdateConflict(String iRemoteNode, ORecordId iCurrentRID, ORecordVersion iCurrentVersion, ORecordVersion iOtherVersion) {
        ODistributedServerLog.warn((Object)this, this.cluster.getLocalNodeId(), iRemoteNode, ODistributedServerLog.DIRECTION.IN, "Conflict on UDPATE record %s/%s (current=v%d, other=v%d)...", this.database.getName(), iCurrentRID, iCurrentVersion.getCounter(), iOtherVersion.getCounter());
        if (!this.existConflictsForRecord(iCurrentRID)) {
            ODocument doc = this.createConflictDocument((byte)1, iCurrentRID, iRemoteNode);
            try {
                doc.field(FIELD_CURRENT_VERSION, (Object)iCurrentVersion.getCounter());
                doc.field(FIELD_OTHER_VERSION, (Object)iOtherVersion.getCounter());
                doc.save();
            }
            catch (Exception e) {
                this.errorOnWriteConflict(iRemoteNode, doc);
            }
        }
    }

    @Override
    public void handleDeleteConflict(String iRemoteNode, ORecordId iCurrentRID) {
        ODistributedServerLog.warn((Object)this, this.cluster.getLocalNodeId(), iRemoteNode, ODistributedServerLog.DIRECTION.IN, "Conflict on DELETE record %s/%s (cannot be deleted on other node)", this.database.getName(), iCurrentRID);
        if (!this.existConflictsForRecord(iCurrentRID)) {
            ODocument doc = this.createConflictDocument((byte)2, iCurrentRID, iRemoteNode);
            try {
                doc.save();
            }
            catch (Exception e) {
                this.errorOnWriteConflict(iRemoteNode, doc);
            }
        }
    }

    @Override
    public void handleCommandConflict(String iRemoteNode, Object iCommand, Object iLocalResult, Object iRemoteResult) {
        ODistributedServerLog.warn((Object)this, this.cluster.getLocalNodeId(), iRemoteNode, ODistributedServerLog.DIRECTION.IN, "Conflict on COMMAND execution on db '%s', cmd='%s' result local=%s, remote=%s", this.database.getName(), iCommand, iLocalResult, iRemoteResult);
    }

    @Override
    public ODocument getAllConflicts() {
        ODatabaseRecordThreadLocal.INSTANCE.set((ODatabaseRecord)this.database);
        List entries = this.database.query((OQuery)new OSQLSynchQuery("select from ODistributedConflict"), new Object[0]);
        ODocument result = new ODocument().field("result", (Object)entries);
        for (int i = 0; i < entries.size(); ++i) {
            ODocument record = (ODocument)((OIdentifiable)entries.get(i)).getRecord();
            record.setClassName(null);
            record.addOwner((ORecordElement)result);
            record.getIdentity().reset();
            Byte operation = (Byte)record.field(FIELD_OPERATION);
            record.field(FIELD_OPERATION, (Object)ORecordOperation.getName((int)operation.byteValue()));
            entries.set(i, record);
        }
        return result;
    }

    @Override
    public ODocument reset() {
        ODatabaseRecordThreadLocal.INSTANCE.set((ODatabaseRecord)this.database);
        int deleted = (Integer)this.database.command((OCommandRequest)new OSQLSynchQuery("delete from ODistributedConflict")).execute(new Object[0]);
        return new ODocument().field("result", (Object)deleted);
    }

    @Override
    public boolean existConflictsForRecord(ORecordId iRID) {
        ODatabaseRecordThreadLocal.INSTANCE.set((ODatabaseRecord)this.database);
        if (this.index == null) {
            ODistributedServerLog.warn((Object)this, this.cluster.getLocalNodeId(), null, ODistributedServerLog.DIRECTION.NONE, "Index against %s is not available right now, searches will be slower", DISTRIBUTED_CONFLICT_CLASS);
            List result = this.database.query((OQuery)new OSQLSynchQuery("select from ODistributedConflict where record = " + iRID.toString()), new Object[0]);
            return !result.isEmpty();
        }
        if (this.index.contains((Object)iRID)) {
            ODistributedServerLog.info((Object)this, this.cluster.getLocalNodeId(), null, ODistributedServerLog.DIRECTION.NONE, "Conflict already present for record %s, skip it", iRID);
            return true;
        }
        return false;
    }

    protected ODocument createConflictDocument(byte iOperation, ORecordId iRid, String iServerNode) {
        ODatabaseRecordThreadLocal.INSTANCE.set((ODatabaseRecord)this.database);
        ODocument doc = new ODocument(DISTRIBUTED_CONFLICT_CLASS);
        doc.field(FIELD_OPERATION, (Object)iOperation);
        doc.field(FIELD_DATE, (Object)new Date());
        doc.field(FIELD_RECORD, (Object)iRid);
        doc.field(FIELD_NODE, (Object)iServerNode);
        return doc;
    }

    protected void errorOnWriteConflict(String iRemoteNode, ODocument doc) {
        ODistributedServerLog.error((Object)this, this.cluster.getLocalNodeId(), iRemoteNode, ODistributedServerLog.DIRECTION.IN, "Error on saving CONFLICT for record %s/%s...", this.database.getName(), doc);
    }
}

