/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.task;

import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.OStorageSynchronizer;
import com.orientechnologies.orient.server.distributed.task.OAbstractRemoteTask;
import com.orientechnologies.orient.server.distributed.task.OAbstractReplicatedTask;
import com.orientechnologies.orient.server.distributed.task.OAlignResponseTask;
import com.orientechnologies.orient.server.distributed.task.OMultipleRemoteTasks;
import com.orientechnologies.orient.server.journal.ODatabaseJournal;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;

public class OAlignRequestTask
extends OAbstractRemoteTask<Integer> {
    private static final long serialVersionUID = 1L;
    protected long lastRunId;
    protected long lastOperationId;
    protected static final int OP_BUFFER = 150;

    public OAlignRequestTask() {
    }

    public OAlignRequestTask(OServer iServer, ODistributedServerManager iDistributedSrvMgr, String iDbName, ODistributedServerManager.EXECUTION_MODE iMode, long iLastRunId, long iLastOperationId) {
        super(iServer, iDistributedSrvMgr, iDbName, iMode);
        this.lastRunId = iLastRunId;
        this.lastOperationId = iLastOperationId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer call() throws Exception {
        int totAligned;
        if (this.lastRunId == -1L && this.lastOperationId == -1L) {
            ODistributedServerLog.info((Object)this, this.getDistributedServerManager().getLocalNodeId(), this.getNodeSource(), ODistributedServerLog.DIRECTION.IN, "db=%s align request starting from the beginning (no log found)", this.databaseName);
        } else {
            ODistributedServerLog.info((Object)this, this.getDistributedServerManager().getLocalNodeId(), this.getNodeSource(), ODistributedServerLog.DIRECTION.IN, "db=%s align request starting from operation %d.%d", this.databaseName, this.lastRunId, this.lastOperationId);
        }
        ODistributedServerManager dManager = this.getDistributedServerManager();
        String localNode = dManager.getLocalNodeId();
        OStorageSynchronizer synchronizer = this.getDatabaseSynchronizer();
        if (synchronizer == null) {
            return 0;
        }
        ODatabaseJournal log = synchronizer.getLog();
        Lock alignmentLock = dManager.getLock("align." + this.databaseName);
        if (alignmentLock.tryLock()) {
            try {
                totAligned = 0;
                int aligned = 0;
                ODistributedServerLog.warn((Object)this, this.getDistributedServerManager().getLocalNodeId(), this.getNodeSource(), ODistributedServerLog.DIRECTION.OUT, "****** BEGIN PREPARING ALIGNMENT BLOCK db=%s ******", this.databaseName);
                OMultipleRemoteTasks tasks = new OMultipleRemoteTasks(this.serverInstance, dManager, this.databaseName, ODistributedServerManager.EXECUTION_MODE.SYNCHRONOUS);
                ArrayList<Long> positions = new ArrayList<Long>();
                Iterator<Long> it = log.browseLastOperations(new long[]{this.lastRunId, this.lastOperationId}, ODatabaseJournal.OPERATION_STATUS.COMMITTED, -1);
                while (it.hasNext()) {
                    long pos = it.next();
                    OAbstractReplicatedTask<?> operation = log.getOperation(pos);
                    if (operation == null) {
                        ODistributedServerLog.info((Object)this, this.getDistributedServerManager().getLocalNodeId(), this.getNodeSource(), ODistributedServerLog.DIRECTION.OUT, "#%d db=%s skipped operation", aligned, this.databaseName);
                        continue;
                    }
                    ODistributedServerLog.info((Object)this, this.getDistributedServerManager().getLocalNodeId(), this.getNodeSource(), ODistributedServerLog.DIRECTION.OUT, "#%d aligning operation=%d.%d db=%s %s", aligned, operation.getRunId(), operation.getOperationSerial(), this.databaseName, operation);
                    operation.setNodeSource(localNode);
                    operation.setDatabaseName(this.databaseName);
                    operation.setMode(ODistributedServerManager.EXECUTION_MODE.SYNCHRONOUS);
                    tasks.addTask(operation);
                    positions.add(pos);
                    ++aligned;
                    if (tasks.getTasks() < 150) continue;
                    totAligned += this.flushBufferedTasks(dManager, synchronizer, tasks, positions);
                }
                if (tasks.getTasks() > 0) {
                    totAligned += this.flushBufferedTasks(dManager, synchronizer, tasks, positions);
                }
                ODistributedServerLog.warn((Object)this, this.getDistributedServerManager().getLocalNodeId(), this.getNodeSource(), ODistributedServerLog.DIRECTION.OUT, "****** END PREPARING ALIGNMENT BLOCK db=%s total=%d ******", this.databaseName, totAligned);
            }
            finally {
                alignmentLock.unlock();
            }
        } else {
            totAligned = -1;
        }
        dManager.sendOperation2Node(this.getNodeSource(), new OAlignResponseTask(this.serverInstance, dManager, this.databaseName, ODistributedServerManager.EXECUTION_MODE.FIRE_AND_FORGET, totAligned));
        return totAligned;
    }

    protected int flushBufferedTasks(ODistributedServerManager dManager, OStorageSynchronizer synchronizer, OMultipleRemoteTasks tasks, List<Long> positions) throws IOException {
        ODistributedServerLog.info((Object)this, this.getDistributedServerManager().getLocalNodeId(), this.getNodeSource(), ODistributedServerLog.DIRECTION.OUT, "flushing aligning %d operations db=%s...", tasks.getTasks(), this.databaseName);
        Object[] result = (Object[])dManager.sendOperation2Node(this.getNodeSource(), tasks);
        int aligned = tasks.getTasks();
        ODistributedServerLog.info((Object)this, this.getDistributedServerManager().getLocalNodeId(), this.getNodeSource(), ODistributedServerLog.DIRECTION.OUT, " flushed aligning %d operations db=%s...", aligned, this.databaseName);
        tasks.clearTasks();
        positions.clear();
        return aligned;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeLong(this.lastRunId);
        out.writeLong(this.lastOperationId);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.lastRunId = in.readLong();
        this.lastOperationId = in.readLong();
    }

    @Override
    public String getName() {
        return "align_request";
    }
}

