/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.task;

import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.task.OAbstractRemoteTask;
import com.orientechnologies.orient.server.distributed.task.OAbstractReplicatedTask;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;

public class OMultipleRemoteTasks
extends OAbstractRemoteTask<Object[]> {
    private static final long serialVersionUID = 1L;
    private List<OAbstractReplicatedTask<?>> tasks = new ArrayList();

    public OMultipleRemoteTasks() {
    }

    public OMultipleRemoteTasks(OServer iServer, ODistributedServerManager iDistributedSrvMgr, String iDbName, ODistributedServerManager.EXECUTION_MODE iMode) {
        super(iServer, iDistributedSrvMgr, iDbName, iMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] call() throws Exception {
        int executedTasks;
        ODistributedServerLog.warn((Object)this, this.getDistributedServerManager().getLocalNodeId(), this.getNodeSource(), ODistributedServerLog.DIRECTION.IN, "****** BEGIN EXECUTING ALIGNMENT BLOCK db=%s tasks=%d ******", this.databaseName, this.tasks.size());
        Object[] result = new Object[this.tasks.size()];
        try {
            for (executedTasks = 0; executedTasks < this.tasks.size(); ++executedTasks) {
                OAbstractRemoteTask task = this.tasks.get(executedTasks);
                this.serverInstance.getDistributedManager().resetOperationQueue(task.getRunId(), task.getOperationSerial() - 1L);
                result[executedTasks] = task.call();
            }
        }
        catch (Throwable throwable) {
            ODistributedServerLog.warn((Object)this, this.getDistributedServerManager().getLocalNodeId(), this.getNodeSource(), ODistributedServerLog.DIRECTION.IN, "****** END EXECUTING ALIGNMENT BLOCK db=%s tasks=%d/%d ******", this.databaseName, executedTasks, this.tasks.size());
            throw throwable;
        }
        ODistributedServerLog.warn((Object)this, this.getDistributedServerManager().getLocalNodeId(), this.getNodeSource(), ODistributedServerLog.DIRECTION.IN, "****** END EXECUTING ALIGNMENT BLOCK db=%s tasks=%d/%d ******", this.databaseName, executedTasks, this.tasks.size());
        return result;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.tasks.size());
        for (int i = 0; i < this.tasks.size(); ++i) {
            out.writeObject(this.tasks.get(i));
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        int taskSize = in.readInt();
        for (int i = 0; i < taskSize; ++i) {
            this.tasks.add((OAbstractReplicatedTask)in.readObject());
        }
    }

    @Override
    public String getName() {
        return "multiple_requests";
    }

    @Override
    public void setNodeDestination(String masterNodeId) {
        super.setNodeDestination(masterNodeId);
        if (this.tasks != null) {
            for (OAbstractReplicatedTask<?> t : this.tasks) {
                t.setNodeDestination(masterNodeId);
            }
        }
    }

    @Override
    public void setNodeSource(String nodeSource) {
        super.setNodeSource(nodeSource);
        if (this.tasks != null) {
            for (OAbstractReplicatedTask<?> t : this.tasks) {
                t.setNodeSource(nodeSource);
            }
        }
    }

    public int getTasks() {
        return this.tasks.size();
    }

    public void addTask(OAbstractReplicatedTask<?> operation) {
        this.tasks.add(operation);
    }

    public void clearTasks() {
        this.tasks.clear();
    }

    public OAbstractReplicatedTask<?> getTask(int i) {
        return this.tasks.get(i);
    }
}

