/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.task;

import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.task.OAbstractRemoteTask;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class OReadRecordTask
extends OAbstractRemoteTask<ORawBuffer> {
    private static final long serialVersionUID = 1L;
    protected ORecordId rid;

    public OReadRecordTask() {
    }

    public OReadRecordTask(OServer iServer, ODistributedServerManager iDistributedSrvMgr, String iDbName, ORecordId iRid) {
        super(iServer, iDistributedSrvMgr, iDbName, ODistributedServerManager.EXECUTION_MODE.SYNCHRONOUS);
        this.rid = iRid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ORawBuffer call() throws Exception {
        ODatabaseDocumentTx database = this.openDatabase();
        try {
            ORecordInternal record = database.load((ORID)this.rid);
            if (record == null) {
                ORawBuffer oRawBuffer = null;
                return oRawBuffer;
            }
            ORawBuffer oRawBuffer = new ORawBuffer(record);
            return oRawBuffer;
        }
        finally {
            this.closeDatabase(database);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeUTF(this.rid.toString());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.rid = new ORecordId(in.readUTF());
    }

    @Override
    public String getName() {
        return "record_read";
    }
}

