/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.handler;

import com.orientechnologies.orient.server.OClientConnection;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.handler.OServerHandler;
import java.util.Collection;

public class OServerHandlerHelper {
    public static void invokeHandlerCallbackOnClientConnection(OServer iServer, OClientConnection connection) {
        Collection<OServerHandler> handlers = iServer.getPlugins();
        if (handlers != null) {
            for (OServerHandler handler : handlers) {
                handler.onClientConnection(connection);
            }
        }
    }

    public static void invokeHandlerCallbackOnClientDisconnection(OServer iServer, OClientConnection connection) {
        Collection<OServerHandler> handlers = iServer.getPlugins();
        if (handlers != null) {
            for (OServerHandler handler : handlers) {
                handler.onClientDisconnection(connection);
            }
        }
    }

    public static void invokeHandlerCallbackOnBeforeClientRequest(OServer iServer, OClientConnection connection, byte iRequestType) {
        Collection<OServerHandler> handlers = iServer.getPlugins();
        if (handlers != null) {
            for (OServerHandler handler : handlers) {
                handler.onBeforeClientRequest(connection, iRequestType);
            }
        }
    }

    public static void invokeHandlerCallbackOnAfterClientRequest(OServer iServer, OClientConnection connection, byte iRequestType) {
        Collection<OServerHandler> handlers = iServer.getPlugins();
        if (handlers != null) {
            for (OServerHandler handler : handlers) {
                handler.onAfterClientRequest(connection, iRequestType);
            }
        }
    }

    public static void invokeHandlerCallbackOnClientError(OServer iServer, OClientConnection connection, Throwable iThrowable) {
        Collection<OServerHandler> handlers = iServer.getPlugins();
        if (handlers != null) {
            for (OServerHandler handler : handlers) {
                handler.onClientError(connection, iThrowable);
            }
        }
    }
}

