/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.journal;

import com.orientechnologies.common.concur.resource.OSharedResourceAdaptiveExternal;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.id.OClusterPosition;
import com.orientechnologies.orient.core.id.OClusterPositionFactory;
import com.orientechnologies.orient.core.id.OClusterPositionLong;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.fs.OFile;
import com.orientechnologies.orient.core.storage.fs.OFileFactory;
import com.orientechnologies.orient.core.version.ORecordVersion;
import com.orientechnologies.orient.core.version.OVersionFactory;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.task.OAbstractRecordReplicatedTask;
import com.orientechnologies.orient.server.distributed.task.OAbstractReplicatedTask;
import com.orientechnologies.orient.server.distributed.task.OCreateRecordTask;
import com.orientechnologies.orient.server.distributed.task.ODeleteRecordTask;
import com.orientechnologies.orient.server.distributed.task.OSQLCommandTask;
import com.orientechnologies.orient.server.distributed.task.OUpdateRecordTask;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;

public class ODatabaseJournal {
    private static final long[] BEGIN_POSITION = new long[]{-1L, -1L};
    public static final String DIRECTORY = "log";
    public static final String FILENAME = "journal.olj";
    private static final int DEF_START_SIZE = 262144;
    private static final int OFFSET_STATUS = 0;
    private static final int OFFSET_OPERATION_TYPE = 1;
    private static final int OFFSET_VARDATA = 2;
    private static final int OFFSET_BACK_OPERATID = 8;
    private static final int OFFSET_BACK_RUNID = 16;
    private static final int OFFSET_BACK_SIZE = 20;
    private static final int FIXED_SIZE = 22;
    private OServer server;
    private ODistributedServerManager cluster;
    private OSharedResourceAdaptiveExternal lock = new OSharedResourceAdaptiveExternal(OGlobalConfiguration.ENVIRONMENT_CONCURRENT.getValueAsBoolean(), 0, true);
    private OStorage storage;
    private OFile file;
    private boolean synchEnabled = false;
    private long[] lastExecuted = new long[]{-1L, -1L};

    public ODatabaseJournal(OServer iServer, ODistributedServerManager iCluster, OStorage iStorage, String iStartingDirectory) throws IOException {
        this.server = iServer;
        this.cluster = iCluster;
        this.storage = iStorage;
        File osFile = new File(iStartingDirectory + "/" + DIRECTORY);
        if (!osFile.exists()) {
            osFile.mkdirs();
        }
        osFile = new File(iStartingDirectory + "/" + DIRECTORY + "/" + FILENAME);
        this.file = OFileFactory.instance().create("classic", osFile.getAbsolutePath(), "rw");
        if (this.file.exists()) {
            this.file.open();
        } else {
            this.file.create(262144);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws IOException {
        this.lock.acquireExclusiveLock();
        try {
            this.file.shrink(0L);
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    public OStorage getStorage() {
        return this.storage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OAbstractReplicatedTask<?> getOperation(long iOffsetEndOperation) throws IOException {
        OAbstractReplicatedTask task = null;
        this.lock.acquireExclusiveLock();
        try {
            long runId = this.file.readLong(iOffsetEndOperation - 16L);
            long operationId = this.file.readLong(iOffsetEndOperation - 8L);
            int varSize = this.file.readInt(iOffsetEndOperation - 20L);
            long offset = iOffsetEndOperation - 20L - (long)varSize - 2L;
            OPERATION_TYPES operationType = OPERATION_TYPES.values()[this.file.readByte(offset + 1L)];
            switch (operationType) {
                case RECORD_CREATE: {
                    ORawBuffer record;
                    ORecordId rid = new ORecordId((int)this.file.readShort(offset + 2L), OClusterPositionFactory.INSTANCE.valueOf(this.file.readLong(offset + 2L + 2L)));
                    if (rid.isNew()) {
                        rid.clusterPosition = this.storage.getClusterDataRange(rid.clusterId)[1];
                    }
                    if ((record = (ORawBuffer)this.storage.readRecord(rid, null, false, null, false).getResult()) == null) break;
                    task = new OCreateRecordTask(runId, operationId, rid, record.buffer, record.version, record.recordType);
                    break;
                }
                case RECORD_UPDATE: {
                    ORecordId rid = new ORecordId((int)this.file.readShort(offset + 2L), OClusterPositionFactory.INSTANCE.valueOf(this.file.readLong(offset + 2L + 2L)));
                    ORawBuffer record = (ORawBuffer)this.storage.readRecord(rid, null, false, null, false).getResult();
                    if (record == null) break;
                    ORecordVersion version = record.version.copy();
                    version.decrement();
                    task = new OUpdateRecordTask(runId, operationId, rid, record.buffer, version, record.recordType);
                    break;
                }
                case RECORD_DELETE: {
                    ORecordId rid = new ORecordId((int)this.file.readShort(offset + 2L), OClusterPositionFactory.INSTANCE.valueOf(this.file.readLong(offset + 2L + 2L)));
                    ORawBuffer record = (ORawBuffer)this.storage.readRecord(rid, null, false, null, false).getResult();
                    task = new ODeleteRecordTask(runId, operationId, rid, record != null ? record.version : OVersionFactory.instance().createUntrackedVersion());
                    break;
                }
                case SQL_COMMAND: {
                    byte[] buffer = new byte[varSize];
                    this.file.read(offset + 2L, buffer, buffer.length);
                    task = new OSQLCommandTask(runId, operationId, new String(buffer));
                    break;
                }
                default: {
                    OAbstractReplicatedTask<?> oAbstractReplicatedTask = null;
                    return oAbstractReplicatedTask;
                }
            }
            if (task != null) {
                task.setServerInstance(this.server);
            }
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ORID getOperationRID(long iOffsetEndOperation) throws IOException {
        this.lock.acquireExclusiveLock();
        try {
            long runId = this.file.readLong(iOffsetEndOperation - 16L);
            long operationId = this.file.readLong(iOffsetEndOperation - 8L);
            int varSize = this.file.readInt(iOffsetEndOperation - 20L);
            long offset = iOffsetEndOperation - 20L - (long)varSize - 2L;
            OPERATION_TYPES operationType = OPERATION_TYPES.values()[this.file.readByte(offset + 1L)];
            switch (operationType) {
                case RECORD_CREATE: {
                    ORecordId rid = new ORecordId((int)this.file.readShort(offset + 2L), OClusterPositionFactory.INSTANCE.valueOf(this.file.readLong(offset + 2L + 2L)));
                    if (rid.isNew()) {
                        rid.clusterPosition = this.storage.getClusterDataRange(rid.clusterId)[1];
                    }
                    ORecordId oRecordId = rid;
                    return oRecordId;
                }
                case RECORD_UPDATE: {
                    ORecordId oRecordId = new ORecordId((int)this.file.readShort(offset + 2L), OClusterPositionFactory.INSTANCE.valueOf(this.file.readLong(offset + 2L + 2L)));
                    return oRecordId;
                }
                case RECORD_DELETE: {
                    ORecordId oRecordId = new ORecordId((int)this.file.readShort(offset + 2L), OClusterPositionFactory.INSTANCE.valueOf(this.file.readLong(offset + 2L + 2L)));
                    return oRecordId;
                }
            }
            ORID oRID = null;
            return oRID;
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getLastExecutedOperationId() {
        this.lock.acquireSharedLock();
        try {
            long[] lArray = this.lastExecuted;
            return lArray;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getLastJournaledOperationId(OPERATION_STATUS iStatus) throws IOException {
        this.lock.acquireExclusiveLock();
        try {
            int filled = (int)this.file.getFilledUpTo();
            if (filled == 0) {
                long[] lArray = BEGIN_POSITION;
                return lArray;
            }
            Iterator<Long> iter = this.browseLastOperations(BEGIN_POSITION, iStatus, 1);
            if (iter == null || !iter.hasNext()) {
                long[] lArray = BEGIN_POSITION;
                return lArray;
            }
            long[] ids = new long[2];
            while (iter.hasNext()) {
                long offset = iter.next();
                ids[0] = this.file.readLong(offset - 16L);
                ids[1] = this.file.readLong(offset - 8L);
            }
            long[] lArray = ids;
            return lArray;
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getOperationId(long iOffset) throws IOException {
        this.lock.acquireExclusiveLock();
        try {
            int filled = (int)this.file.getFilledUpTo();
            if (filled == 0 || iOffset <= 0L || iOffset > (long)filled) {
                long[] lArray = BEGIN_POSITION;
                return lArray;
            }
            long[] ids = new long[]{this.file.readLong(iOffset - 16L), this.file.readLong(iOffset - 8L)};
            long[] lArray = ids;
            return lArray;
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<Long> browseLastOperations(long[] iRemoteLastOperationId, OPERATION_STATUS iStatus, int iMax) throws IOException {
        LinkedList<Long> result = new LinkedList<Long>();
        this.lock.acquireExclusiveLock();
        try {
            long fileOffset = this.file.getFilledUpTo();
            long[] localOperationId = this.getOperationId(fileOffset);
            while (localOperationId[0] > iRemoteLastOperationId[0] || localOperationId[0] == iRemoteLastOperationId[0] && localOperationId[1] > iRemoteLastOperationId[1]) {
                if (iStatus == null || iStatus == this.getOperationStatus(fileOffset)) {
                    result.add(fileOffset);
                    if (iMax > -1 && result.size() >= iMax) break;
                }
                long prevOffset = this.getPreviousOperation(fileOffset);
                localOperationId = this.getOperationId(prevOffset);
                fileOffset = prevOffset;
            }
            Iterator<Long> iterator = result.descendingIterator();
            return iterator;
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    public Map<ORecordId, Long> getUncommittedOperations() throws IOException {
        OPERATION_STATUS status;
        LinkedHashMap<ORecordId, Long> uncommittedRecords = new LinkedHashMap<ORecordId, Long>();
        long fileOffset = this.file.getFilledUpTo();
        while (fileOffset > 0L && (status = this.getOperationStatus(fileOffset)) != OPERATION_STATUS.COMMITTED) {
            if (status != OPERATION_STATUS.CANCELED) {
                OAbstractReplicatedTask<?> op = this.getOperation(fileOffset);
                ODistributedServerLog.info((Object)this, this.cluster.getLocalNodeId(), null, ODistributedServerLog.DIRECTION.NONE, "db '%s' found uncommitted operation %s", this.storage.getName(), op);
                if (op instanceof OAbstractRecordReplicatedTask) {
                    uncommittedRecords.put(((OAbstractRecordReplicatedTask)op).getRid(), fileOffset);
                }
            }
            fileOffset = this.getPreviousOperation(fileOffset);
        }
        return uncommittedRecords;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOperationStatus(long iOffsetEndOperation, ORecordId iRid, OPERATION_STATUS iStatus) throws IOException {
        this.lock.acquireExclusiveLock();
        try {
            int varSize = this.file.readInt(iOffsetEndOperation - 20L);
            long offset = iOffsetEndOperation - 20L - (long)varSize - 2L;
            ODistributedServerLog.debug((Object)this, this.cluster.getLocalNodeId(), null, ODistributedServerLog.DIRECTION.NONE, "update journal db '%s' on operation #%d.%d rid %s", this.storage.getName(), this.file.readLong(iOffsetEndOperation - 16L), this.file.readLong(iOffsetEndOperation - 8L), iRid);
            this.file.write(offset + 0L, new byte[]{(byte)iStatus.ordinal()});
            if (iRid != null) {
                this.file.writeLong(offset + 2L + 2L, iRid.clusterPosition.longValue());
            }
            this.file.synch();
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    private OPERATION_STATUS getOperationStatus(long iOffsetEndOperation) throws IOException {
        int varSize = this.file.readInt(iOffsetEndOperation - 20L);
        long offset = iOffsetEndOperation - 20L - (long)varSize - 2L;
        return OPERATION_STATUS.values()[this.file.readByte(offset + 0L)];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long append(OAbstractReplicatedTask<?> task) throws IOException {
        OPERATION_TYPES iOperationType = task.getOperationType();
        long iRunId = task.getRunId();
        long iOperationId = task.getOperationSerial();
        this.lock.acquireExclusiveLock();
        try {
            long offset = 0L;
            int varSize = 0;
            switch (iOperationType) {
                case RECORD_CREATE: 
                case RECORD_UPDATE: 
                case RECORD_DELETE: {
                    varSize = ORecordId.PERSISTENT_SIZE;
                    ORecordId rid = ((OAbstractRecordReplicatedTask)task).getRid();
                    ODistributedServerLog.debug((Object)this, this.cluster.getLocalNodeId(), null, ODistributedServerLog.DIRECTION.NONE, "- journaled operation=%d.%d type=%s db=%s rid=%s", iRunId, iOperationId, iOperationType.toString(), this.storage.getName(), rid);
                    offset = this.isUpdatingLast(iRunId, iOperationId) ? this.getOffset2Update(iRunId, iOperationId, iOperationType, varSize) : this.appendOperationLogHeader(iOperationType, varSize);
                    this.file.writeShort(offset + 2L, (short)rid.clusterId);
                    this.file.writeLong(offset + 2L + 2L, rid.clusterPosition.longValue());
                    break;
                }
                case SQL_COMMAND: {
                    OCommandSQL cmd = new OCommandSQL(task.getPayload());
                    String cmdText = cmd.getText();
                    byte[] cmdBinary = cmdText.getBytes();
                    varSize = cmdBinary.length;
                    ODistributedServerLog.debug((Object)this, this.cluster.getLocalNodeId(), null, ODistributedServerLog.DIRECTION.NONE, "- journaled operation=%d.%d type=%s db=%s cmd=%s", iRunId, iOperationId, iOperationType.toString(), this.storage.getName(), cmdText);
                    offset = this.appendOperationLogHeader(iOperationType, varSize);
                    this.file.write(offset + 2L, cmdText.getBytes());
                    break;
                }
            }
            this.file.writeLong(offset + 2L + (long)varSize + 4L, iRunId);
            this.file.writeLong(offset + 2L + (long)varSize + 4L + 8L, iOperationId);
            if (this.synchEnabled) {
                this.file.synch();
            }
            this.lastExecuted[0] = iRunId;
            this.lastExecuted[1] = iOperationId;
            long l = offset + 2L + (long)varSize + 4L + 8L + 8L;
            return l;
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<ODocument> query(OPERATION_STATUS iStatus, int iMaxItems) throws IOException {
        LinkedList<ODocument> result = new LinkedList<ODocument>();
        this.lock.acquireExclusiveLock();
        try {
            Iterator<Long> iter = this.browseLastOperations(new long[]{-1L, -1L}, null, iMaxItems);
            while (iter.hasNext()) {
                long pos = iter.next();
                long runId = this.file.readLong(pos - 16L);
                long operationId = this.file.readLong(pos - 8L);
                int varSize = this.file.readInt(pos - 20L);
                long offset = pos - 20L - (long)varSize - 2L;
                OPERATION_STATUS status = OPERATION_STATUS.values()[this.file.readByte(offset)];
                if (iStatus != null && status != iStatus) continue;
                OPERATION_TYPES operationType = OPERATION_TYPES.values()[this.file.readByte(offset + 1L)];
                ODocument doc = new ODocument();
                doc.setIdentity(-2, (OClusterPosition)new OClusterPositionLong((long)result.size()));
                doc.fields("serial", (Object)(runId + "." + operationId), new Object[]{"status", status, "type", operationType.toString()});
                switch (operationType) {
                    case RECORD_CREATE: {
                        ORecordId rid = new ORecordId((int)this.file.readShort(offset + 2L), OClusterPositionFactory.INSTANCE.valueOf(this.file.readLong(offset + 2L + 2L)));
                        if (rid.isNew()) {
                            rid.clusterPosition = this.storage.getClusterDataRange(rid.clusterId)[1];
                        }
                        doc.fields("rid", (Object)("" + rid), new Object[0]);
                        ORawBuffer record = (ORawBuffer)this.storage.readRecord(rid, null, false, null, false).getResult();
                        if (record == null) break;
                        doc.fields("size", (Object)record.buffer.length, new Object[]{"version", record.version, "recordType", record.recordType});
                        break;
                    }
                    case RECORD_UPDATE: {
                        ORecordId rid = new ORecordId((int)this.file.readShort(offset + 2L), OClusterPositionFactory.INSTANCE.valueOf(this.file.readLong(offset + 2L + 2L)));
                        doc.fields("rid", (Object)rid, new Object[0]);
                        ORawBuffer record = (ORawBuffer)this.storage.readRecord(rid, null, false, null, false).getResult();
                        if (record == null) break;
                        doc.fields("size", (Object)record.buffer.length, new Object[]{"version", record.version, "recordType", record.recordType});
                        break;
                    }
                    case RECORD_DELETE: {
                        ORecordId rid = new ORecordId((int)this.file.readShort(offset + 2L), OClusterPositionFactory.INSTANCE.valueOf(this.file.readLong(offset + 2L + 2L)));
                        doc.fields("rid", (Object)rid, new Object[0]);
                        ORawBuffer record = (ORawBuffer)this.storage.readRecord(rid, null, false, null, false).getResult();
                        if (record == null) break;
                        doc.fields("version", (Object)record.version, new Object[0]);
                        break;
                    }
                    case SQL_COMMAND: {
                        byte[] buffer = new byte[varSize];
                        this.file.read(offset + 2L, buffer, buffer.length);
                        doc.fields("command", (Object)new String(buffer), new Object[0]);
                        break;
                    }
                }
                if (iMaxItems > -1 && result.size() >= iMaxItems) {
                    break;
                }
                if (doc == null) continue;
                result.add(0, doc);
            }
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
        return result;
    }

    protected long appendOperationLogHeader(OPERATION_TYPES iOperationType, int varSize) throws IOException {
        long offset = this.file.allocateSpace((long)(22 + varSize));
        this.file.writeByte(offset + 0L, (byte)OPERATION_STATUS.UNCOMMITTED.ordinal());
        this.file.writeByte(offset + 1L, (byte)iOperationType.ordinal());
        this.file.writeInt(offset + 2L + (long)varSize, varSize);
        return offset;
    }

    protected boolean isUpdatingLast(long runId, long operationId) throws IOException {
        long offset = this.file.getFilledUpTo();
        if (offset > 0L) {
            long localRunId = this.file.readLong(offset - 16L);
            long localOperationId = this.file.readLong(offset - 8L);
            if (localRunId == runId && localOperationId >= operationId) {
                return true;
            }
        }
        return false;
    }

    protected long getOffset2Update(long runId, long operationId, OPERATION_TYPES iOperationType, int varSize) throws IOException {
        long currentOffset = this.file.getFilledUpTo();
        boolean foundMatch = false;
        while (currentOffset > 0L) {
            long localRunId = this.file.readLong(currentOffset - 16L);
            long localOperationId = this.file.readLong(currentOffset - 8L);
            if (localRunId == runId && localOperationId == operationId) {
                foundMatch = true;
                break;
            }
            if (localOperationId < operationId || localRunId != runId) break;
            currentOffset = this.getPreviousOperation(currentOffset);
        }
        if (foundMatch) {
            int var = this.file.readInt(currentOffset - 20L);
            return currentOffset - 20L - (long)var - 2L;
        }
        return this.appendOperationLogHeader(iOperationType, varSize);
    }

    protected long getPreviousOperation(long iPosition) throws IOException {
        int size = this.file.readInt(iPosition - 20L);
        return iPosition - 20L - (long)size - 2L;
    }

    public static enum OPERATION_TYPES {
        RECORD_CREATE,
        RECORD_UPDATE,
        RECORD_DELETE,
        SQL_COMMAND;

    }

    public static enum OPERATION_STATUS {
        UNCOMMITTED,
        COMMITTED,
        CANCELED;

    }
}

