/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.thread.OSoftThread;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.enterprise.channel.OChannel;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import java.io.IOException;
import java.net.Socket;
import java.util.List;

public abstract class ONetworkProtocol
extends OSoftThread {
    protected OServer server;

    public ONetworkProtocol(ThreadGroup group, String name) {
        super(group, name);
    }

    public abstract void config(OServer var1, Socket var2, OContextConfiguration var3, List<?> var4, List<?> var5) throws IOException;

    public abstract String getType();

    public abstract int getVersion();

    public abstract OChannel getChannel();

    public String getListeningAddress() {
        OChannel c = this.getChannel();
        if (c != null) {
            return c.socket.getLocalAddress().getHostAddress();
        }
        return null;
    }

    public OServer getServer() {
        return this.server;
    }

    public void waitNodeIsOnline() {
        ODistributedServerManager mgr = this.server.getDistributedManager();
        if (mgr != null && mgr.isOfflineNode(mgr.getLocalNodeId())) {
            for (int retry = 0; retry < 10; ++retry) {
                if (mgr == null || !mgr.isOfflineNode(mgr.getLocalNodeId())) {
                    return;
                }
                OLogManager.instance().info((Object)this, "Node is not online yet (status=%s), blocking the command until it's online %d/%d", new Object[]{mgr.getStatus(), retry + 1, 10});
                ONetworkProtocol.pauseCurrentThread((long)300L);
            }
            throw new OTimeoutException("Cannot execute operation while the node is not online (status=" + mgr.getStatus() + ")");
        }
    }
}

