/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed;

import com.orientechnologies.common.concur.ONeedRetryException;
import com.orientechnologies.common.concur.resource.OSharedResourceAdaptiveExternal;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.cache.OLevel2RecordCache;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandExecutor;
import com.orientechnologies.orient.core.command.OCommandManager;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestInternal;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.config.OStorageConfiguration;
import com.orientechnologies.orient.core.db.OScenarioThreadLocal;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.id.OClusterPosition;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLDelegate;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.ODataSegment;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.storage.ORecordMetadata;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.OStorageEmbedded;
import com.orientechnologies.orient.core.storage.OStorageOperationResult;
import com.orientechnologies.orient.core.storage.impl.local.OFreezableStorage;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.version.ORecordVersion;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedException;
import com.orientechnologies.orient.server.distributed.ODistributedPartition;
import com.orientechnologies.orient.server.distributed.ODistributedPartitioningStrategy;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.task.OAbstractRecordReplicatedTask;
import com.orientechnologies.orient.server.distributed.task.OCreateRecordTask;
import com.orientechnologies.orient.server.distributed.task.ODeleteRecordTask;
import com.orientechnologies.orient.server.distributed.task.OReadRecordTask;
import com.orientechnologies.orient.server.distributed.task.OSQLCommandTask;
import com.orientechnologies.orient.server.distributed.task.OTxTask;
import com.orientechnologies.orient.server.distributed.task.OUpdateRecordTask;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;

public class ODistributedStorage
implements OStorage,
OFreezableStorage {
    protected final OServer serverInstance;
    protected final ODistributedServerManager dManager;
    protected final OStorageEmbedded wrapped;

    public ODistributedStorage(OServer iServer, OStorageEmbedded wrapped) {
        this.serverInstance = iServer;
        this.dManager = iServer.getDistributedManager();
        this.wrapped = wrapped;
    }

    public boolean isDistributed() {
        return true;
    }

    public Object command(OCommandRequestText iCommand) {
        if (OScenarioThreadLocal.INSTANCE.get() == OScenarioThreadLocal.RUN_MODE.RUNNING_DISTRIBUTED) {
            return this.wrapped.command(iCommand);
        }
        ODistributedConfiguration dConfig = this.dManager.getDatabaseConfiguration(this.getName());
        if (!dConfig.isReplicationActive(null)) {
            return this.wrapped.command(iCommand);
        }
        OCommandExecutor executor = OCommandManager.instance().getExecutor((OCommandRequestInternal)iCommand);
        executor.setProgressListener(iCommand.getProgressListener());
        executor.parse((OCommandRequest)iCommand);
        OCommandExecutor exec = executor instanceof OCommandExecutorSQLDelegate ? ((OCommandExecutorSQLDelegate)executor).getDelegate() : executor;
        boolean distribute = false;
        if (OScenarioThreadLocal.INSTANCE.get() != OScenarioThreadLocal.RUN_MODE.RUNNING_DISTRIBUTED && exec instanceof OCommandDistributedReplicateRequest) {
            distribute = ((OCommandDistributedReplicateRequest)exec).isReplicated();
        }
        if (!distribute) {
            return this.wrapped.executeCommand(iCommand, executor);
        }
        try {
            OSQLCommandTask task = new OSQLCommandTask(iCommand.getText());
            Object result = this.dManager.sendRequest(this.getName(), null, task, ODistributedRequest.EXECUTION_MODE.RESPONSE);
            if (result instanceof ONeedRetryException) {
                throw (ONeedRetryException)((Object)result);
            }
            if (result instanceof Throwable) {
                throw new ODistributedException("Error on execution distributed COMMAND", (Throwable)result);
            }
            return result;
        }
        catch (ONeedRetryException e) {
            throw e;
        }
        catch (Exception e) {
            this.handleDistributedException("Cannot route COMMAND operation to the distributed node", e, new Object[0]);
            return null;
        }
    }

    public OStorageOperationResult<OPhysicalPosition> createRecord(int iDataSegmentId, ORecordId iRecordId, byte[] iContent, ORecordVersion iRecordVersion, byte iRecordType, int iMode, ORecordCallback<OClusterPosition> iCallback) {
        if (OScenarioThreadLocal.INSTANCE.get() == OScenarioThreadLocal.RUN_MODE.RUNNING_DISTRIBUTED) {
            return this.wrapped.createRecord(iDataSegmentId, iRecordId, iContent, iRecordVersion, iRecordType, iMode, iCallback);
        }
        Object result = null;
        try {
            String clusterName = this.getClusterNameByRID(iRecordId);
            ODistributedConfiguration dConfig = this.dManager.getDatabaseConfiguration(this.getName());
            if (!dConfig.isReplicationActive(clusterName)) {
                return this.wrapped.createRecord(iDataSegmentId, iRecordId, iContent, iRecordVersion, iRecordType, iMode, iCallback);
            }
            result = this.dManager.sendRequest(this.getName(), clusterName, new OCreateRecordTask(iRecordId, iContent, iRecordVersion, iRecordType), ODistributedRequest.EXECUTION_MODE.RESPONSE);
            if (result instanceof ONeedRetryException) {
                throw (ONeedRetryException)((Object)result);
            }
            if (result instanceof Throwable) {
                throw new ODistributedException("Error on execution distributed CREATE_RECORD", (Throwable)result);
            }
            iRecordId.clusterPosition = ((OPhysicalPosition)result).clusterPosition;
            return new OStorageOperationResult((Object)((OPhysicalPosition)result));
        }
        catch (ONeedRetryException e) {
            throw e;
        }
        catch (Exception e) {
            this.handleDistributedException("Cannot route CREATE_RECORD operation against %s to the distributed node", e, iRecordId);
            return null;
        }
    }

    public OStorageOperationResult<ORawBuffer> readRecord(ORecordId iRecordId, String iFetchPlan, boolean iIgnoreCache, ORecordCallback<ORawBuffer> iCallback, boolean loadTombstones) {
        if (OScenarioThreadLocal.INSTANCE.get() == OScenarioThreadLocal.RUN_MODE.RUNNING_DISTRIBUTED) {
            return this.wrapped.readRecord(iRecordId, iFetchPlan, iIgnoreCache, iCallback, loadTombstones);
        }
        try {
            String clusterName = this.getClusterNameByRID(iRecordId);
            ODistributedConfiguration dConfig = this.dManager.getDatabaseConfiguration(this.getName());
            if (!dConfig.isReplicationActive(clusterName)) {
                return this.wrapped.readRecord(iRecordId, iFetchPlan, iIgnoreCache, iCallback, loadTombstones);
            }
            ODistributedPartitioningStrategy strategy = this.dManager.getPartitioningStrategy(dConfig.getPartitionStrategy(clusterName));
            ODistributedPartition partition = strategy.getPartition(this.dManager, this.getName(), clusterName);
            if (partition.getNodes().contains(this.dManager.getLocalNodeName())) {
                return this.wrapped.readRecord(iRecordId, iFetchPlan, iIgnoreCache, iCallback, loadTombstones);
            }
            Object result = this.dManager.sendRequest(this.getName(), clusterName, new OReadRecordTask(iRecordId), ODistributedRequest.EXECUTION_MODE.RESPONSE);
            if (result instanceof ONeedRetryException) {
                throw (ONeedRetryException)((Object)result);
            }
            if (result instanceof Throwable) {
                throw new ODistributedException("Error on execution distributed READ_RECORD", (Throwable)result);
            }
            return new OStorageOperationResult((Object)((ORawBuffer)result));
        }
        catch (ONeedRetryException e) {
            throw e;
        }
        catch (Exception e) {
            this.handleDistributedException("Cannot route READ_RECORD operation against %s to the distributed node", e, iRecordId);
            return null;
        }
    }

    public OStorageOperationResult<ORecordVersion> updateRecord(ORecordId iRecordId, byte[] iContent, ORecordVersion iVersion, byte iRecordType, int iMode, ORecordCallback<ORecordVersion> iCallback) {
        if (OScenarioThreadLocal.INSTANCE.get() == OScenarioThreadLocal.RUN_MODE.RUNNING_DISTRIBUTED) {
            return this.wrapped.updateRecord(iRecordId, iContent, iVersion, iRecordType, iMode, iCallback);
        }
        try {
            String clusterName = this.getClusterNameByRID(iRecordId);
            ODistributedConfiguration dConfig = this.dManager.getDatabaseConfiguration(this.getName());
            if (!dConfig.isReplicationActive(clusterName)) {
                return this.wrapped.updateRecord(iRecordId, iContent, iVersion, iRecordType, iMode, iCallback);
            }
            Object result = this.dManager.sendRequest(this.getName(), clusterName, new OUpdateRecordTask(iRecordId, iContent, iVersion, iRecordType), ODistributedRequest.EXECUTION_MODE.RESPONSE);
            if (result instanceof ONeedRetryException) {
                throw (ONeedRetryException)((Object)result);
            }
            if (result instanceof Throwable) {
                throw new ODistributedException("Error on execution distributed UPDATE_RECORD", (Throwable)result);
            }
            return new OStorageOperationResult((Object)((ORecordVersion)result));
        }
        catch (ONeedRetryException e) {
            throw e;
        }
        catch (Exception e) {
            this.handleDistributedException("Cannot route UPDATE_RECORD operation against %s to the distributed node", e, iRecordId);
            return null;
        }
    }

    public String getClusterNameByRID(ORecordId iRid) {
        OCluster cluster = this.getClusterById(iRid.clusterId);
        return cluster != null ? cluster.getName() : "*";
    }

    public OStorageOperationResult<Boolean> deleteRecord(ORecordId iRecordId, ORecordVersion iVersion, int iMode, ORecordCallback<Boolean> iCallback) {
        if (OScenarioThreadLocal.INSTANCE.get() == OScenarioThreadLocal.RUN_MODE.RUNNING_DISTRIBUTED) {
            return this.wrapped.deleteRecord(iRecordId, iVersion, iMode, iCallback);
        }
        try {
            String clusterName = this.getClusterNameByRID(iRecordId);
            ODistributedConfiguration dConfig = this.dManager.getDatabaseConfiguration(this.getName());
            if (!dConfig.isReplicationActive(clusterName)) {
                return this.wrapped.deleteRecord(iRecordId, iVersion, iMode, iCallback);
            }
            Object result = this.dManager.sendRequest(this.getName(), clusterName, new ODeleteRecordTask(iRecordId, iVersion), ODistributedRequest.EXECUTION_MODE.RESPONSE);
            if (result instanceof ONeedRetryException) {
                throw (ONeedRetryException)((Object)result);
            }
            if (result instanceof Throwable) {
                throw new ODistributedException("Error on execution distributed DELETE_RECORD", (Throwable)result);
            }
            return new OStorageOperationResult((Object)true);
        }
        catch (ONeedRetryException e) {
            throw e;
        }
        catch (Exception e) {
            this.handleDistributedException("Cannot route DELETE_RECORD operation against %s to the distributed node", e, iRecordId);
            return null;
        }
    }

    public boolean updateReplica(int dataSegmentId, ORecordId rid, byte[] content, ORecordVersion recordVersion, byte recordType) throws IOException {
        return this.wrapped.updateReplica(dataSegmentId, rid, content, recordVersion, recordType);
    }

    public ORecordMetadata getRecordMetadata(ORID rid) {
        return this.wrapped.getRecordMetadata(rid);
    }

    public boolean cleanOutRecord(ORecordId recordId, ORecordVersion recordVersion, int iMode, ORecordCallback<Boolean> callback) {
        return this.wrapped.cleanOutRecord(recordId, recordVersion, iMode, callback);
    }

    public boolean existsResource(String iName) {
        return this.wrapped.existsResource(iName);
    }

    public <T> T removeResource(String iName) {
        return (T)this.wrapped.removeResource(iName);
    }

    public <T> T getResource(String iName, Callable<T> iCallback) {
        return (T)this.wrapped.getResource(iName, iCallback);
    }

    public void open(String iUserName, String iUserPassword, Map<String, Object> iProperties) {
        this.wrapped.open(iUserName, iUserPassword, iProperties);
    }

    public void create(Map<String, Object> iProperties) {
        this.wrapped.create(iProperties);
    }

    public boolean exists() {
        return this.wrapped.exists();
    }

    public void reload() {
        this.wrapped.reload();
    }

    public void delete() {
        this.wrapped.delete();
    }

    public void close() {
        this.wrapped.close();
    }

    public void close(boolean iForce) {
        this.wrapped.close(iForce);
    }

    public boolean isClosed() {
        return this.wrapped.isClosed();
    }

    public OLevel2RecordCache getLevel2Cache() {
        return this.wrapped.getLevel2Cache();
    }

    public void commit(OTransaction iTx, Runnable callback) {
        if (OScenarioThreadLocal.INSTANCE.get() == OScenarioThreadLocal.RUN_MODE.RUNNING_DISTRIBUTED) {
            this.wrapped.commit(iTx, callback);
        } else {
            try {
                ODistributedConfiguration dConfig = this.dManager.getDatabaseConfiguration(this.getName());
                if (!dConfig.isReplicationActive(null)) {
                    this.wrapped.commit(iTx, callback);
                } else {
                    OTxTask txTask = new OTxTask();
                    block7: for (ORecordOperation op : iTx.getCurrentRecordEntries()) {
                        OAbstractRecordReplicatedTask task;
                        ORecordInternal record = op.getRecord();
                        switch (op.type) {
                            case 3: {
                                task = new OCreateRecordTask((ORecordId)op.record.getIdentity(), record.toStream(), record.getRecordVersion(), record.getRecordType());
                                break;
                            }
                            case 1: {
                                task = new OUpdateRecordTask((ORecordId)op.record.getIdentity(), record.toStream(), record.getRecordVersion(), record.getRecordType());
                                break;
                            }
                            case 2: {
                                task = new ODeleteRecordTask((ORecordId)op.record.getIdentity(), record.getRecordVersion());
                                break;
                            }
                            default: {
                                continue block7;
                            }
                        }
                        txTask.add(task);
                    }
                    this.dManager.sendRequest(this.getName(), null, txTask, ODistributedRequest.EXECUTION_MODE.RESPONSE);
                }
            }
            catch (Exception e) {
                this.handleDistributedException("Cannot route TX operation against distributed node", e, new Object[0]);
            }
        }
    }

    public void rollback(OTransaction iTx) {
        this.wrapped.rollback(iTx);
    }

    public OStorageConfiguration getConfiguration() {
        return this.wrapped.getConfiguration();
    }

    public int getClusters() {
        return this.wrapped.getClusters();
    }

    public Set<String> getClusterNames() {
        return this.wrapped.getClusterNames();
    }

    public OCluster getClusterById(int iId) {
        return this.wrapped.getClusterById(iId);
    }

    public Collection<? extends OCluster> getClusterInstances() {
        return this.wrapped.getClusterInstances();
    }

    public int addCluster(String iClusterType, String iClusterName, String iLocation, String iDataSegmentName, boolean forceListBased, Object ... iParameters) {
        return this.wrapped.addCluster(iClusterType, iClusterName, iLocation, iDataSegmentName, false, iParameters);
    }

    public int addCluster(String iClusterType, String iClusterName, int iRequestedId, String iLocation, String iDataSegmentName, boolean forceListBased, Object ... iParameters) {
        return this.wrapped.addCluster(iClusterType, iClusterName, iRequestedId, iLocation, iDataSegmentName, forceListBased, iParameters);
    }

    public boolean dropCluster(String iClusterName, boolean iTruncate) {
        return this.wrapped.dropCluster(iClusterName, iTruncate);
    }

    public boolean dropCluster(int iId, boolean iTruncate) {
        return this.wrapped.dropCluster(iId, iTruncate);
    }

    public int addDataSegment(String iDataSegmentName) {
        return this.wrapped.addDataSegment(iDataSegmentName);
    }

    public int addDataSegment(String iSegmentName, String iDirectory) {
        return this.wrapped.addDataSegment(iSegmentName, iDirectory);
    }

    public long count(int iClusterId) {
        return this.wrapped.count(iClusterId);
    }

    public long count(int iClusterId, boolean countTombstones) {
        return this.wrapped.count(iClusterId, countTombstones);
    }

    public long count(int[] iClusterIds) {
        return this.wrapped.count(iClusterIds);
    }

    public long count(int[] iClusterIds, boolean countTombstones) {
        return this.wrapped.count(iClusterIds, countTombstones);
    }

    public long getSize() {
        return this.wrapped.getSize();
    }

    public long countRecords() {
        return this.wrapped.countRecords();
    }

    public int getDefaultClusterId() {
        return this.wrapped.getDefaultClusterId();
    }

    public void setDefaultClusterId(int defaultClusterId) {
        this.wrapped.setDefaultClusterId(defaultClusterId);
    }

    public int getClusterIdByName(String iClusterName) {
        return this.wrapped.getClusterIdByName(iClusterName);
    }

    public String getClusterTypeByName(String iClusterName) {
        return this.wrapped.getClusterTypeByName(iClusterName);
    }

    public String getPhysicalClusterNameById(int iClusterId) {
        return this.wrapped.getPhysicalClusterNameById(iClusterId);
    }

    public boolean checkForRecordValidity(OPhysicalPosition ppos) {
        return this.wrapped.checkForRecordValidity(ppos);
    }

    public String getName() {
        return this.wrapped.getName();
    }

    public String getURL() {
        return this.wrapped.getURL();
    }

    public long getVersion() {
        return this.wrapped.getVersion();
    }

    public void synch() {
        this.wrapped.synch();
    }

    public int getUsers() {
        return this.wrapped.getUsers();
    }

    public int addUser() {
        return this.wrapped.addUser();
    }

    public int removeUser() {
        return this.wrapped.removeUser();
    }

    public OClusterPosition[] getClusterDataRange(int currentClusterId) {
        return this.wrapped.getClusterDataRange(currentClusterId);
    }

    public <V> V callInLock(Callable<V> iCallable, boolean iExclusiveLock) {
        return (V)this.wrapped.callInLock(iCallable, iExclusiveLock);
    }

    public <V> V callInRecordLock(Callable<V> iCallable, ORID rid, boolean iExclusiveLock) {
        return (V)this.wrapped.callInRecordLock(iCallable, rid, iExclusiveLock);
    }

    public ODataSegment getDataSegmentById(int iDataSegmentId) {
        return this.wrapped.getDataSegmentById(iDataSegmentId);
    }

    public int getDataSegmentIdByName(String iDataSegmentName) {
        return this.wrapped.getDataSegmentIdByName(iDataSegmentName);
    }

    public boolean dropDataSegment(String iName) {
        return this.wrapped.dropDataSegment(iName);
    }

    public OStorage.STATUS getStatus() {
        return this.wrapped.getStatus();
    }

    public void checkForClusterPermissions(String iClusterName) {
        this.wrapped.checkForClusterPermissions(iClusterName);
    }

    public OPhysicalPosition[] higherPhysicalPositions(int currentClusterId, OPhysicalPosition entry) {
        return this.wrapped.higherPhysicalPositions(currentClusterId, entry);
    }

    public OPhysicalPosition[] ceilingPhysicalPositions(int clusterId, OPhysicalPosition physicalPosition) {
        return this.wrapped.ceilingPhysicalPositions(clusterId, physicalPosition);
    }

    public OPhysicalPosition[] floorPhysicalPositions(int clusterId, OPhysicalPosition physicalPosition) {
        return this.wrapped.floorPhysicalPositions(clusterId, physicalPosition);
    }

    public OPhysicalPosition[] lowerPhysicalPositions(int currentClusterId, OPhysicalPosition entry) {
        return this.wrapped.lowerPhysicalPositions(currentClusterId, entry);
    }

    public OSharedResourceAdaptiveExternal getLock() {
        return this.wrapped.getLock();
    }

    public OStorage getUnderlying() {
        return this.wrapped;
    }

    public String getType() {
        return "distributed";
    }

    protected void handleDistributedException(String iMessage, Exception e, Object ... iParams) {
        OLogManager.instance().error((Object)this, iMessage, (Throwable)e, iParams);
        Throwable t = e.getCause();
        if (t != null) {
            if (t instanceof OException) {
                throw (OException)t;
            }
            if (t.getCause() instanceof OException) {
                throw (OException)t.getCause();
            }
        }
        throw new OStorageException(String.format(iMessage, iParams), (Throwable)e);
    }

    public void freeze(boolean throwException) {
        this.getFreezableStorage().freeze(throwException);
    }

    public void release() {
        this.getFreezableStorage().release();
    }

    public void backup(OutputStream out, Map<String, Object> options, Callable<Object> callable) throws IOException {
        this.wrapped.backup(out, options, callable);
    }

    public void restore(InputStream in, Map<String, Object> options, Callable<Object> callable) throws IOException {
        this.wrapped.restore(in, options, callable);
    }

    private OFreezableStorage getFreezableStorage() {
        if (this.wrapped instanceof OFreezableStorage) {
            return (OFreezableStorage)this.wrapped;
        }
        throw new UnsupportedOperationException("Storage engine " + this.wrapped.getType() + " does not support freeze operation");
    }
}

