/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.task;

import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.type.OBuffer;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedResponse;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.task.OAbstractRemoteTask;
import com.orientechnologies.orient.server.distributed.task.OAbstractReplicatedTask;
import com.orientechnologies.orient.server.distributed.task.OFixUpdateRecordTask;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.concurrent.locks.Lock;

public class ODeployDatabaseTask
extends OAbstractReplicatedTask {
    private static final long serialVersionUID = 1L;
    protected static final int CHUNK_MAX_SIZE = 0x100000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(OServer iServer, ODistributedServerManager iManager, ODatabaseDocumentTx database) throws Exception {
        if (!this.getNodeSource().equals(iManager.getLocalNodeName())) {
            String databaseName = database.getName();
            Lock lock = iManager.getLock(databaseName);
            if (lock.tryLock()) {
                try {
                    ODistributedServerLog.warn((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.OUT, "deploying database %s...", databaseName);
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    database.backup((OutputStream)out, null, null);
                    byte[] buffer = out.toByteArray();
                    ODistributedServerLog.warn((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.OUT, "sending the compressed database %s over the network, total %s", databaseName, OFileUtils.getSizeAsString((long)buffer.length));
                    OBuffer oBuffer = new OBuffer(buffer);
                    return oBuffer;
                }
                finally {
                    lock.unlock();
                }
            }
            ODistributedServerLog.debug((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.NONE, "skip deploying database %s because another node is doing it", databaseName);
        } else {
            ODistributedServerLog.debug((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.NONE, "skip deploying database from the same node", new Object[0]);
        }
        return new OBuffer(new byte[0]);
    }

    @Override
    public OAbstractRemoteTask.RESULT_STRATEGY getResultStrategy() {
        return OAbstractRemoteTask.RESULT_STRATEGY.UNION;
    }

    @Override
    public OAbstractRemoteTask.QUORUM_TYPE getQuorumType() {
        return OAbstractRemoteTask.QUORUM_TYPE.NONE;
    }

    @Override
    public long getTimeout() {
        return 60000L;
    }

    @Override
    public String getPayload() {
        return null;
    }

    @Override
    public String getName() {
        return "deploy_db";
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    @Override
    public OFixUpdateRecordTask getFixTask(ODistributedRequest iRequest, ODistributedResponse iBadResponse, ODistributedResponse iGoodResponse) {
        return null;
    }
}

