/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server;

import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.parser.OSystemVariableResolver;
import com.orientechnologies.common.profiler.OAbstractProfiler;
import com.orientechnologies.common.profiler.OProfilerMBean;
import com.orientechnologies.orient.core.OConstants;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseComplex;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentPool;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.OSecurityAccessException;
import com.orientechnologies.orient.core.exception.OSecurityException;
import com.orientechnologies.orient.core.security.OSecurityManager;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.memory.OStorageMemory;
import com.orientechnologies.orient.server.OServerLifecycleListener;
import com.orientechnologies.orient.server.OServerShutdownHook;
import com.orientechnologies.orient.server.config.OServerConfiguration;
import com.orientechnologies.orient.server.config.OServerConfigurationLoaderXml;
import com.orientechnologies.orient.server.config.OServerEntryConfiguration;
import com.orientechnologies.orient.server.config.OServerHandlerConfiguration;
import com.orientechnologies.orient.server.config.OServerNetworkListenerConfiguration;
import com.orientechnologies.orient.server.config.OServerNetworkProtocolConfiguration;
import com.orientechnologies.orient.server.config.OServerStorageConfiguration;
import com.orientechnologies.orient.server.config.OServerUserConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.handler.OConfigurableHooksManager;
import com.orientechnologies.orient.server.network.OServerNetworkListener;
import com.orientechnologies.orient.server.network.protocol.ONetworkProtocol;
import com.orientechnologies.orient.server.plugin.OServerPlugin;
import com.orientechnologies.orient.server.plugin.OServerPluginInfo;
import com.orientechnologies.orient.server.plugin.OServerPluginManager;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.ReentrantLock;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;

public class OServer {
    protected ReentrantLock lock = new ReentrantLock();
    protected volatile boolean running = true;
    protected OServerConfigurationLoaderXml configurationLoader;
    protected OServerConfiguration configuration;
    protected OContextConfiguration contextConfiguration;
    protected OServerShutdownHook shutdownHook;
    protected Map<String, Class<? extends ONetworkProtocol>> networkProtocols = new HashMap<String, Class<? extends ONetworkProtocol>>();
    protected List<OServerNetworkListener> networkListeners = new ArrayList<OServerNetworkListener>();
    protected List<OServerLifecycleListener> lifecycleListeners = new ArrayList<OServerLifecycleListener>();
    protected OServerPluginManager pluginManager;
    protected OConfigurableHooksManager hookManager;
    protected ODistributedServerManager distributedManager;
    private ODatabaseDocumentPool dbPool;
    private final CountDownLatch startupLatch = new CountDownLatch(1);
    private Random random = new Random();
    private Map<String, Object> variables = new HashMap<String, Object>();
    private String databaseDirectory;
    private static ThreadGroup threadGroup;
    private static Map<String, OServer> distributedServers;

    public OServer() throws ClassNotFoundException, MalformedObjectNameException, NullPointerException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        this.defaultSettings();
        OLogManager.installCustomFormatter();
        threadGroup = new ThreadGroup("OrientDB Server");
        OGlobalConfiguration.STORAGE_KEEP_OPEN.setValue((Object)true);
        System.setProperty("com.sun.management.jmxremote", "true");
        Orient.instance().startup();
        if (OGlobalConfiguration.PROFILER_ENABLED.getValueAsBoolean() && !Orient.instance().getProfiler().isRecording()) {
            Orient.instance().getProfiler().startRecording();
        }
        this.shutdownHook = new OServerShutdownHook(this);
    }

    public OServer startup() throws InstantiationException, IllegalAccessException, ClassNotFoundException, IllegalArgumentException, SecurityException, InvocationTargetException, NoSuchMethodException {
        String config = "config/orientdb-server-config.xml";
        if (System.getProperty("orientdb.config.file") != null) {
            config = System.getProperty("orientdb.config.file");
        }
        Orient.instance().startup();
        this.startup(new File(config));
        Orient.instance().getProfiler().registerHookValue("system.databases", "List of databases configured in Server", OProfilerMBean.METRIC_TYPE.TEXT, new OAbstractProfiler.OProfilerHookValue(){

            public Object getValue() {
                StringBuilder dbs = new StringBuilder();
                for (String dbName : OServer.this.getAvailableStorageNames().keySet()) {
                    if (dbs.length() > 0) {
                        dbs.append(',');
                    }
                    dbs.append(dbName);
                }
                return dbs.toString();
            }
        });
        return this;
    }

    public OServer startup(File iConfigurationFile) throws InstantiationException, IllegalAccessException, ClassNotFoundException, IllegalArgumentException, SecurityException, InvocationTargetException, NoSuchMethodException {
        return this.startup(this.loadConfigurationFromFile(iConfigurationFile));
    }

    public OServer startup(String iConfiguration) throws InstantiationException, IllegalAccessException, ClassNotFoundException, IllegalArgumentException, SecurityException, InvocationTargetException, NoSuchMethodException, IOException {
        return this.startup(new ByteArrayInputStream(iConfiguration.getBytes()));
    }

    public OServer startup(InputStream iInputStream) throws InstantiationException, IllegalAccessException, ClassNotFoundException, IllegalArgumentException, SecurityException, InvocationTargetException, NoSuchMethodException, IOException {
        if (iInputStream == null) {
            throw new OConfigurationException("Configuration file is null");
        }
        this.configurationLoader = new OServerConfigurationLoaderXml(OServerConfiguration.class, iInputStream);
        this.configuration = this.configurationLoader.load();
        return this.startup(this.configuration);
    }

    public OServer startup(OServerConfiguration iConfiguration) throws IllegalArgumentException, SecurityException, InvocationTargetException, NoSuchMethodException {
        OLogManager.instance().info((Object)this, "OrientDB Server v" + OConstants.getVersion() + " is starting up...", new Object[0]);
        Orient.instance();
        this.loadConfiguration(iConfiguration);
        if (OGlobalConfiguration.USE_NODE_ID_CLUSTER_POSITION.getValueAsBoolean()) {
            OLogManager.instance().info((Object)this, "ONodeId will be used as presentation of cluster position,  please do not forget to set " + OGlobalConfiguration.USE_NODE_ID_CLUSTER_POSITION.getKey() + " property to \"true\" value on client side ...", new Object[0]);
        }
        if (OGlobalConfiguration.ENVIRONMENT_DUMP_CFG_AT_STARTUP.getValueAsBoolean()) {
            System.out.println("Dumping environment after server startup...");
            OGlobalConfiguration.dumpConfiguration((PrintStream)System.out);
        }
        this.dbPool = new ODatabaseDocumentPool();
        this.dbPool.setup(this.contextConfiguration.getValueAsInteger(OGlobalConfiguration.DB_POOL_MIN), this.contextConfiguration.getValueAsInteger(OGlobalConfiguration.DB_POOL_MAX), this.contextConfiguration.getValueAsLong(OGlobalConfiguration.DB_POOL_IDLE_TIMEOUT), this.contextConfiguration.getValueAsLong(OGlobalConfiguration.DB_POOL_IDLE_CHECK_DELAY));
        this.databaseDirectory = (String)this.contextConfiguration.getValue("server.database.path", (Object)"${ORIENTDB_HOME}/databases/");
        this.databaseDirectory = OSystemVariableResolver.resolveSystemVariables((String)this.databaseDirectory);
        this.databaseDirectory = this.databaseDirectory.replace("//", "/");
        OLogManager.instance().info((Object)this, "Databases directory: " + new File(this.databaseDirectory).getAbsolutePath(), new Object[0]);
        return this;
    }

    public OServer activate() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        for (OServerLifecycleListener oServerLifecycleListener : this.lifecycleListeners) {
            oServerLifecycleListener.onBeforeActivate();
        }
        for (OServerNetworkProtocolConfiguration oServerNetworkProtocolConfiguration : this.configuration.network.protocols) {
            this.networkProtocols.put(oServerNetworkProtocolConfiguration.name, Class.forName(oServerNetworkProtocolConfiguration.implementation));
        }
        for (OServerNetworkListenerConfiguration oServerNetworkListenerConfiguration : this.configuration.network.listeners) {
            this.networkListeners.add(new OServerNetworkListener(this, oServerNetworkListenerConfiguration.ipAddress, oServerNetworkListenerConfiguration.portRange, oServerNetworkListenerConfiguration.protocol, this.networkProtocols.get(oServerNetworkListenerConfiguration.protocol), oServerNetworkListenerConfiguration.parameters, oServerNetworkListenerConfiguration.commands));
        }
        this.registerPlugins();
        for (OServerLifecycleListener oServerLifecycleListener : this.lifecycleListeners) {
            oServerLifecycleListener.onAfterActivate();
        }
        try {
            this.loadStorages();
            this.loadUsers();
        }
        catch (IOException e) {
            OLogManager.instance().error((Object)this, "Error on reading server configuration.", new Object[]{OConfigurationException.class, e});
        }
        OLogManager.instance().info((Object)this, "OrientDB Server v1.6.5 is active.", new Object[0]);
        this.startupLatch.countDown();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (!this.running) {
            return;
        }
        this.running = false;
        this.shutdownHook.cancel();
        Orient.instance().getProfiler().unregisterHookValue("system.databases");
        for (OServerLifecycleListener l : this.lifecycleListeners) {
            l.onBeforeDeactivate();
        }
        OLogManager.instance().info((Object)this, "OrientDB Server is shutting down...", new Object[0]);
        if (!Orient.isRegisterDatabaseByPath()) {
            try {
                Orient.instance().shutdown();
            }
            catch (Throwable e) {
                OLogManager.instance().error((Object)this, "Error during OrientDB shutdown", e, new Object[0]);
            }
        }
        this.lock.lock();
        try {
            String[] plugins = this.pluginManager.getPluginNames();
            if (plugins.length > 0) {
                OLogManager.instance().info((Object)this, "Shutting down plugins:", new Object[0]);
                for (String pluginName : plugins) {
                    OLogManager.instance().info((Object)this, "- %s", new Object[]{pluginName});
                    OServerPluginInfo plugin = this.pluginManager.getPluginByName(pluginName);
                    try {
                        plugin.shutdown();
                    }
                    catch (Throwable t) {
                        OLogManager.instance().error((Object)this, "Error during server plugin %s shutdown.", t, new Object[]{plugin});
                    }
                }
            }
            if (this.networkProtocols.size() > 0) {
                OLogManager.instance().info((Object)this, "Shutting down protocols", new Object[0]);
                this.networkProtocols.clear();
            }
            if (this.networkListeners.size() > 0) {
                OLogManager.instance().info((Object)this, "Shutting down listeners:", new Object[0]);
                for (OServerNetworkListener l : this.networkListeners) {
                    OLogManager.instance().info((Object)this, "- %s", new Object[]{l});
                    try {
                        l.shutdown();
                    }
                    catch (Throwable e) {
                        OLogManager.instance().error((Object)this, "Error during shutdown of listener %s.", e, new Object[]{l});
                    }
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        for (OServerLifecycleListener l : this.lifecycleListeners) {
            try {
                l.onAfterDeactivate();
            }
            catch (Exception e) {
                OLogManager.instance().error((Object)this, "Error during deactivation of server lifecycle listener %s", (Throwable)e, new Object[]{l});
            }
        }
        OLogManager.instance().info((Object)this, "OrientDB Server shutdown complete", new Object[0]);
        System.out.println();
    }

    public String getStoragePath(String iName) {
        if (iName == null) {
            throw new IllegalArgumentException("Storage path is null");
        }
        String name = iName.indexOf(58) > -1 ? iName.substring(iName.indexOf(58) + 1) : iName;
        String dbName = Orient.isRegisterDatabaseByPath() ? this.getDatabaseDirectory() + name : name;
        String dbPath = Orient.isRegisterDatabaseByPath() ? dbName : this.getDatabaseDirectory() + name;
        OStorage stg = Orient.instance().getStorage(dbName);
        if (stg != null) {
            return stg.getURL();
        }
        String dbURL = this.configuration.getStoragePath(name);
        if (dbURL == null) {
            if (new File(OIOUtils.getPathFromDatabaseName((String)dbPath) + "/default.odh").exists()) {
                dbURL = "local:" + dbPath;
            } else if (new File(OIOUtils.getPathFromDatabaseName((String)dbPath) + "/default.pcl").exists()) {
                dbURL = "plocal:" + dbPath;
            } else {
                throw new OConfigurationException("Database '" + name + "' is not configured on server");
            }
        }
        return dbURL;
    }

    public Map<String, String> getAvailableStorageNames() {
        HashMap<String, String> storages = new HashMap<String, String>();
        if (this.configuration.storages != null && this.configuration.storages.length > 0) {
            for (OServerStorageConfiguration s : this.configuration.storages) {
                storages.put(OIOUtils.getDatabaseNameFromPath((String)s.name), s.path);
            }
        }
        String rootDirectory = this.getDatabaseDirectory();
        this.scanDatabaseDirectory(rootDirectory, new File(rootDirectory), storages);
        for (OStorage storage : Orient.instance().getStorages()) {
            String storageUrl = storage.getURL();
            if (!storage.exists() || storages.containsValue(storageUrl)) continue;
            storages.put(OIOUtils.getDatabaseNameFromPath((String)storage.getName()), storageUrl);
        }
        return storages;
    }

    public String getStorageURL(String iName) {
        if (this.configuration.storages != null && this.configuration.storages.length > 0) {
            for (OServerStorageConfiguration s : this.configuration.storages) {
                if (!s.name.equals(iName)) continue;
                return s.path;
            }
        }
        HashMap<String, String> storages = new HashMap<String, String>();
        String rootDirectory = this.getDatabaseDirectory();
        this.scanDatabaseDirectory(rootDirectory, new File(rootDirectory), storages);
        return (String)storages.get(iName);
    }

    public String getDatabaseDirectory() {
        return this.databaseDirectory;
    }

    public ThreadGroup getServerThreadGroup() {
        return threadGroup;
    }

    public OServerUserConfiguration serverLogin(String iUser, String iPassword, String iResource) {
        if (!this.authenticate(iUser, iPassword, iResource)) {
            throw new OSecurityAccessException("Wrong user/password to [connect] to the remote OrientDB Server instance. Get the user/password from the config/orientdb-server-config.xml file");
        }
        return this.getUser(iUser);
    }

    public boolean authenticate(String iUserName, String iPassword, String iResourceToCheck) {
        OServerUserConfiguration user = this.getUser(iUserName);
        if (user != null && (iPassword == null || user.password.equals(iPassword))) {
            String[] resourceParts;
            if (user.resources.equals("*")) {
                return true;
            }
            for (String r : resourceParts = user.resources.split(",")) {
                if (!r.equals(iResourceToCheck)) continue;
                return true;
            }
        }
        return false;
    }

    public OServerUserConfiguration getUser(String iUserName) {
        return this.configuration.getUser(iUserName);
    }

    public boolean existsStoragePath(String iURL) {
        return this.configuration.getStoragePath(iURL) != null;
    }

    public OServerConfiguration getConfiguration() {
        return this.configuration;
    }

    public void saveConfiguration() throws IOException {
        if (this.configurationLoader != null) {
            this.configurationLoader.save(this.configuration);
        }
    }

    public Map<String, Class<? extends ONetworkProtocol>> getNetworkProtocols() {
        return this.networkProtocols;
    }

    public List<OServerNetworkListener> getNetworkListeners() {
        return this.networkListeners;
    }

    public <RET extends OServerNetworkListener> RET getListenerByProtocol(Class<? extends ONetworkProtocol> iProtocolClass) {
        for (OServerNetworkListener l : this.networkListeners) {
            if (!iProtocolClass.isAssignableFrom(l.getProtocolType())) continue;
            return (RET)l;
        }
        return null;
    }

    public Collection<OServerPluginInfo> getPlugins() {
        return this.pluginManager.getPlugins();
    }

    public OContextConfiguration getContextConfiguration() {
        return this.contextConfiguration;
    }

    public <RET extends OServerPlugin> RET getPluginByClass(Class<RET> iPluginClass) {
        try {
            this.startupLatch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        for (OServerPluginInfo h : this.getPlugins()) {
            if (h.getInstance() == null || !h.getInstance().getClass().equals(iPluginClass)) continue;
            return (RET)h.getInstance();
        }
        return null;
    }

    public <RET extends OServerPlugin> RET getPlugin(String iName) {
        try {
            this.startupLatch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        OServerPluginInfo p = this.pluginManager.getPluginByName(iName);
        if (p != null) {
            return (RET)p.getInstance();
        }
        return null;
    }

    public Object getVariable(String iName) {
        return this.variables.get(iName);
    }

    public OServer setVariable(String iName, Object iValue) {
        if (iValue == null) {
            this.variables.remove(iName);
        } else {
            this.variables.put(iName, iValue);
        }
        return this;
    }

    protected void loadConfiguration(OServerConfiguration iConfiguration) {
        this.configuration = iConfiguration;
        this.contextConfiguration = new OContextConfiguration();
        if (iConfiguration.properties != null) {
            for (OServerEntryConfiguration prop : iConfiguration.properties) {
                this.contextConfiguration.setValue(prop.name, (Object)prop.value);
            }
        }
        this.hookManager = new OConfigurableHooksManager(iConfiguration);
    }

    protected OServerConfiguration loadConfigurationFromFile(File iFile) {
        try {
            this.configurationLoader = new OServerConfigurationLoaderXml(OServerConfiguration.class, iFile);
            return this.configurationLoader.load();
        }
        catch (IOException e) {
            OLogManager.instance().error((Object)this, "Error on reading server configuration from file: " + iFile, (Throwable)e, OConfigurationException.class, new Object[0]);
            return null;
        }
    }

    protected void loadUsers() throws IOException {
        if (this.configuration.users != null && this.configuration.users.length > 0) {
            for (OServerUserConfiguration u : this.configuration.users) {
                if (!u.name.equals("root")) continue;
                return;
            }
        }
        this.createAdminAndDbListerUsers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadStorages() {
        if (this.configuration.storages == null) {
            return;
        }
        for (OServerStorageConfiguration stg : this.configuration.storages) {
            int idx;
            if (!stg.loadOnStartup) continue;
            if (stg.userName == null) {
                stg.userName = "admin";
            }
            if (stg.userPassword == null) {
                stg.userPassword = "admin";
            }
            if ((idx = stg.path.indexOf(58)) == -1) {
                OLogManager.instance().error((Object)this, "-> Invalid path '" + stg.path + "' for database '" + stg.name + "'", new Object[0]);
                return;
            }
            String type = stg.path.substring(0, idx);
            ODatabaseDocumentTx db = null;
            try {
                db = new ODatabaseDocumentTx(stg.path);
                if (db.exists()) {
                    db.open(stg.userName, stg.userPassword);
                } else {
                    db.create();
                    if (stg.userName.equals("admin")) {
                        if (!stg.userPassword.equals("admin")) {
                            db.getMetadata().getSecurity().getUser("admin").setPassword(stg.userPassword);
                        }
                    } else {
                        db.getMetadata().getSecurity().createUser(stg.userName, stg.userPassword, new String[]{"admin"});
                        db.getMetadata().getSecurity().dropUser("admin");
                        db.close();
                        db.open(stg.userName, stg.userPassword);
                    }
                }
                OLogManager.instance().info((Object)this, "-> Loaded " + type + " database '" + stg.name + "'", new Object[0]);
            }
            catch (Exception e) {
                OLogManager.instance().error((Object)this, "-> Cannot load " + type + " database '" + stg.name + "': " + e, new Object[0]);
            }
            finally {
                if (db != null) {
                    db.close();
                }
            }
        }
    }

    public void addUser(String iName, String iPassword, String iPermissions) throws IOException {
        if (iName == null || iName.length() == 0) {
            throw new IllegalArgumentException("User name null or empty");
        }
        if (iPermissions == null || iPermissions.length() == 0) {
            throw new IllegalArgumentException("User permissions null or empty");
        }
        this.configuration.users = this.configuration.users == null ? new OServerUserConfiguration[1] : Arrays.copyOf(this.configuration.users, this.configuration.users.length + 1);
        if (iPassword == null) {
            iPassword = OSecurityManager.instance().digest2String(String.valueOf(this.random.nextLong()), false);
        }
        this.configuration.users[this.configuration.users.length - 1] = new OServerUserConfiguration(iName, iPassword, iPermissions);
        this.saveConfiguration();
    }

    public OServer registerLifecycleListener(OServerLifecycleListener iListener) {
        this.lifecycleListeners.add(iListener);
        return this;
    }

    public OServer unregisterLifecycleListener(OServerLifecycleListener iListener) {
        this.lifecycleListeners.remove(iListener);
        return this;
    }

    protected void createAdminAndDbListerUsers() throws IOException {
        this.addUser("root", null, "*");
        this.addUser("guest", "guest", "connect,server.listDatabases,server.dblist");
        this.saveConfiguration();
    }

    protected void registerPlugins() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        this.pluginManager = new OServerPluginManager();
        this.pluginManager.config(this);
        this.pluginManager.startup();
        if (this.configuration.handlers != null) {
            for (OServerHandlerConfiguration h : this.configuration.handlers) {
                OServerPlugin handler = (OServerPlugin)Class.forName(h.clazz).newInstance();
                if (handler instanceof ODistributedServerManager) {
                    this.distributedManager = (ODistributedServerManager)((Object)handler);
                }
                this.pluginManager.registerPlugin(new OServerPluginInfo(handler.getName(), null, null, null, handler, null, 0L, null));
                handler.config(this, h.parameters);
                handler.startup();
            }
        }
    }

    protected void defaultSettings() {
        OGlobalConfiguration.TX_USE_LOG.setValue((Object)true);
        OGlobalConfiguration.TX_COMMIT_SYNCH.setValue((Object)true);
    }

    protected void scanDatabaseDirectory(String rootDirectory, File directory, Map<String, String> storages) {
        if (directory.exists() && directory.isDirectory()) {
            for (File db : directory.listFiles()) {
                String dbPath;
                if (!db.isDirectory()) continue;
                File localFile = new File(db.getAbsolutePath() + "/default.odh");
                File plocalFile = new File(db.getAbsolutePath() + "/default.pcl");
                if (localFile.exists()) {
                    dbPath = db.getPath().replace('\\', '/');
                    storages.put(OIOUtils.getDatabaseNameFromPath((String)dbPath.substring(rootDirectory.length())), "local:" + dbPath);
                    continue;
                }
                if (plocalFile.exists()) {
                    dbPath = db.getPath().replace('\\', '/');
                    storages.put(OIOUtils.getDatabaseNameFromPath((String)dbPath.substring(rootDirectory.length())), "plocal:" + dbPath);
                    continue;
                }
                this.scanDatabaseDirectory(rootDirectory, db, storages);
            }
        }
    }

    public ODatabaseComplex<?> openDatabase(String iDbType, String iDbUrl, String iUser, String iPassword) {
        String path = this.getStoragePath(iDbUrl);
        ODatabaseDocumentTx database = Orient.instance().getDatabaseFactory().createDatabase(iDbType, path);
        if (database.isClosed()) {
            if (database.getStorage() instanceof OStorageMemory) {
                database.create();
            } else {
                try {
                    database.open(iUser, iPassword);
                }
                catch (OSecurityException e) {
                    try {
                        this.serverLogin(iUser, iPassword, "database.passthrough");
                    }
                    catch (OSecurityException ex) {
                        throw e;
                    }
                    database.setProperty(ODatabase.OPTIONS.SECURITY.toString(), (Object)Boolean.FALSE);
                    database.open(iUser, iPassword);
                }
            }
        }
        return database;
    }

    public ODistributedServerManager getDistributedManager() {
        return this.distributedManager;
    }

    public ODatabaseDocumentPool getDatabasePool() {
        return this.dbPool;
    }

    public static OServer getInstance(String iServerId) {
        return distributedServers.get(iServerId);
    }

    public static void registerServerInstance(String iServerId, OServer iServer) {
        distributedServers.put(iServerId, iServer);
    }

    static {
        distributedServers = new ConcurrentHashMap<String, OServer>();
    }
}

