/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.parser.OSystemVariableResolver;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseComplex;
import com.orientechnologies.orient.core.db.ODatabaseLifecycleListener;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.OStorageEmbedded;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.config.OServerParameterConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedException;
import com.orientechnologies.orient.server.distributed.ODistributedPartitioningStrategy;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ODistributedStorage;
import com.orientechnologies.orient.server.distributed.conflict.OReplicationConflictResolver;
import com.orientechnologies.orient.server.plugin.OServerPluginAbstract;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public abstract class ODistributedAbstractPlugin
extends OServerPluginAbstract
implements ODistributedServerManager,
ODatabaseLifecycleListener {
    public static final String REPLICATOR_USER = "replicator";
    protected static final String MASTER_AUTO = "$auto";
    protected static final String PAR_DEF_DISTRIB_DB_CONFIG = "configuration.db.default";
    protected static final String FILE_DISTRIBUTED_DB_CONFIG = "distributed-config.json";
    protected OServer serverInstance;
    protected Map<String, ODocument> cachedDatabaseConfiguration = new HashMap<String, ODocument>();
    protected boolean enabled = true;
    protected String nodeName = null;
    protected Class<? extends OReplicationConflictResolver> confictResolverClass;
    protected File defaultDatabaseConfigFile;
    protected Map<String, ODistributedPartitioningStrategy> strategies = new HashMap<String, ODistributedPartitioningStrategy>();

    @Override
    public void config(OServer oServer, OServerParameterConfiguration[] iParams) {
        this.serverInstance = oServer;
        oServer.setVariable("ODistributedAbstractPlugin", this);
        for (OServerParameterConfiguration param : iParams) {
            if (param.name.equalsIgnoreCase("enabled")) {
                if (Boolean.parseBoolean(OSystemVariableResolver.resolveSystemVariables((String)param.value))) continue;
                this.enabled = false;
                return;
            }
            if (param.name.equalsIgnoreCase("nodeName")) {
                this.nodeName = param.value;
                continue;
            }
            if (param.name.startsWith(PAR_DEF_DISTRIB_DB_CONFIG)) {
                this.defaultDatabaseConfigFile = new File(OSystemVariableResolver.resolveSystemVariables((String)param.value));
                if (this.defaultDatabaseConfigFile.exists()) continue;
                throw new OConfigurationException("Cannot find distributed database config file: " + this.defaultDatabaseConfigFile);
            }
            if (param.name.equalsIgnoreCase("conflict.resolver.impl")) {
                try {
                    this.confictResolverClass = Class.forName(param.value);
                }
                catch (ClassNotFoundException e) {
                    OLogManager.instance().error((Object)this, "Cannot find the conflict resolver implementation '%s'", (Throwable)e, new Object[]{param.value});
                }
                continue;
            }
            if (!param.name.startsWith("sharding.strategy.")) continue;
            try {
                this.strategies.put(param.name.substring("sharding.strategy.".length()), (ODistributedPartitioningStrategy)Class.forName(param.value).newInstance());
            }
            catch (Exception e) {
                OLogManager.instance().error((Object)this, "Cannot create sharding strategy instance '%s'", (Throwable)e, new Object[]{param.value});
                e.printStackTrace();
            }
        }
        if (this.serverInstance.getUser(REPLICATOR_USER) == null) {
            try {
                this.serverInstance.addUser(REPLICATOR_USER, null, "database.passthrough");
                this.serverInstance.saveConfiguration();
            }
            catch (IOException e) {
                throw new OConfigurationException("Error on creating 'replicator' user", (Throwable)e);
            }
        }
    }

    @Override
    public void startup() {
        if (!this.enabled) {
            return;
        }
        Orient.instance().addDbLifecycleListener((ODatabaseLifecycleListener)this);
    }

    @Override
    public void shutdown() {
        if (!this.enabled) {
            return;
        }
        Orient.instance().removeDbLifecycleListener((ODatabaseLifecycleListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onOpen(ODatabase iDatabase) {
        String dbDirectory = this.serverInstance.getDatabaseDirectory();
        if (!iDatabase.getURL().substring(iDatabase.getURL().indexOf(":") + 1).startsWith(dbDirectory)) {
            return;
        }
        Map<String, ODocument> map = this.cachedDatabaseConfiguration;
        synchronized (map) {
            ODistributedConfiguration cfg = this.getDatabaseConfiguration(iDatabase.getName());
            if (cfg == null) {
                return;
            }
            if (cfg.isReplicationActive(null) && iDatabase instanceof ODatabaseComplex && !(iDatabase.getStorage() instanceof ODistributedStorage)) {
                ((ODatabaseComplex)iDatabase).replaceStorage((OStorage)new ODistributedStorage(this.serverInstance, (OStorageEmbedded)((ODatabaseComplex)iDatabase).getStorage()));
            }
        }
    }

    public void onClose(ODatabase iDatabase) {
    }

    @Override
    public void sendShutdown() {
        super.sendShutdown();
    }

    public String getName() {
        return "cluster";
    }

    @Override
    public String getLocalNodeId() {
        return this.nodeName;
    }

    public ODistributedPartitioningStrategy getReplicationStrategy(String iStrategy) {
        ODistributedPartitioningStrategy strategy;
        if (iStrategy.startsWith("$")) {
            iStrategy = iStrategy.substring(1);
        }
        if ((strategy = this.strategies.get(iStrategy)) == null) {
            throw new ODistributedException("Configured strategy '" + iStrategy + "' is not configured");
        }
        return strategy;
    }

    @Override
    public ODistributedPartitioningStrategy getPartitioningStrategy(String iStrategyName) {
        return this.strategies.get(iStrategyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ODocument loadDatabaseConfiguration(String iDatabaseName, File file) {
        if (!file.exists() || file.length() == 0L) {
            return null;
        }
        ODistributedServerLog.info((Object)this, this.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.NONE, "loaded database configuration from disk: %s", file);
        FileInputStream f = null;
        try {
            f = new FileInputStream(file);
            byte[] buffer = new byte[(int)file.length()];
            f.read(buffer);
            ODocument doc = (ODocument)new ODocument().fromJSON(new String(buffer), "noMap");
            this.updateCachedDatabaseConfiguration(iDatabaseName, doc);
            ODocument oDocument = doc;
            return oDocument;
        }
        catch (Exception e) {
        }
        finally {
            if (f != null) {
                try {
                    f.close();
                }
                catch (IOException e) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCachedDatabaseConfiguration(String iDatabaseName, ODocument cfg) {
        Map<String, ODocument> map = this.cachedDatabaseConfiguration;
        synchronized (map) {
            this.cachedDatabaseConfiguration.put(iDatabaseName, cfg);
            OLogManager.instance().info((Object)this, "updated distributed configuration for database: %s:\n----------\n%s\n----------", new Object[]{iDatabaseName, cfg.toJSON("prettyPrint")});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ODistributedConfiguration getDatabaseConfiguration(String iDatabaseName) {
        Map<String, ODocument> map = this.cachedDatabaseConfiguration;
        synchronized (map) {
            ODocument cfg = this.cachedDatabaseConfiguration.get(iDatabaseName);
            if (cfg == null && (cfg = this.cachedDatabaseConfiguration.get("*")) == null && (cfg = this.loadDatabaseConfiguration(iDatabaseName, this.defaultDatabaseConfigFile)) == null) {
                throw new OConfigurationException("Cannot load default distributed database config file: " + this.defaultDatabaseConfigFile);
            }
            return new ODistributedConfiguration(cfg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveDatabaseConfiguration(String iDatabaseName, ODocument cfg) {
        Map<String, ODocument> map = this.cachedDatabaseConfiguration;
        synchronized (map) {
            ODocument oldCfg = this.cachedDatabaseConfiguration.get(iDatabaseName);
            if (oldCfg != null && Arrays.equals(oldCfg.toStream(), cfg.toStream())) {
                return;
            }
        }
        Integer oldVersion = (Integer)cfg.field("version");
        if (oldVersion == null) {
            oldVersion = 0;
        }
        cfg.field("version", (Object)(oldVersion + 1));
        this.updateCachedDatabaseConfiguration(iDatabaseName, cfg);
        FileOutputStream f = null;
        try {
            File file = this.getDistributedConfigFile(iDatabaseName);
            OLogManager.instance().config((Object)this, "Saving distributed configuration file for database '%s' in: %s", new Object[]{iDatabaseName, file});
            f = new FileOutputStream(file);
            f.write(cfg.toJSON().getBytes());
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "Error on saving distributed configuration file", (Throwable)e, new Object[0]);
        }
        finally {
            if (f != null) {
                try {
                    f.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public File getDistributedConfigFile(String iDatabaseName) {
        return new File(this.serverInstance.getDatabaseDirectory() + iDatabaseName + "/" + FILE_DISTRIBUTED_DB_CONFIG);
    }

    public OServer getServerInstance() {
        return this.serverInstance;
    }
}

