/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.task;

import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.tool.ODatabaseImport;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedResponse;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.task.OAbstractRemoteTask;
import com.orientechnologies.orient.server.distributed.task.OAbstractReplicatedTask;
import com.orientechnologies.orient.server.distributed.task.OFixUpdateRecordTask;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;

public class OCopyDatabaseChunkTask
extends OAbstractReplicatedTask {
    private static final long serialVersionUID = 1L;
    private String databaseName;
    private boolean lastChunk = false;
    private byte[] chunkContent;

    public OCopyDatabaseChunkTask() {
    }

    public OCopyDatabaseChunkTask(byte[] chunk) {
        this.chunkContent = chunk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(OServer iServer, ODistributedServerManager iManager, ODatabaseDocumentTx database) throws Exception {
        ODistributedServerLog.warn((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.OUT, "writing database %s in chunk to disk size=%d...", database.getName(), this.chunkContent.length);
        File f = new File("importDatabase/" + database.getName());
        FileOutputStream out = new FileOutputStream(f, true);
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(this.chunkContent);
            try {
                OIOUtils.copyStream((InputStream)in, (OutputStream)out, (int)this.chunkContent.length);
            }
            finally {
                in.close();
            }
        }
        finally {
            out.close();
        }
        if (this.lastChunk) {
            try {
                ODistributedServerLog.warn((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.OUT, "importing database %s...", database.getName());
                ODatabaseImport importDb = new ODatabaseImport((ODatabaseDocument)database, f.getAbsolutePath(), null);
                try {
                    importDb.importDatabase();
                }
                catch (Throwable throwable) {
                    ODistributedServerLog.warn((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.OUT, "database %s imported correctly", database.getName());
                    importDb.close();
                    throw throwable;
                }
                ODistributedServerLog.warn((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.OUT, "database %s imported correctly", database.getName());
                importDb.close();
            }
            finally {
                OFileUtils.deleteRecursively((File)new File("importDatabase"));
            }
        }
        return Boolean.TRUE;
    }

    @Override
    public OAbstractRemoteTask.QUORUM_TYPE getQuorumType() {
        return OAbstractRemoteTask.QUORUM_TYPE.NONE;
    }

    @Override
    public String getPayload() {
        return null;
    }

    @Override
    public OFixUpdateRecordTask getFixTask(ODistributedRequest iRequest, ODistributedResponse iBadResponse, ODistributedResponse iGoodResponse) {
        return null;
    }

    @Override
    public String getName() {
        return "deploy_db";
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.databaseName);
        out.write(this.chunkContent);
        out.writeBoolean(this.lastChunk);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.databaseName = in.readUTF();
        in.read(this.chunkContent);
        this.lastChunk = in.readBoolean();
    }
}

