/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.task;

import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.version.ORecordVersion;
import com.orientechnologies.orient.core.version.OVersionFactory;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedResponse;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.task.OAbstractRecordReplicatedTask;
import com.orientechnologies.orient.server.distributed.task.OAbstractRemoteTask;
import com.orientechnologies.orient.server.distributed.task.OFixCreateRecordTask;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class OCreateRecordTask
extends OAbstractRecordReplicatedTask {
    private static final long serialVersionUID = 1L;
    protected byte[] content;
    protected byte recordType;

    public OCreateRecordTask() {
    }

    public OCreateRecordTask(ORecordId iRid, byte[] iContent, ORecordVersion iVersion, byte iRecordType) {
        super(iRid, iVersion);
        this.content = iContent;
        this.recordType = iRecordType;
    }

    @Override
    public Object execute(OServer iServer, ODistributedServerManager iManager, ODatabaseDocumentTx database) throws Exception {
        ODistributedServerLog.debug((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.IN, "creating record %s/%s v.%s...", database.getName(), this.rid.toString(), this.version.toString());
        ORecordInternal record = Orient.instance().getRecordFactoryManager().newInstance(this.recordType);
        record.fill((ORID)this.rid, this.version, this.content, true);
        if (this.rid.getClusterId() != -1) {
            record.save(database.getClusterNameById(this.rid.getClusterId()), true);
        } else {
            record.save();
        }
        this.rid = (ORecordId)record.getIdentity();
        ODistributedServerLog.debug((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.IN, "+-> assigned new rid %s/%s v.%d", database.getName(), this.rid.toString(), record.getVersion());
        return new OPhysicalPosition(this.rid.getClusterPosition(), record.getRecordVersion());
    }

    @Override
    public OAbstractRemoteTask.QUORUM_TYPE getQuorumType() {
        return OAbstractRemoteTask.QUORUM_TYPE.WRITE;
    }

    @Override
    public OFixCreateRecordTask getFixTask(ODistributedRequest iRequest, ODistributedResponse iBadResponse, ODistributedResponse iGoodResponse) {
        OPhysicalPosition badResult = (OPhysicalPosition)iBadResponse.getPayload();
        OPhysicalPosition goodResult = (OPhysicalPosition)iGoodResponse.getPayload();
        return new OFixCreateRecordTask(new ORecordId(this.rid.getClusterId(), badResult.clusterPosition), this.content, this.version, this.recordType, new ORecordId(this.rid.getClusterId(), goodResult.clusterPosition));
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.rid.toString());
        if (this.content == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.content.length);
            out.write(this.content);
        }
        if (this.version == null) {
            this.version = OVersionFactory.instance().createUntrackedVersion();
        }
        this.version.getSerializer().writeTo((DataOutput)out, this.version);
        out.write(this.recordType);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.rid = new ORecordId(in.readUTF());
        int contentSize = in.readInt();
        if (contentSize == 0) {
            this.content = null;
        } else {
            this.content = new byte[contentSize];
            in.readFully(this.content);
        }
        if (this.version == null) {
            this.version = OVersionFactory.instance().createUntrackedVersion();
        }
        this.version.getSerializer().readFrom((DataInput)in, this.version);
        this.recordType = in.readByte();
    }

    @Override
    public String getName() {
        return "record_create";
    }
}

